/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.Token;
import org.spoofax.terms.StrategoSubList;
import org.spoofax.terms.attachments.ParentAttachment;

public class LayoutStructure {
    private final ISimpleTerm node;
    private final ISimpleTerm listParent;
    private final ITokenizer tokens;
    private int suffixStartIndex;
    private int commentsAfterExclEndIndex;
    private int suffixSeparationExclEndIndex;
    private int prefixEndIndex;
    private int commentsBeforeStartIndex;
    private int prefixSeparationStartIndex;

    public LayoutStructure(IStrategoTerm node) {
        this.node = ImploderAttachment.getImploderOrigin(node);
        this.listParent = this.getParentList();
        this.assertImploderInfo();
        this.tokens = ImploderAttachment.getLeftToken(node).getTokenizer();
        this.analyzeSuffix();
        this.analyzePrefix();
    }

    private void assertImploderInfo() {
        assert (this.node != null) : "Error: Layout analysis can only be applied to nodes with associated origin term";
        if (this.listParent != null) {
            assert (ImploderAttachment.hasImploderOrigin(this.listParent)) : "Unexpected Error: list-parent of imploder-origin must have imploder info";
            int i = 0;
            while (i < this.listParent.getSubtermCount()) {
                assert (ImploderAttachment.hasImploderOrigin(this.listParent.getSubterm(i))) : "Unexpected Error: subterms of origin-list must have imploder info";
                ++i;
            }
        }
    }

    public String getCommentsBefore() {
        String layoutPrefix = this.getLayoutPrefix();
        return this.trimWsPreservingLastNewline(layoutPrefix);
    }

    public String getCommentsAfter() {
        String layoutSuffix = this.getLayoutSuffix();
        return this.trimWsPreservingLastNewline(layoutSuffix);
    }

    public String getLayoutPrefix() {
        return this.layoutFragmentWithOutSeparator(this.commentsBeforeStartIndex, this.prefixEndIndex);
    }

    public String getLayoutSuffix() {
        return this.layoutFragmentWithOutSeparator(this.suffixStartIndex, this.commentsAfterExclEndIndex - 1);
    }

    public String getTextWithLayout() {
        return String.valueOf(this.getTokenString(this.commentsBeforeStartIndex, ImploderAttachment.getRightToken(this.node).getIndex())) + this.getLayoutSuffix();
    }

    public String getIndentation() {
        String indent = this.getIndentString();
        assert (indent.replaceAll("[ \t]", "").equals(""));
        return indent;
    }

    public String getSeparation() {
        return this.getSeparationString();
    }

    public int getDeletionStartOffset() {
        if (this.isLastListElement()) {
            assert (this.isValidTokenIndex(this.prefixSeparationStartIndex));
            return this.getTokenAt(this.prefixSeparationStartIndex).getStartOffset();
        }
        return this.getInsertBeforeOffset();
    }

    public int getDeletionEndOffset() {
        if (this.isLastListElement()) {
            int deletionEndOffset = this.getInsertAtEndOffset() - 1;
            return this.keepNewlineOfLineComment(deletionEndOffset);
        }
        if (this.isValidTokenIndex(this.suffixSeparationExclEndIndex)) {
            int deletionEndOffset = this.getTokenAt(this.suffixSeparationExclEndIndex).getStartOffset() - 1;
            return deletionEndOffset;
        }
        assert (ImploderAttachment.getRightToken(this.node).getIndex() == this.tokens.getTokenCount() - 1);
        return ImploderAttachment.getRightToken(this.node).getEndOffset();
    }

    public int getInsertBeforeOffset() {
        assert (this.commentsBeforeStartIndex <= ImploderAttachment.getLeftToken(this.node).getStartOffset());
        int offset = this.getTokenAt(this.commentsBeforeStartIndex).getStartOffset();
        String input = this.tokens.getInput();
        while (offset < input.length() && (input.charAt(offset) == ' ' || input.charAt(offset) == '\t')) {
            ++offset;
        }
        return offset;
    }

    public int getInsertAtEndOffset() {
        int tokenIndex = this.commentsAfterExclEndIndex;
        if (this.isValidTokenIndex(tokenIndex)) {
            if (this.node.isList() && this.node.getSubtermCount() == 0) {
                while (this.isLayout(tokenIndex - 1)) {
                    --tokenIndex;
                }
            }
            return this.getTokenAt(tokenIndex).getStartOffset();
        }
        assert (ImploderAttachment.getRightToken(this.node).getIndex() == this.tokens.getTokenCount() - 1);
        return ImploderAttachment.getRightToken(this.node).getEndOffset() + 1;
    }

    private String layoutFragmentWithOutSeparator(int loIndexStart, int loIndexEnd) {
        String result = "";
        int i = loIndexStart;
        while (i <= loIndexEnd) {
            if (!this.isValidTokenIndex(i)) break;
            if (this.isLayout(i)) {
                result = String.valueOf(result) + this.getTokenString(i);
            } else {
                assert (this.isSeparatorToken(i));
                result = String.valueOf(result) + this.createSpaces(this.getTokenAt(i).getLength());
            }
            ++i;
        }
        return result;
    }

    private String createSpaces(int length) {
        String spaces = "";
        int i = 0;
        while (i < length) {
            spaces = String.valueOf(spaces) + " ";
            ++i;
        }
        return spaces;
    }

    private int keepNewlineOfLineComment(int deletionEndOffset) {
        while (Character.isWhitespace(this.getCharAt(deletionEndOffset))) {
            --deletionEndOffset;
        }
        return deletionEndOffset;
    }

    private void analyzePrefix() {
        int prefixSeparatorIndex;
        this.prefixEndIndex = ImploderAttachment.getLeftToken(this.node).getIndex() - 1;
        int prefixStartIndex = this.getPrefixIndexStart(this.prefixEndIndex);
        this.commentsBeforeStartIndex = ImploderAttachment.getLeftToken(this.node).getIndex();
        int tokenIndex = this.commentsBeforeStartIndex - 1;
        int lastNonEmptyLine = ImploderAttachment.getLeftToken(this.node).getLine();
        int preceedingAstLine = -1;
        if (this.isValidTokenIndex(prefixStartIndex - 1)) {
            preceedingAstLine = this.getTokenAt(prefixStartIndex - 1).getEndLine();
        }
        boolean sameLineSiblings = this.preceedingSibEndLine() == ImploderAttachment.getLeftToken(this.node).getLine();
        while (this.isValidTokenIndex(tokenIndex) && tokenIndex >= prefixStartIndex) {
            if (this.isComment(tokenIndex)) {
                int commentEndLine = this.getTokenAt(tokenIndex).getEndLine();
                int commentStartLine = this.getTokenAt(tokenIndex).getLine();
                if (lastNonEmptyLine - commentEndLine > 1 || preceedingAstLine == commentStartLine && !sameLineSiblings) break;
                this.commentsBeforeStartIndex = tokenIndex;
                lastNonEmptyLine = this.getTokenAt(tokenIndex).getLine();
            }
            if (this.isSeparatorToken(tokenIndex - 1)) break;
            if (tokenIndex == prefixStartIndex && sameLineSiblings) {
                this.commentsBeforeStartIndex = ImploderAttachment.getLeftToken(this.node).getIndex();
                break;
            }
            --tokenIndex;
        }
        this.prefixSeparationStartIndex = (prefixSeparatorIndex = this.getIndexSeparator(prefixStartIndex, this.prefixEndIndex)) == -1 ? this.commentsBeforeStartIndex : prefixSeparatorIndex;
        while (this.isWhitespace(this.prefixSeparationStartIndex - 1)) {
            --this.prefixSeparationStartIndex;
        }
    }

    private void analyzeSuffix() {
        this.suffixStartIndex = ImploderAttachment.getRightToken(this.node).getIndex() + 1;
        int suffixEndIndex = this.getSuffixIndexEnd(this.suffixStartIndex);
        boolean sameLineSiblings = this.tokensOnSameLine(this.suffixStartIndex - 1, suffixEndIndex + 1) && !this.isLastListElement();
        int tokenIndex = this.commentsAfterExclEndIndex = this.suffixStartIndex;
        while (this.isValidTokenIndex(tokenIndex) && tokenIndex <= suffixEndIndex + 1) {
            if (this.getTokenAt(tokenIndex).getLine() != ImploderAttachment.getRightToken(this.node).getEndLine()) break;
            if (sameLineSiblings && tokenIndex == suffixEndIndex + 1) {
                this.commentsAfterExclEndIndex = this.suffixStartIndex;
                break;
            }
            if (sameLineSiblings && this.isSeparatorToken(tokenIndex)) break;
            if (this.isComment(tokenIndex)) {
                this.commentsAfterExclEndIndex = tokenIndex + 1;
            }
            ++tokenIndex;
        }
        int suffixSeparatorIndex = this.getIndexSeparator(this.suffixStartIndex, suffixEndIndex);
        this.suffixSeparationExclEndIndex = Math.max(this.commentsAfterExclEndIndex, suffixSeparatorIndex + 1);
        while (this.isWhitespace(this.suffixSeparationExclEndIndex)) {
            ++this.suffixSeparationExclEndIndex;
        }
    }

    private boolean isFirstListElement() {
        if (this.listParent == null) {
            return false;
        }
        if (this.node instanceof StrategoSubList) {
            return ((StrategoSubList)this.node).getIndexStart() == 0;
        }
        return this.listParent.getSubterm(0) == this.node;
    }

    private int preceedingSibEndLine() {
        if (this.isFirstListElement()) {
            return -1;
        }
        if (this.listParent == null) {
            return -1;
        }
        int indexPreceedingSib = -1;
        if (this.node instanceof StrategoSubList) {
            indexPreceedingSib = ((StrategoSubList)this.node).getIndexStart() - 1;
            assert (this.listParent == ((StrategoSubList)this.node).getCompleteList());
        } else {
            int i = 1;
            while (i < this.listParent.getSubtermCount()) {
                if (this.listParent.getSubterm(i) == this.node) {
                    indexPreceedingSib = i - 1;
                }
                ++i;
            }
        }
        if (indexPreceedingSib == -1) {
            return -1;
        }
        assert (indexPreceedingSib >= 0 && indexPreceedingSib < this.listParent.getSubtermCount());
        ISimpleTerm preceedingNode = this.listParent.getSubterm(indexPreceedingSib);
        if (!ImploderAttachment.hasImploderOrigin(preceedingNode)) {
            return -1;
        }
        return ImploderAttachment.getRightToken(preceedingNode).getEndLine();
    }

    private boolean isLastListElement() {
        if (this.listParent == null) {
            return false;
        }
        if (this.node instanceof StrategoSubList) {
            return ((StrategoSubList)this.node).getIndexEnd() == this.listParent.getSubtermCount() - 1;
        }
        return this.listParent.getSubterm(this.listParent.getSubtermCount() - 1) == this.node;
    }

    private boolean tokensOnSameLine(int i, int j) {
        if (this.isValidTokenIndex(i) && this.isValidTokenIndex(j)) {
            return this.getTokenAt(i).getLine() == this.getTokenAt(j).getLine();
        }
        return false;
    }

    private IToken getTokenAt(int i) {
        assert (this.isValidTokenIndex(i));
        return this.tokens.getTokenAt(i);
    }

    private char getCharAt(int offset) {
        assert (offset < this.tokens.getInput().length());
        return this.tokens.getInput().charAt(offset);
    }

    private boolean isValidTokenIndex(int j) {
        return j >= 0 && j < this.tokens.getTokenCount();
    }

    private int getSuffixIndexEnd(int suffixStartIndex) {
        int suffixEndIndex = suffixStartIndex;
        while (this.notAssociatedToAstNode(suffixEndIndex + 1)) {
            assert (this.isValidTokenIndex(suffixEndIndex));
            ++suffixEndIndex;
        }
        return suffixEndIndex;
    }

    private int getPrefixIndexStart(int prefixEndTokenIndex) {
        int prefixStartIndex = prefixEndTokenIndex;
        while (this.notAssociatedToAstNode(prefixStartIndex - 1)) {
            assert (this.isValidTokenIndex(prefixStartIndex));
            --prefixStartIndex;
        }
        return prefixStartIndex;
    }

    private int getIndexSeparator(int suffixStartIndex, int suffixEndIndex) {
        int i = suffixEndIndex;
        while (i >= suffixStartIndex) {
            if (this.isSeparatorToken(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private boolean isSeparatorToken(int i) {
        return this.isAssociatedToListParent(i) && !this.isLayout(i);
    }

    private boolean notAssociatedToAstNode(int tokenIndex) {
        return this.isLayout(tokenIndex) || this.isAssociatedToListParent(tokenIndex);
    }

    private boolean isWhitespace(int tokenIndex) {
        return this.isLayout(tokenIndex) && !this.isComment(tokenIndex);
    }

    private boolean isComment(int tokenIndex) {
        return this.isValidTokenIndex(tokenIndex) && this.isLayout(tokenIndex) && !Token.isWhiteSpace(this.getTokenAt(tokenIndex));
    }

    private boolean isLayout(int tokenIndex) {
        return this.isValidTokenIndex(tokenIndex) && this.getTokenAt(tokenIndex).getKind() == 7;
    }

    private boolean isAssociatedToListParent(int tokenIndex) {
        return this.isValidTokenIndex(tokenIndex) && this.listParent != null && this.getTokenAt(tokenIndex).getAstNode() == this.listParent;
    }

    private IStrategoTerm getParentList() {
        if (this.node instanceof StrategoSubList) {
            return ((StrategoSubList)this.node).getCompleteList();
        }
        if (this.node.isList() && this.node.getSubtermCount() > 0) {
            return (IStrategoTerm)this.node;
        }
        if (ParentAttachment.getParent(this.node) == null) {
            return null;
        }
        return ParentAttachment.getParent(this.node).isList() ? ParentAttachment.getParent(this.node) : null;
    }

    private String trimWsPreservingLastNewline(String layoutSuffix) {
        String commentEnd = "";
        if (layoutSuffix.endsWith("\n")) {
            commentEnd = "\n";
        }
        return String.valueOf(layoutSuffix.trim()) + commentEnd;
    }

    private String getIndentString() {
        int offset = ImploderAttachment.getLeftToken(this.node).getStartOffset();
        String input = this.tokens.getInput();
        String indentation = "";
        int i = offset - 1;
        while (i >= 0) {
            char character = input.charAt(i);
            if (character == '\n') {
                return indentation;
            }
            indentation = character == ' ' || character == '\t' ? String.valueOf(character) + indentation : "";
            --i;
        }
        return indentation;
    }

    public String getSeparationString() {
        if (this.listParent != null && this.listParent.getSubtermCount() > 1) {
            IToken startToken = ImploderAttachment.getRightToken(this.listParent.getSubterm(0));
            IToken endToken = ImploderAttachment.getLeftToken(this.listParent.getSubterm(1));
            return this.getSeparationString(startToken.getIndex(), endToken.getIndex());
        }
        return null;
    }

    private String getSeparationString(int tokenIndexStart, int tokenIndexEnd) {
        String separation = "";
        String layoutText = "";
        boolean commentSeen = false;
        boolean commentLine = false;
        int i = tokenIndexStart + 1;
        while (i < tokenIndexEnd) {
            IToken token = this.tokens.getTokenAt(i);
            String tokenText = this.getTokenString(i);
            if (!this.isComment(i)) {
                if (!commentSeen) {
                    separation = String.valueOf(separation) + tokenText;
                } else {
                    layoutText = String.valueOf(layoutText) + tokenText;
                }
            } else {
                commentSeen = true;
                layoutText = "";
                if (tokenText.endsWith("\n")) {
                    layoutText = "\n";
                }
                if (token.getLine() != this.getTokenAt(tokenIndexStart).getEndLine() && token.getEndLine() != this.getTokenAt(tokenIndexEnd).getLine()) {
                    commentLine = true;
                }
            }
            ++i;
        }
        if (commentLine) {
            separation = separation.replaceFirst("\n[ \t]*", "");
        }
        return String.valueOf(separation) + layoutText;
    }

    private String getTokenString(int tokenIndex) {
        assert (this.isValidTokenIndex(tokenIndex));
        IToken t = this.getTokenAt(tokenIndex);
        int startOffset = t.getStartOffset();
        int endOffset = t.getEndOffset();
        return this.tokens.toString(startOffset, endOffset);
    }

    private String getTokenString(int tokenIndexStart, int tokenIndexEnd) {
        assert (this.isValidTokenIndex(tokenIndexStart));
        assert (this.isValidTokenIndex(tokenIndexEnd));
        int startOffset = this.getTokenAt(tokenIndexStart).getStartOffset();
        int endOffset = this.getTokenAt(tokenIndexEnd).getEndOffset();
        return this.tokens.toString(startOffset, endOffset);
    }
}

