/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermTransformer;

public class IndexParentKeyFactory {
    private final ParentURITransformer transformer;

    public IndexParentKeyFactory(ITermFactory termFactory) {
        this.transformer = new ParentURITransformer(termFactory, false);
    }

    public IStrategoTerm getParentKey(IStrategoTerm key) {
        IStrategoTerm parentKey = this.transformer.transform(key);
        if (!this.transformer.transformed) {
            return null;
        }
        return parentKey;
    }

    private class ParentURITransformer
    extends TermTransformer {
        private final ITermFactory factory;
        private final IStrategoConstructor uriConstructor;
        public boolean transformed;

        public ParentURITransformer(ITermFactory factory, boolean keepAttachments) {
            super(factory, keepAttachments);
            this.transformed = false;
            this.factory = factory;
            this.uriConstructor = factory.makeConstructor("URI", 2);
        }

        @Override
        public IStrategoTerm preTransform(IStrategoTerm term) {
            IStrategoTerm parentURI;
            if (this.isURI(term) && (parentURI = this.getParentURI(term)) != null) {
                this.transformed = true;
                return parentURI;
            }
            return term;
        }

        private IStrategoTerm getParentURI(IStrategoTerm uri) {
            IStrategoTerm language = uri.getSubterm(0);
            IStrategoList segments = (IStrategoList)uri.getSubterm(1);
            if (segments.getSubtermCount() == 0) {
                return null;
            }
            return this.makeURI(language, segments.tail());
        }

        private boolean isURI(IStrategoTerm term) {
            if (!Tools.isTermAppl(term)) {
                return false;
            }
            IStrategoAppl appl = (IStrategoAppl)term;
            return appl.getConstructor().equals(this.uriConstructor);
        }

        private IStrategoTerm makeURI(IStrategoTerm language, IStrategoList segments) {
            return this.factory.makeAppl(this.uriConstructor, language, segments);
        }
    }
}

