/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import org.spoofax.interpreter.library.index.IndexEntry;
import org.spoofax.interpreter.library.index.IndexEntryFactory;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class IndexCollector {
    private final ITermFactory termFactory;
    private final IndexEntryFactory entryFactory;
    private final Multiset<IndexEntry> addedEntries = HashMultiset.create();
    private final Multiset<IndexEntry> removedEntries = HashMultiset.create();
    private final Multiset<IndexEntry> oldEntries = HashMultiset.create();
    private IStrategoTerm sourceInCollection = null;

    public IndexCollector(ITermFactory termFactory, IndexEntryFactory entryFactory) {
        this.termFactory = termFactory;
        this.entryFactory = entryFactory;
    }

    public void start(IStrategoTerm source, Iterable<IndexEntry> currentEntries) {
        this.addedEntries.clear();
        this.removedEntries.clear();
        this.oldEntries.clear();
        Iterables.addAll(this.removedEntries, currentEntries);
        Iterables.addAll(this.oldEntries, currentEntries);
        this.sourceInCollection = source;
    }

    public IStrategoTuple stop() {
        this.sourceInCollection = null;
        Multisets.removeOccurrences(this.addedEntries, this.oldEntries);
        return this.termFactory.makeTuple(this.entryFactory.toKeyTerms(this.removedEntries), this.entryFactory.toKeyTerms(this.addedEntries));
    }

    public IndexEntry add(IStrategoTerm key, IStrategoTerm value) {
        return this.add(this.entryFactory.create(key, value, this.sourceInCollection));
    }

    public IndexEntry add(IStrategoTerm key) {
        return this.add(this.entryFactory.create(key, this.sourceInCollection));
    }

    public IndexEntry add(IndexEntry entry) {
        assert (entry.source.match(this.sourceInCollection));
        this.addedEntries.add(entry);
        this.removedEntries.remove(entry);
        return entry;
    }

    public Iterable<IndexEntry> getAddedEntries() {
        return this.addedEntries;
    }

    public boolean inCollection() {
        return this.sourceInCollection != null;
    }

    public void recover() {
        this.reset();
    }

    public void reset() {
        this.addedEntries.clear();
        this.removedEntries.clear();
        this.oldEntries.clear();
        this.sourceInCollection = null;
    }
}

