/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.time;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class Timer {
    private final ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
    private final boolean canLogCPUTime = this.mxBean.isThreadCpuTimeSupported();
    private long startTime = 0L;

    public Timer() {
        this(false);
    }

    public Timer(boolean start2) {
        if (this.canLogCPUTime) {
            this.mxBean.setThreadCpuTimeEnabled(true);
        }
        if (start2) {
            this.start();
        }
    }

    public void start() {
        this.startTime = this.time();
    }

    public long stop() {
        return this.time() - this.startTime;
    }

    public void reset() {
        this.startTime = 0L;
    }

    private long time() {
        if (this.canLogCPUTime) {
            return this.mxBean.getCurrentThreadCpuTime();
        }
        return System.nanoTime();
    }
}

