/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.test;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import org.junit.Assert;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.observable.ITestableObserver;
import org.metaborg.util.observable.TimestampedNotification;
import rx.Notification;

public class Assert2 {
    public static <T> void assertSize(int expected, Iterable<T> actual, String message) {
        int actualSize = Iterables.size(actual);
        if (actualSize != expected) {
            Assert.fail((String)Assert2.formatSize(message, expected, actualSize));
        }
    }

    public static <T> void assertSize(int expected, T[] actual, String message) {
        int actualSize = actual.length;
        if (actualSize != expected) {
            Assert.fail((String)Assert2.formatSize(message, expected, actualSize));
        }
    }

    public static <T> void assertSize(int expected, Iterable<T> actual) {
        Assert2.assertSize(expected, actual, null);
    }

    public static <T> void assertSize(int expected, T[] actual) {
        Assert2.assertSize(expected, actual, null);
    }

    private static String formatSize(String message, int expected, int actual) {
        String formatted = Assert2.preformat(message);
        return String.valueOf(formatted) + "expected size: " + expected + " but was: " + actual;
    }

    public static <T> void assertEmpty(Iterable<T> actual, String message) {
        int actualSize = Iterables.size(actual);
        if (actualSize != 0) {
            Assert.fail((String)Assert2.formatEmpty(message, actualSize));
        }
    }

    public static <T> void assertEmpty(T[] actual, String message) {
        int actualSize = actual.length;
        if (actualSize != 0) {
            Assert.fail((String)Assert2.formatEmpty(message, actualSize));
        }
    }

    public static <T> void assertEmpty(Iterable<T> actual) {
        Assert2.assertEmpty(actual, null);
    }

    public static <T> void assertEmpty(T[] actual) {
        Assert2.assertEmpty(actual, null);
    }

    private static String formatEmpty(String message, int actual) {
        String formatted = Assert2.preformat(message);
        return String.valueOf(formatted) + "expected empty, but size was: " + actual;
    }

    public static <T> void assertIterableEquals(Iterable<T> expected, Iterable<T> actual, String message) {
        if (!Iterables.elementsEqual(expected, actual)) {
            Assert.fail((String)Assert2.formatEquals(message, expected, actual));
        }
    }

    public static <T> void assertIterableEquals(Iterable<T> expected, Iterable<T> actual) {
        Assert2.assertIterableEquals(expected, actual, null);
    }

    public static <T> void assertIterableEquals(String message, Iterable<T> actual, T ... expected) {
        Assert2.assertIterableEquals(Iterables2.from(expected), actual, message);
    }

    public static <T> void assertIterableEquals(Iterable<T> actual, T ... expected) {
        Assert2.assertIterableEquals(null, actual, expected);
    }

    private static <T> String formatEquals(String message, T expected, T actual) {
        String formatted = Assert2.preformat(message);
        String expectedString = String.valueOf(expected);
        String actualString = String.valueOf(actual);
        return String.valueOf(formatted) + "expected: " + Assert2.formatClassAndValue(expected, expectedString) + " but was: " + Assert2.formatClassAndValue(actual, actualString);
    }

    public static <T> void assertContains(T expected, Iterable<? extends T> actual, String message) {
        if (!Iterables.contains(actual, expected)) {
            Assert.fail((String)Assert2.formatContains(message, expected, actual));
        }
    }

    public static <T> void assertContains(T expected, Iterable<? extends T> actual) {
        Assert2.assertContains(expected, actual, null);
    }

    public static <T> void assertContains(T expected, T[] actual, String message) {
        Assert2.assertContains(expected, Iterables2.from(actual), message);
    }

    public static <T> void assertContains(T expected, T[] actual) {
        Assert2.assertContains(expected, actual, null);
    }

    private static <T> String formatContains(String message, T expected, Iterable<? extends T> actual) {
        String formatted = Assert2.preformat(message);
        String expectedString = String.valueOf(expected);
        String actualString = String.valueOf(actual);
        return String.valueOf(formatted) + "expected: " + Assert2.formatClassAndValue(expected, expectedString) + " contained in: " + Assert2.formatClassAndValue(actual, actualString);
    }

    public static <T> void assertNotContains(T expected, Iterable<? extends T> actual, String message) {
        if (Iterables.contains(actual, expected)) {
            Assert.fail((String)Assert2.formatNotContains(message, expected, actual));
        }
    }

    public static <T> void assertNotContains(T expected, Iterable<? extends T> actual) {
        Assert2.assertNotContains(expected, actual, null);
    }

    public static <T> void assertNotContains(T expected, T[] actual, String message) {
        Assert2.assertNotContains(expected, Iterables2.from(actual), message);
    }

    public static <T> void assertNotContains(T expected, T[] actual) {
        Assert2.assertNotContains(expected, actual, null);
    }

    private static <T> String formatNotContains(String message, T expected, Iterable<? extends T> actual) {
        String formatted = Assert2.preformat(message);
        String expectedString = String.valueOf(expected);
        String actualString = String.valueOf(actual);
        return String.valueOf(formatted) + "expected: " + Assert2.formatClassAndValue(expected, expectedString) + " not contained in: " + Assert2.formatClassAndValue(actual, actualString);
    }

    public static <T extends Comparable<T>> void assertCompareLarger(T left, T right, String message) {
        int result = left.compareTo(right);
        if (result < 1) {
            String formatted = Assert2.preformat(message);
            Assert.fail((String)(String.valueOf(formatted) + "expected that: " + left + " > " + right + " but was: " + Assert2.compareIntToChar(result)));
        }
    }

    public static <T extends Comparable<T>> void assertCompareLarger(T left, T right) {
        Assert2.assertCompareLarger(left, right, null);
    }

    public static <T extends Comparable<T>> void assertCompareSmaller(T left, T right, String message) {
        int result = left.compareTo(right);
        if (result > -1) {
            String formatted = Assert2.preformat(message);
            Assert.fail((String)(String.valueOf(formatted) + "expected that: " + left + " < " + right + " but was: " + Assert2.compareIntToChar(result)));
        }
    }

    public static <T extends Comparable<T>> void assertCompareSmaller(T left, T right) {
        Assert2.assertCompareSmaller(left, right, null);
    }

    public static <T extends Comparable<T>> void assertCompareEquals(T left, T right, String message) {
        int result = left.compareTo(right);
        if (result != 0) {
            String formatted = Assert2.preformat(message);
            Assert.fail((String)(String.valueOf(formatted) + "expected that: " + left + " = " + right + " but was: " + Assert2.compareIntToChar(result)));
        }
    }

    public static <T extends Comparable<T>> void assertCompareEquals(T left, T right) {
        Assert2.assertCompareEquals(left, right, null);
    }

    private static char compareIntToChar(int compareInt) {
        if (compareInt > 0) {
            return '>';
        }
        if (compareInt < 0) {
            return '<';
        }
        return '=';
    }

    public static <T> void assertOnNext(Iterable<T> expecteds, ITestableObserver<T> observer, String message) {
        TimestampedNotification<T> timestampedNotificaiton = observer.poll();
        Notification notification = timestampedNotificaiton.notification;
        if (!notification.isOnNext()) {
            Assert.fail((String)Assert2.formatOnNext(message, notification));
        }
        Object value = notification.getValue();
        boolean matches = false;
        for (T expected : expecteds) {
            matches |= value.equals(expected);
        }
        if (!matches) {
            Assert.fail((String)Assert2.formatOnNext(message, expecteds, value));
        }
    }

    public static <T> void assertOnNext(Iterable<T> expecteds, ITestableObserver<T> observer) {
        Assert2.assertOnNext(expecteds, observer, null);
    }

    public static <T> void assertOnNext(T expected, ITestableObserver<T> observer, String message) {
        Object value;
        TimestampedNotification<T> timestampedNotificaiton = observer.poll();
        Notification notification = timestampedNotificaiton.notification;
        if (!notification.isOnNext()) {
            Assert.fail((String)Assert2.formatOnNext(message, notification));
        }
        if (!(value = notification.getValue()).equals(expected)) {
            Assert.fail((String)Assert2.formatOnNext(message, expected, value));
        }
    }

    public static <T> void assertOnNext(T expected, ITestableObserver<T> observer) {
        Assert2.assertOnNext(expected, observer, null);
    }

    private static <T> String formatOnNext(String message, Notification<T> actual) {
        String formatted = Assert2.preformat(message);
        return String.valueOf(formatted) + "expected OnNext, was: " + (Object)((Object)actual.getKind());
    }

    private static <T> String formatOnNext(String message, Iterable<T> expected, T actual) {
        String formatted = Assert2.preformat(message);
        String actualString = String.valueOf(actual);
        return String.valueOf(formatted) + "expected OnNext with a value of: " + Joiner.on(", ").join(expected) + " but was: " + Assert2.formatClassAndValue(actual, actualString);
    }

    private static <T> String formatOnNext(String message, T expected, T actual) {
        String formatted = Assert2.preformat(message);
        String expectedString = String.valueOf(expected);
        String actualString = String.valueOf(actual);
        return String.valueOf(formatted) + "expected OnNext with value: " + Assert2.formatClassAndValue(expected, expectedString) + " but was: " + Assert2.formatClassAndValue(actual, actualString);
    }

    private static String preformat(String message) {
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = String.valueOf(message) + " ";
        }
        return formatted;
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return String.valueOf(className) + "<" + valueString + ">";
    }
}

