/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.metaborg.util.file.IFileAccess;

public class ZipArchiver {
    private final Set<Entry> entries;

    public ZipArchiver(Iterable<Entry> entries) {
        this.entries = Sets.newTreeSet(entries);
    }

    public ZipArchiver() {
        this(Lists.newArrayList());
    }

    public void addFile(String relPath, FileObject file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.getType() == FileType.FOLDER) {
            relPath = ZipArchiver.ensureTrailingSlash(relPath);
        }
        relPath = ZipArchiver.fixSlashes(relPath);
        Entry entry = new Entry(relPath, file);
        this.entries.add(entry);
    }

    public void addFileTo(FileName root, FileObject file) throws IOException {
        while (!file.getName().equals(root)) {
            String relPath = root.getRelativeName(file.getName());
            this.addFile(relPath, file);
            file = file.getParent();
        }
    }

    public void addFilesTo(FileName root, FileObject ... files) throws IOException {
        FileObject[] fileObjectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            FileObject file = fileObjectArray[n2];
            this.addFileTo(root, file);
            ++n2;
        }
    }

    public void addFilesTo(FileName root, FileObject base, FileSelector fileSelector) throws IOException {
        FileObject[] files = base.findFiles(fileSelector);
        if (files == null) {
            return;
        }
        this.addFilesTo(root, files);
    }

    public FileObject build(FileObject zipFile, @Nullable IFileAccess fileAccess) throws IOException {
        zipFile.createFile();
        OutputStream zipOutputStream = zipFile.getContent().getOutputStream();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ZipOutputStream zip2 = new ZipOutputStream(zipOutputStream);){
                for (Entry entry : this.entries) {
                    String entryPath = entry.path;
                    FileObject resource = entry.resource;
                    ZipEntry zipEntry = new ZipEntry(entryPath);
                    if (resource.getType() == FileType.FILE) {
                        long modified;
                        if (fileAccess != null) {
                            fileAccess.read(resource);
                        }
                        if ((modified = resource.getContent().getLastModifiedTime()) != 0L) {
                            zipEntry.setTime(modified);
                        }
                        zip2.putNextEntry(zipEntry);
                        InputStream inputStream = resource.getContent().getInputStream();
                        IOUtils.copy(inputStream, (OutputStream)zip2);
                        zip2.closeEntry();
                        continue;
                    }
                    if (resource.getType() != FileType.FOLDER) continue;
                    zip2.putNextEntry(zipEntry);
                    zip2.closeEntry();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (fileAccess != null) {
                fileAccess.write(zipFile);
            }
        }
        return zipFile;
    }

    private static String fixSlashes(String path) {
        return path.replace('\\', '/');
    }

    private static String ensureTrailingSlash(String path) {
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + '/';
        }
        return path;
    }

    public static class Entry
    implements Comparable<Entry> {
        public final String path;
        public final FileObject resource;

        public Entry(String path, FileObject resource) {
            this.path = path;
            this.resource = resource;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.path.equals(other.path);
        }

        @Override
        public int compareTo(Entry other) {
            return this.path.compareTo(other.path);
        }

        public String toString() {
            return this.path;
        }
    }
}

