/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.observable;

import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.Queue;
import org.metaborg.util.observable.ITestableObserver;
import org.metaborg.util.observable.TimestampedNotification;
import rx.Notification;

public class TestableObserver<T>
implements ITestableObserver<T> {
    private Queue<TimestampedNotification<T>> notifications = Queues.newArrayDeque();

    @Override
    public void onCompleted() {
        this.notifications.add(new TimestampedNotification(Notification.createOnCompleted(), System.currentTimeMillis()));
    }

    @Override
    public void onError(Throwable e) {
        this.notifications.add(new TimestampedNotification(Notification.createOnError(e), System.currentTimeMillis()));
    }

    @Override
    public void onNext(T t) {
        this.notifications.add(new TimestampedNotification<T>(Notification.createOnNext(t), System.currentTimeMillis()));
    }

    @Override
    public TimestampedNotification<T> peek() {
        return this.notifications.peek();
    }

    @Override
    public TimestampedNotification<T> poll() {
        return this.notifications.poll();
    }

    @Override
    public int size() {
        return this.notifications.size();
    }

    @Override
    public void clear() {
        this.notifications.clear();
    }

    @Override
    public Iterator<TimestampedNotification<T>> iterator() {
        return this.notifications.iterator();
    }
}

