/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.log;

import java.io.OutputStream;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;
import org.metaborg.util.log.LoggingOutputStream;
import org.metaborg.util.log.MetaborgLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static ILogger logger(Logger slf4jlogger) {
        return new MetaborgLogger(slf4jlogger);
    }

    public static ILogger logger(Class<?> clazz) {
        return LoggerUtils.logger(LoggerFactory.getLogger(clazz));
    }

    public static ILogger logger(String name) {
        return LoggerUtils.logger(LoggerFactory.getLogger(name));
    }

    public static OutputStream stream(ILogger logger, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(logger, level, excludePatterns);
    }

    public static OutputStream stream(ILogger logger, String ... excludePatterns) {
        return new LoggingOutputStream(logger, Level.Info, excludePatterns);
    }

    public static OutputStream stream(Logger slf4jlogger, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(slf4jlogger), level, excludePatterns);
    }

    public static OutputStream stream(Logger slf4jlogger, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(slf4jlogger), Level.Info, excludePatterns);
    }

    public static OutputStream stream(Class<?> clazz, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(clazz), level, excludePatterns);
    }

    public static OutputStream stream(Class<?> clazz, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(clazz), Level.Info, excludePatterns);
    }

    public static OutputStream stream(String name, Level level, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(name), level, excludePatterns);
    }

    public static OutputStream stream(String name, String ... excludePatterns) {
        return new LoggingOutputStream(LoggerUtils.logger(name), Level.Info, excludePatterns);
    }
}

