/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.iterators;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.metaborg.util.iterators.ArrayIterable;
import org.metaborg.util.iterators.CompoundIterable;
import org.metaborg.util.iterators.IteratorIterable;
import org.metaborg.util.iterators.IteratorIterableOnce;
import rx.functions.Func0;

public final class Iterables2 {
    public static <T> Iterable<T> empty() {
        return ImmutableList.of();
    }

    public static <T> Iterable<T> singleton(T t) {
        return ImmutableList.of(t);
    }

    @SafeVarargs
    public static <T> Iterable<T> from(T ... array) {
        return new ArrayIterable<T>(array);
    }

    public static <T> Iterable<T> from(Func0<Iterator<T>> iteratorGenerator) {
        return new IteratorIterable<T>(iteratorGenerator);
    }

    public static <T> Iterable<T> fromOnce(Iterator<T> iterator) {
        return new IteratorIterableOnce<T>(iterator);
    }

    public static <T> Iterable<T> fromConcat(Iterable<? extends Iterable<T>> iterables) {
        return new CompoundIterable(iterables);
    }

    @SafeVarargs
    public static <T> Iterable<T> fromConcat(Iterable<T> ... iterablesArray) {
        return Iterables2.fromConcat(Iterables2.from(iterablesArray));
    }
}

