/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.iterators;

import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CompoundIterator<T>
implements Iterator<T> {
    private final Queue<? extends Iterator<T>> iterators;

    public CompoundIterator(Iterable<? extends Iterator<T>> iterators) {
        this.iterators = Queues.newArrayDeque(iterators);
    }

    @Override
    public boolean hasNext() {
        Iterator<T> iterator = this.iterators.peek();
        if (iterator == null) {
            return false;
        }
        return iterator.hasNext();
    }

    @Override
    public T next() {
        Iterator<T> iterator = this.iterators.peek();
        if (iterator == null) {
            throw new NoSuchElementException();
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        this.iterators.poll();
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

