/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.iterators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private final T[] array;
    private int pos = 0;

    public ArrayIterator(T[] array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.array.length;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.hasNext()) {
            return this.array[this.pos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.array);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayIterator other = (ArrayIterator)obj;
        return Arrays.equals(this.array, other.array);
    }

    public String toString() {
        return String.valueOf(Arrays.toString(this.array)) + "@" + this.pos;
    }
}

