/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.inject;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericInjectUtils {
    public static <T> Key<T> key(Type rawType, Type ... typeArgs) {
        ParameterizedType type = Types.newParameterizedType(rawType, typeArgs);
        Key<?> key = Key.get(type);
        return key;
    }

    public static <T> Key<T> key(TypeLiteral<T> typeLiteral, Type ... typeArgs) {
        Class<T> rawType = typeLiteral.getRawType();
        return GenericInjectUtils.key(rawType, typeArgs);
    }

    public static <T> T instance(Injector injector, Type rawType, Type ... typeArgs) {
        Key<T> key = GenericInjectUtils.key(rawType, typeArgs);
        return injector.getInstance(key);
    }

    public static <T> T instance(Injector injector, TypeLiteral<T> typeLiteral, Type ... typeArgs) {
        Key<T> key = GenericInjectUtils.key(typeLiteral, typeArgs);
        return injector.getInstance(key);
    }
}

