/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.file;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public final class URIEncode {
    private static final BitSet dontNeedEncoding = new BitSet(256);

    static {
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 39;
        while (i <= 42) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(33);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(126);
        dontNeedEncoding.set(47);
        dontNeedEncoding.set(92);
        dontNeedEncoding.set(58);
    }

    public static String encode(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (dontNeedEncoding.get(c)) {
                filtered.append(c);
            } else {
                byte[] b = URIEncode.charToBytesUTF(c);
                int j = 0;
                while (j < b.length) {
                    filtered.append('%');
                    filtered.append("0123456789ABCDEF".charAt(b[j] >> 4 & 0xF));
                    filtered.append("0123456789ABCDEF".charAt(b[j] & 0xF));
                    ++j;
                }
            }
            ++i;
        }
        return filtered.toString();
    }

    private static byte[] charToBytesUTF(char c) {
        try {
            return new String(new char[]{c}).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[]{(byte)c};
        }
    }
}

