/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaborg.util.collection.BiListMultimap;

public class BiLinkedListMultimap<K, V>
implements BiListMultimap<K, V> {
    private final ListMultimap<K, V> keyToValue;
    private final ListMultimap<V, K> valueToKey;

    public static <K, V> BiListMultimap<K, V> create() {
        return new BiLinkedListMultimap<K, V>();
    }

    public static <K, V> BiListMultimap<K, V> create(BiListMultimap<K, V> map) {
        return new BiLinkedListMultimap<K, V>(map);
    }

    public BiLinkedListMultimap() {
        this.keyToValue = LinkedListMultimap.create();
        this.valueToKey = LinkedListMultimap.create();
    }

    public BiLinkedListMultimap(BiListMultimap<K, V> map) {
        this.keyToValue = LinkedListMultimap.create(map.keyToValue());
        this.valueToKey = LinkedListMultimap.create(map.valueToKey());
    }

    @Override
    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValue.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keyToValue.containsValue(value);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return this.keyToValue.asMap();
    }

    @Override
    public Map<V, Collection<K>> asInverseMap() {
        return this.valueToKey.asMap();
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.keyToValue.containsEntry(key, value);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return this.keyToValue.entries();
    }

    @Override
    public List<V> get(K key) {
        return this.keyToValue.get(key);
    }

    @Override
    public List<K> getInverse(V value) {
        return this.valueToKey.get(value);
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValue.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.keyToValue.keySet();
    }

    @Override
    public Multiset<K> keys() {
        return this.keyToValue.keys();
    }

    @Override
    public boolean put(K key, V value) {
        return this.keyToValue.put(key, value) & this.valueToKey.put(value, key);
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean result = this.keyToValue.putAll(multimap);
        for (Map.Entry<K, V> entry : multimap.entries()) {
            result &= this.valueToKey.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        boolean result = this.keyToValue.putAll(key, values);
        for (V value : values) {
            result &= this.valueToKey.put(value, key);
        }
        return result;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.keyToValue.remove(key, value) & this.valueToKey.remove(value, key);
    }

    @Override
    public List<V> removeAll(Object key) {
        List<V> removed = this.keyToValue.removeAll(key);
        for (V r : removed) {
            this.valueToKey.remove(r, key);
        }
        return removed;
    }

    @Override
    public List<K> removeAllInverse(Object value) {
        List<K> removed = this.valueToKey.removeAll(value);
        for (K r : removed) {
            this.keyToValue.remove(r, value);
        }
        return removed;
    }

    @Override
    public List<V> replaceValues(K key, Iterable<? extends V> values) {
        List<V> replaced = this.keyToValue.replaceValues(key, values);
        for (V r : replaced) {
            this.valueToKey.remove(r, key);
        }
        for (V value : values) {
            this.valueToKey.put(value, key);
        }
        return replaced;
    }

    @Override
    public int size() {
        return this.keyToValue.size();
    }

    @Override
    public Collection<V> values() {
        return this.keyToValue.values();
    }

    @Override
    public ListMultimap<K, V> keyToValue() {
        return this.keyToValue;
    }

    @Override
    public ListMultimap<V, K> valueToKey() {
        return this.valueToKey;
    }
}

