/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.metaborg.util.collection.MultiTable;
import org.metaborg.util.iterators.Iterables2;

public abstract class AMultiTable<R, C, V>
implements MultiTable<R, C, V> {
    private final Table<R, C, Collection<V>> table;

    public AMultiTable(Table<R, C, Collection<V>> table) {
        this.table = table;
    }

    protected abstract Collection<V> createCollection();

    protected abstract Collection<V> createCollection(Collection<V> var1);

    @Override
    public boolean contains(R rowKey, C columnKey) {
        return this.table.contains(rowKey, columnKey);
    }

    @Override
    public boolean containsRow(R rowKey) {
        return this.table.containsRow(rowKey);
    }

    @Override
    public boolean containsColumn(C columnKey) {
        return this.table.containsColumn(columnKey);
    }

    @Override
    public Collection<V> get(R rowKey, C columnKey) {
        return this.table.get(rowKey, columnKey);
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        Collection<V> values = this.table.get(rowKey, columnKey);
        if (values == null) {
            values = this.createCollection();
            this.table.put(rowKey, columnKey, values);
        }
        values.add(value);
        return value;
    }

    @Override
    public Collection<V> removeAll(R rowKey, C columnKey) {
        Collection<V> values = this.table.get(rowKey, columnKey);
        if (values == null) {
            return null;
        }
        Collection<V> removedValues = this.createCollection(values);
        values.clear();
        return removedValues;
    }

    @Override
    public Map<C, Collection<V>> row(R rowKey) {
        return this.table.row(rowKey);
    }

    @Override
    public Iterable<V> rowValues(R rowKey) {
        return Iterables2.fromConcat(this.row(rowKey).values());
    }

    @Override
    public Map<R, Collection<V>> column(C columnKey) {
        return this.table.column(columnKey);
    }

    @Override
    public Iterable<V> columnValues(C columnKey) {
        return Iterables2.fromConcat(this.column(columnKey).values());
    }

    @Override
    public Set<Table.Cell<R, C, Collection<V>>> cellSet() {
        return this.table.cellSet();
    }

    @Override
    public Set<R> rowKeySet() {
        return this.table.rowKeySet();
    }

    @Override
    public Set<C> columnKeySet() {
        return this.table.columnKeySet();
    }

    @Override
    public Iterable<V> values() {
        return Iterables2.fromConcat(this.table.values());
    }

    @Override
    public Map<R, Map<C, Collection<V>>> rowMap() {
        return this.table.rowMap();
    }

    @Override
    public Map<C, Map<R, Collection<V>>> columnMap() {
        return this.table.columnMap();
    }
}

