/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.util;

import com.google.common.collect.ImmutableList;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class TermTools {
    public static IStrategoList makeList(ITermFactory factory, Iterable<? extends IStrategoTerm> terms) {
        IStrategoList list = factory.makeList();
        for (IStrategoTerm iStrategoTerm : ImmutableList.copyOf(terms).reverse()) {
            list = factory.makeListCons(iStrategoTerm, list);
        }
        return list;
    }

    public static IStrategoTerm makeBool(ITermFactory factory, boolean bool) {
        return bool ? factory.makeInt(1) : factory.makeInt(0);
    }

    public static boolean takeBool(IStrategoTerm term) {
        return term.getTermType() == 3 && ((IStrategoInt)term).intValue() != 0;
    }

    public static IStrategoTerm makeNullable(ITermFactory factory, IStrategoTerm term) {
        return term == null ? factory.makeTuple(new IStrategoTerm[0]) : term;
    }

    public static IStrategoTerm takeNullable(IStrategoTerm term) {
        if (TermTools.isNull(term)) {
            return null;
        }
        return term;
    }

    public static boolean isNull(IStrategoTerm term) {
        return term.getTermType() == 7 && term.getSubtermCount() == 0;
    }

    public static IStrategoInt makeShort(ITermFactory factory, short num) {
        return factory.makeInt(num);
    }

    public static short takeShort(IStrategoTerm term) {
        if (term.getTermType() != 3) {
            return 0;
        }
        return (short)((IStrategoInt)term).intValue();
    }

    public static IStrategoInt makeLong(ITermFactory factory, long num) {
        return factory.makeInt((int)num);
    }

    public static long takeLong(IStrategoTerm term) {
        if (term.getTermType() != 3) {
            return 0L;
        }
        return ((IStrategoInt)term).intValue();
    }
}

