/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.evaluation;

import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.TaskInsertion;
import org.metaborg.runtime.task.TaskStatus;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationQueue;
import org.metaborg.runtime.task.evaluation.ITaskEvaluator;
import org.metaborg.runtime.task.evaluation.TaskResultType;
import org.metaborg.runtime.task.util.InvokeStrategy;
import org.metaborg.util.time.Timer;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class BaseTaskEvaluator
implements ITaskEvaluator {
    private final ITermFactory factory;
    private final IStrategoConstructor higherOrderConstructor;
    private final IStrategoConstructor higherOrderFailConstructor;
    private final Timer timer = new Timer();

    public BaseTaskEvaluator(ITermFactory factory) {
        this.factory = factory;
        this.higherOrderConstructor = factory.makeConstructor("HigherOrder", 2);
        this.higherOrderFailConstructor = factory.makeConstructor("HigherOrderFail", 1);
    }

    @Override
    public void evaluate(IStrategoTerm taskID, ITask task, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue, IContext context, Strategy collect, Strategy insert, Strategy perform, boolean cycle) {
        TaskInsertion.PermsOrDeps combinations = TaskInsertion.taskCombinations(this.factory, taskEngine, context, collect, insert, taskID, task, false);
        if (combinations != null && combinations.hasDeps) {
            evaluationQueue.delayed(taskID, combinations.permsOrDeps);
            return;
        }
        boolean execute = combinations != null;
        boolean higherOrder = false;
        boolean failure = true;
        if (execute) {
            for (IStrategoTerm instruction : combinations.permsOrDeps) {
                if (cycle) {
                    instruction = this.factory.makeTuple(instruction, this.factory.makeString("cyclic"));
                }
                IStrategoTerm result = this.solve(context, perform, taskID, task, instruction);
                TaskResultType resultType = this.handleResult(taskID, task, result, evaluationQueue);
                boolean done = false;
                switch (resultType) {
                    case Fail: {
                        break;
                    }
                    case Success: {
                        failure = false;
                        if (!task.shortCircuit()) break;
                        done = true;
                        break;
                    }
                    case HigherOrder: {
                        higherOrder = true;
                    }
                }
                if (done || evaluationQueue.isDelayed()) break;
            }
        }
        if (!higherOrder && !evaluationQueue.isDelayed()) {
            evaluationQueue.solved(taskID);
            if (failure) {
                if (!execute) {
                    task.setDependencyFailed();
                } else {
                    task.setFailed();
                }
            }
        }
    }

    @Override
    public void reset() {
        this.timer.reset();
    }

    private IStrategoTerm solve(IContext context, Strategy performInstruction, IStrategoTerm taskID, ITask task, IStrategoTerm instruction) {
        this.timer.start();
        IStrategoTerm result = InvokeStrategy.invoke(context, performInstruction, instruction, taskID);
        task.addTime(this.timer.stop());
        task.addEvaluation();
        return result;
    }

    private TaskResultType handleResult(IStrategoTerm taskID, ITask task, IStrategoTerm result, ITaskEvaluationQueue evaluationQueue) {
        if (result == null) {
            return TaskResultType.Fail;
        }
        if (Tools.isTermAppl(result)) {
            IStrategoAppl resultAppl = (IStrategoAppl)result;
            if (resultAppl.getConstructor().equals(this.higherOrderConstructor)) {
                IStrategoAppl newInstruction = (IStrategoAppl)resultAppl.getSubterm(0);
                IStrategoTerm createdTasks = resultAppl.getSubterm(1);
                task.overrideInstruction(newInstruction);
                for (IStrategoTerm createdTaskID : createdTasks) {
                    evaluationQueue.queueOrDefer(createdTaskID);
                }
                if (createdTasks.iterator().hasNext()) {
                    evaluationQueue.delayed(taskID, createdTasks);
                } else {
                    evaluationQueue.queue(taskID);
                }
                return TaskResultType.HigherOrder;
            }
            if (resultAppl.getConstructor().equals(this.higherOrderFailConstructor)) {
                IStrategoTerm createdTasks = resultAppl.getSubterm(0);
                for (IStrategoTerm createdTaskID : createdTasks) {
                    evaluationQueue.queueOrDefer(createdTaskID);
                }
                return TaskResultType.Fail;
            }
            task.results().add(result);
            task.setStatus(TaskStatus.Success);
            return TaskResultType.Success;
        }
        if (Tools.isTermList(result)) {
            task.results().addAll(result);
            task.setStatus(TaskStatus.Success);
            return TaskResultType.Success;
        }
        task.results().add(result);
        task.setStatus(TaskStatus.Success);
        return TaskResultType.Success;
    }
}

