/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.digest;

import org.metaborg.runtime.task.digest.ITermDigester;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class NonDeterministicCountingTermDigester
implements ITermDigester {
    private static int RESET_COUNT = 0;
    public int count = RESET_COUNT;

    @Override
    public IStrategoTerm digest(ITermFactory factory, IStrategoTerm ... terms) {
        if (this.count == Integer.MAX_VALUE) {
            throw new IllegalStateException("Counter has reached maximum number, cannot assign new identifier.");
        }
        return factory.makeInt(this.count++);
    }

    @Override
    public IStrategoTerm state(ITermFactory factory) {
        return factory.makeInt(this.count);
    }

    @Override
    public void setState(IStrategoTerm state) {
        this.count = Tools.asJavaInt(state);
    }

    @Override
    public void reset() {
        this.count = RESET_COUNT;
    }
}

