/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.util;

public class PushbackStringIterator {
    public static final int UNICODE_LETTER = 255;
    public static final int UNICODE_DIGIT = 254;
    public static final int UNICODE_OTHER = 253;
    private final String data;
    private int position;

    public PushbackStringIterator(String data) {
        this.data = data;
        this.position = 0;
        assert (data != null);
    }

    public int read() {
        if (this.position >= this.data.length()) {
            return -1;
        }
        char c = this.data.charAt(this.position++);
        c = this.truncateUnicodeChar(c);
        return c;
    }

    public char truncateUnicodeChar(char c) {
        if (c >= '\u00fd') {
            c = Character.isLetter(c) ? (char)255 : (Character.isDigit(c) ? (char)254 : (char)253);
        }
        return c;
    }

    public void unread(int c) {
        --this.position;
    }

    public int getOffset() {
        return this.position;
    }

    public void setOffset(int offset) {
        this.position = offset;
    }
}

