/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.attachments;

import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.StrategoSubList;
import org.spoofax.terms.Term;
import org.spoofax.terms.attachments.ParentAttachment;

public class ParentTermFactory
extends AbstractTermFactory {
    private final ITermFactory baseFactory;

    public ParentTermFactory(ITermFactory baseFactory) {
        super(0);
        assert (!(baseFactory instanceof ParentTermFactory));
        this.baseFactory = baseFactory.getFactoryWithStorageType(0);
        assert (ParentTermFactory.checkStorageType(this.baseFactory, 0));
    }

    @Override
    public ITermFactory getFactoryWithStorageType(int storageType) {
        assert (this.getDefaultStorageType() <= storageType);
        return this;
    }

    @Override
    public IStrategoPlaceholder makePlaceholder(IStrategoTerm template) {
        IStrategoPlaceholder result = this.baseFactory.makePlaceholder(template);
        this.configure((IStrategoTerm)result, template);
        return result;
    }

    @Override
    public IStrategoInt makeInt(int i) {
        return this.baseFactory.makeInt(i);
    }

    @Override
    public IStrategoReal makeReal(double d) {
        return this.baseFactory.makeReal(d);
    }

    @Override
    public IStrategoString makeString(String s) {
        return this.baseFactory.makeString(s);
    }

    @Override
    public IStrategoTerm annotateTerm(IStrategoTerm term, IStrategoList annotations) {
        IStrategoTerm result = this.baseFactory.annotateTerm(term, annotations);
        if (Term.isTermList(term)) {
            for (IStrategoTerm subterm : StrategoListIterator.iterable((IStrategoList)term)) {
                this.configure(result, subterm);
            }
        } else {
            this.configure(result, result.getAllSubterms());
        }
        return result;
    }

    @Override
    public IStrategoAppl makeAppl(IStrategoConstructor constructor, IStrategoTerm[] kids, IStrategoList annotations) {
        IStrategoAppl result = this.baseFactory.makeAppl(constructor, kids, annotations);
        assert (ParentAttachment.get(result) == null) : "Unexpected parent attachment; doubly wrapped term factory?";
        this.configure((IStrategoTerm)result, kids);
        return result;
    }

    @Override
    public IStrategoTuple makeTuple(IStrategoTerm[] kids, IStrategoList annotations) {
        IStrategoTuple result = this.baseFactory.makeTuple(kids, annotations);
        this.configure((IStrategoTerm)result, kids);
        return result;
    }

    @Override
    public IStrategoList makeList(IStrategoTerm[] kids, IStrategoList annotations) {
        IStrategoList result = this.baseFactory.makeList(kids, annotations);
        this.configure((IStrategoTerm)result, kids);
        return result;
    }

    @Override
    public IStrategoList makeListCons(IStrategoTerm head, IStrategoList tail, IStrategoList annos) {
        IStrategoList result = this.baseFactory.makeListCons(head, tail, annos);
        assert (!(result instanceof StrategoSubList));
        ParentAttachment.putParent(head, null, result);
        ParentAttachment.putParent(tail, null, result);
        return result;
    }

    protected void configure(IStrategoTerm parent, IStrategoTerm[] kids) {
        IStrategoTerm[] iStrategoTermArray = kids;
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm kid = iStrategoTermArray[n2];
            ParentAttachment.putParent(kid, parent, null);
            ++n2;
        }
    }

    protected void configure(IStrategoTerm parent, IStrategoTerm kid) {
        ParentAttachment.putParent(kid, parent, null);
    }

    public void copyAttachments(IStrategoTerm from, IStrategoTerm to, boolean ignoreParentAttachments) {
        if (!ignoreParentAttachments) {
            super.copyAttachments(from, to);
        } else {
            ParentAttachment parent = ParentAttachment.get(to);
            super.copyAttachments(from, to);
            ParentAttachment.putParent(to, parent);
        }
    }

    @Override
    public IStrategoString tryMakeUniqueString(String name) {
        return this.baseFactory.tryMakeUniqueString(name);
    }

    public static boolean isParentTermFactory(ITermFactory factory) {
        if (factory instanceof ParentTermFactory) {
            return true;
        }
        IStrategoInt i = factory.makeInt(42);
        return ParentAttachment.getParent(factory.makeTuple(i).getSubterm(0)) != null;
    }

    @Override
    public IStrategoTerm replaceTerm(IStrategoTerm term, IStrategoTerm old) {
        return this.baseFactory.replaceTerm(term, old);
    }
}

