/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoAnnotation;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.StrategoInt;
import org.spoofax.terms.StrategoList;
import org.spoofax.terms.StrategoPlaceholder;
import org.spoofax.terms.StrategoReal;
import org.spoofax.terms.StrategoString;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.StrategoTuple;

public class TermFactory
extends AbstractTermFactory
implements ITermFactory {
    private static final int MAX_POOLED_STRING_LENGTH = 100;
    private static final Set<String> usedStrings = Collections.newSetFromMap(new WeakHashMap());
    private IStrategoConstructor placeholderConstructor;

    public TermFactory() {
        super(2);
    }

    @Override
    public ITermFactory getFactoryWithStorageType(int storageType) {
        if (storageType > 2) {
            throw new UnsupportedOperationException();
        }
        if (storageType == this.defaultStorageType) {
            return this;
        }
        TermFactory result = new TermFactory();
        result.defaultStorageType = storageType;
        return result;
    }

    @Override
    public IStrategoAppl makeAppl(IStrategoConstructor ctr, IStrategoTerm[] terms, IStrategoList annotations) {
        int storageType = this.defaultStorageType;
        if ((storageType = Math.min(storageType, this.getStorageType(terms))) != 0) {
            storageType = Math.min(storageType, TermFactory.getStorageType(annotations));
        }
        assert (ctr.getArity() == terms.length);
        return new StrategoAppl(ctr, terms, annotations, storageType);
    }

    @Override
    public IStrategoInt makeInt(int i) {
        return new StrategoInt(i, null, this.defaultStorageType);
    }

    @Override
    public IStrategoList makeList() {
        return this.isTermSharingAllowed() ? EMPTY_LIST : new StrategoList(null, null, null, this.defaultStorageType);
    }

    @Override
    public IStrategoList makeList(IStrategoTerm[] terms, IStrategoList outerAnnos) {
        IStrategoTerm head;
        int storageType = this.defaultStorageType;
        IStrategoList result = this.makeList();
        int i = terms.length - 1;
        while (i > 0) {
            head = terms[i--];
            storageType = Math.min(storageType, TermFactory.getStorageType(head));
            result = new StrategoList(head, result, null, storageType);
        }
        if (i != 0) {
            if (outerAnnos == null || outerAnnos.isEmpty()) {
                return this.makeList();
            }
            return new StrategoList(null, null, outerAnnos, this.defaultStorageType);
        }
        head = terms[0];
        storageType = Math.min(storageType, TermFactory.getStorageType(head));
        result = new StrategoList(head, result, outerAnnos, storageType);
        return result;
    }

    @Override
    public IStrategoList makeListCons(IStrategoTerm head, IStrategoList tail, IStrategoList annotations) {
        int storageType = Math.min(this.defaultStorageType, TermFactory.getStorageType(head, tail));
        if (head == null) {
            return this.makeList();
        }
        return new StrategoList(head, tail, annotations, storageType);
    }

    @Override
    public IStrategoReal makeReal(double d) {
        return new StrategoReal(d, null, this.defaultStorageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoString makeString(String s) {
        StrategoString string = new StrategoString(s, null, this.defaultStorageType);
        if (s.length() <= 100) {
            Set<String> set = usedStrings;
            synchronized (set) {
                usedStrings.add(s);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoString tryMakeUniqueString(String s) {
        Set<String> set = usedStrings;
        synchronized (set) {
            block5: {
                if (!usedStrings.contains(s)) break block5;
                return null;
            }
            if (s.length() > 100) {
                throw new UnsupportedOperationException("String too long to be pooled (newname not allowed): " + s);
            }
            return this.makeString(s);
        }
    }

    @Override
    public IStrategoTuple makeTuple(IStrategoTerm[] terms, IStrategoList annos) {
        int storageType = Math.min(this.defaultStorageType, this.getStorageType(terms));
        return new StrategoTuple(terms, annos, storageType);
    }

    @Override
    public IStrategoTerm annotateTerm(IStrategoTerm term, IStrategoList annotations) {
        IStrategoList currentAnnos = term.getAnnotations();
        if (currentAnnos == annotations) {
            return term;
        }
        if (term.getStorageType() == 3) {
            if (term == EMPTY_LIST) {
                if (annotations == EMPTY_LIST || annotations.isEmpty()) {
                    return EMPTY_LIST;
                }
                return new StrategoList(null, null, annotations, this.defaultStorageType);
            }
            if (term.getTermType() == 5) {
                String value = ((IStrategoString)term).stringValue();
                if (annotations == EMPTY_LIST || annotations.isEmpty()) {
                    return this.makeString(value);
                }
                return new StrategoString(value, annotations, this.defaultStorageType);
            }
            if (currentAnnos == EMPTY_LIST) {
                return annotations.isEmpty() ? term : new StrategoAnnotation(this, term, annotations);
            }
            if (term instanceof StrategoAnnotation) {
                term = ((StrategoAnnotation)term).getWrapped();
                return new StrategoAnnotation(this, term, annotations);
            }
            throw new UnsupportedOperationException("Unable to annotate term of type " + term.getClass().getName());
        }
        if ((annotations == EMPTY_LIST || annotations.isEmpty()) && term.getTermType() == 5) {
            return this.makeString(((IStrategoString)term).stringValue());
        }
        if (term instanceof StrategoTerm) {
            StrategoTerm result = ((StrategoTerm)term).clone(true);
            result.internalSetAnnotations(annotations);
            assert (result.getStorageType() != 3);
            return result;
        }
        throw new UnsupportedOperationException("Unable to annotate term of type " + term.getClass().getName() + " in " + this.getClass().getName());
    }

    @Override
    public IStrategoPlaceholder makePlaceholder(IStrategoTerm template) {
        if (this.placeholderConstructor == null) {
            this.placeholderConstructor = this.makeConstructor("<>", 1);
        }
        return new StrategoPlaceholder(this.placeholderConstructor, template, EMPTY_LIST, this.defaultStorageType);
    }
}

