/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.EmptyIterator;

public class StrategoString
extends StrategoTerm
implements IStrategoString {
    private static final long serialVersionUID = 237308007762215350L;
    private final String value;

    public StrategoString(String value, IStrategoList annotations, int storageType) {
        super(annotations, storageType);
        this.value = value;
        assert (storageType != 3 || annotations == null);
        this.initImmutableHashCode();
    }

    protected StrategoString(String value) {
        this(value, TermFactory.EMPTY_LIST, 1);
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY;
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public int getTermType() {
        return 5;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        String secondValue;
        if (second.getTermType() != 5) {
            return false;
        }
        String value = this.stringValue();
        if (value != (secondValue = ((IStrategoString)second).stringValue()) && !value.equals(secondValue)) {
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        pp.print("\"");
        pp.print(this.stringValue().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
        pp.print("\"");
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append("\"");
        output.append(this.stringValue().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r"));
        output.append("\"");
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        return this.stringValue().hashCode();
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new EmptyIterator<IStrategoTerm>();
    }
}

