/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.EmptyIterator;

public class StrategoReal
extends StrategoTerm
implements IStrategoReal {
    private static final long serialVersionUID = 9005617684098182139L;
    private final double value;

    public StrategoReal(double value, IStrategoList annotations, int storageType) {
        super(annotations, storageType);
        this.value = value;
    }

    protected StrategoReal(double value, int storageType) {
        this(value, null, storageType);
    }

    @Override
    public double realValue() {
        return this.value;
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY;
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public int getTermType() {
        return 4;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        if (second.getTermType() != 4) {
            return false;
        }
        if (this.realValue() != ((IStrategoReal)second).realValue()) {
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        pp.print("" + this.realValue());
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(Double.toString(this.realValue()));
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        return (int)(449.0 * this.value) ^ 0x1EA1;
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new EmptyIterator<IStrategoTerm>();
    }
}

