/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.util.Collection;
import java.util.HashMap;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.StrategoConstructor;
import org.spoofax.terms.StrategoList;
import org.spoofax.terms.StringTermReader;
import org.spoofax.terms.TermFactory;

public abstract class AbstractTermFactory
implements ITermFactory {
    @Deprecated
    public static final IStrategoList EMPTY_LIST = new StrategoList(null, null, null, 3);
    public static final IStrategoTerm[] EMPTY = new IStrategoTerm[0];
    private final StringTermReader reader = new StringTermReader(this);
    private static final HashMap<StrategoConstructor, StrategoConstructor> asyncCtorCache = new HashMap();
    protected int defaultStorageType;

    public AbstractTermFactory(int defaultStorageType) {
        this.defaultStorageType = defaultStorageType;
    }

    @Override
    public final int getDefaultStorageType() {
        return this.defaultStorageType;
    }

    protected final boolean isTermSharingAllowed() {
        return this.defaultStorageType != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StrategoConstructor createCachedConstructor(String name, int arity) {
        StrategoConstructor result = new StrategoConstructor(name, arity);
        Class<TermFactory> clazz = TermFactory.class;
        synchronized (TermFactory.class) {
            StrategoConstructor cached = asyncCtorCache.get(result);
            if (cached == null) {
                asyncCtorCache.put(result, result);
            } else {
                result = cached;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    @Override
    public StrategoConstructor makeConstructor(String name, int arity) {
        return AbstractTermFactory.createCachedConstructor(name, arity);
    }

    @Override
    public abstract IStrategoAppl makeAppl(IStrategoConstructor var1, IStrategoTerm[] var2, IStrategoList var3);

    @Override
    public abstract IStrategoTuple makeTuple(IStrategoTerm[] var1, IStrategoList var2);

    @Override
    public abstract IStrategoList makeList(IStrategoTerm[] var1, IStrategoList var2);

    @Override
    public IStrategoAppl replaceAppl(IStrategoConstructor constructor, IStrategoTerm[] kids, IStrategoAppl old) {
        return this.makeAppl(constructor, kids, old.getAnnotations());
    }

    @Override
    public IStrategoTuple replaceTuple(IStrategoTerm[] kids, IStrategoTuple old) {
        return this.makeTuple(kids, old.getAnnotations());
    }

    @Override
    public IStrategoList replaceList(IStrategoTerm[] kids, IStrategoList old) {
        return this.makeList(kids, old.getAnnotations());
    }

    @Override
    public IStrategoList replaceListCons(IStrategoTerm head, IStrategoList tail, IStrategoTerm oldHead, IStrategoList oldTail) {
        return this.makeListCons(head, tail);
    }

    @Override
    public IStrategoTerm replaceTerm(IStrategoTerm term, IStrategoTerm old) {
        return term;
    }

    public final IStrategoAppl makeAppl(IStrategoConstructor ctr, IStrategoList kids, IStrategoList annotations) {
        return this.makeAppl(ctr, kids.getAllSubterms(), annotations);
    }

    public final IStrategoAppl makeAppl(IStrategoConstructor ctr, IStrategoList kids) {
        return this.makeAppl(ctr, kids, null);
    }

    @Override
    public final IStrategoAppl makeAppl(IStrategoConstructor ctr, IStrategoTerm ... terms) {
        return this.makeAppl(ctr, terms, null);
    }

    @Override
    public final IStrategoList makeList(IStrategoTerm ... terms) {
        return this.makeList(terms, null);
    }

    @Override
    public IStrategoList makeList() {
        return this.makeList(EMPTY, null);
    }

    @Override
    public IStrategoList makeList(Collection<? extends IStrategoTerm> terms) {
        return this.makeList(terms.toArray(new IStrategoTerm[terms.size()]));
    }

    @Override
    public final IStrategoList makeListCons(IStrategoTerm head, IStrategoList tail) {
        return this.makeListCons(head, tail, null);
    }

    @Override
    public abstract IStrategoList makeListCons(IStrategoTerm var1, IStrategoList var2, IStrategoList var3);

    @Override
    public final IStrategoTuple makeTuple(IStrategoTerm ... terms) {
        return this.makeTuple(terms, null);
    }

    @Override
    public IStrategoTerm parseFromString(String text) throws ParseError {
        return this.reader.parseFromString(text);
    }

    protected static int getStorageType(IStrategoTerm term) {
        return term == null ? 3 : term.getStorageType();
    }

    protected static int getStorageType(IStrategoTerm term1, IStrategoTerm term2) {
        int result = term1.getStorageType();
        if (result == 0) {
            return 0;
        }
        return Math.min(result, term2.getStorageType());
    }

    protected int getStorageType(IStrategoTerm[] terms) {
        int result = this.defaultStorageType;
        IStrategoTerm[] iStrategoTermArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm term = iStrategoTermArray[n2];
            int type = term.getStorageType();
            if (type < result) {
                if (type == 0) {
                    return 0;
                }
                result = type;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public IStrategoTerm copyAttachments(IStrategoTerm from, IStrategoTerm to) {
        if (to.getStorageType() != 0) {
            throw new IllegalArgumentException("Target term is not mutable and does not support attachments");
        }
        Object attach = from.getAttachment(null);
        while (attach != null) {
            try {
                to.putAttachment(attach.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException("Copying attachments of this type is not supported: " + attach.getAttachmentType(), e);
            }
            attach = attach.getNext();
        }
        return to;
    }

    public static boolean checkStorageType(ITermFactory factory, int storageType) {
        return factory.getDefaultStorageType() <= storageType && factory.makeList(EMPTY).getStorageType() <= storageType && factory.makeString("Sanity").getStorageType() <= storageType;
    }
}

