/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.ITermAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;

public abstract class AbstractSimpleTerm
implements ISimpleTerm,
Cloneable {
    private ITermAttachment attachment;

    @Override
    public <T extends ITermAttachment> T getAttachment(TermAttachmentType<T> type) {
        if (type == null) {
            return (T)this.attachment;
        }
        ITermAttachment a = this.attachment;
        while (a != null) {
            if (a.getAttachmentType() == type) {
                return (T)a;
            }
            a = a.getNext();
        }
        return null;
    }

    @Override
    public void putAttachment(ITermAttachment attachment) {
        if (attachment == null) {
            return;
        }
        assert (!(this instanceof IStrategoTerm) || ((IStrategoTerm)((Object)this)).getStorageType() == 0) : "Attachments only supported for mutable, non-shared terms; failed for " + this;
        if (this.attachment == null) {
            this.attachment = attachment;
        } else {
            TermAttachmentType<?> newType = attachment.getAttachmentType();
            if (this.attachment.getAttachmentType() == newType) {
                attachment.setNext(this.attachment.getNext());
                this.attachment = attachment;
            } else {
                ITermAttachment previous = this.attachment;
                ITermAttachment a = previous.getNext();
                while (a != null) {
                    if (a.getAttachmentType() == newType) {
                        attachment.setNext(a.getNext());
                        previous.setNext(attachment);
                        break;
                    }
                    previous = a;
                    a = a.getNext();
                }
                previous.setNext(attachment);
            }
        }
    }

    @Override
    public ITermAttachment removeAttachment(TermAttachmentType<?> type) {
        if (this.attachment != null) {
            if (this.attachment.getAttachmentType() == type) {
                ITermAttachment old = this.attachment;
                this.attachment = this.attachment.getNext();
                old.setNext(null);
                return old;
            }
            ITermAttachment previous = this.attachment;
            ITermAttachment a = this.attachment.getNext();
            while (a != null) {
                if (a.getAttachmentType() == type) {
                    previous.setNext(a.getNext());
                    a.setNext(null);
                    return a;
                }
                previous = a;
                a = a.getNext();
            }
        }
        return null;
    }

    protected void clearAttachments() {
        this.attachment = null;
    }
}

