/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.shared;

import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.shared.SGLRException;

public class BadTokenException
extends SGLRException {
    private static final long serialVersionUID = -2050581505177108272L;
    private final int token;
    private final int offset;
    private final int lineNumber;
    private final int columnNumber;

    public int getOffset() {
        return this.offset;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getToken() {
        return this.token;
    }

    public boolean isEOFToken() {
        return this.token == 256;
    }

    @Override
    public String getMessage() {
        return String.valueOf(this.getShortMessage()) + " at line " + (this.lineNumber + 1) + ", column " + (this.columnNumber - 1);
    }

    @Override
    public String getShortMessage() {
        if (this.isEOFToken()) {
            return "Unexpected end of file";
        }
        return "Syntax error near unexpected character '" + this.escape(this.token) + "'";
    }

    protected String escape(int ch) {
        switch (ch) {
            case 0: {
                return "\\0";
            }
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
        }
        return "" + (char)ch;
    }

    public BadTokenException(SGLR parser, int token, int offset, int lineNumber, int columnNumber) {
        super(parser);
        this.token = token;
        this.offset = offset;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    protected IStrategoTerm toLocationTerm() {
        ITermFactory factory = this.getParser().getParseTable().getFactory();
        return factory.makeAppl(factory.makeConstructor("area", 6), factory.makeInt(this.getLineNumber()), factory.makeInt(this.getColumnNumber()), factory.makeInt(this.getLineNumber()), factory.makeInt(this.getColumnNumber()), factory.makeInt(this.getOffset() + 1), factory.makeInt(0));
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

