/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.indentation;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.ParseNode;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.imploder.ProductionAttributeReader;
import org.spoofax.terms.Term;

public class LayoutFilter {
    private final Object NO_VALUE = null;
    private final boolean atParseTime;
    private ParseTable parseTable;
    private ProductionAttributeReader attrReader;
    private int disambiguationCount;
    private int filterCallCount = 0;
    int error = 0;

    public LayoutFilter(ParseTable parseTable, boolean atParseTime) {
        this.parseTable = parseTable;
        this.attrReader = new ProductionAttributeReader(parseTable.getFactory());
        this.atParseTime = atParseTime;
    }

    public int getFilterCallCount() {
        return this.filterCallCount;
    }

    public int getDisambiguationCount() {
        return this.disambiguationCount;
    }

    public boolean hasValidLayout(ParseNode t) {
        return this.hasValidLayout(t.getLabel(), t.getChildren());
    }

    public boolean hasValidLayout(int label, AbstractParseNode[] kids) {
        IStrategoTerm layoutConstraint = this.parseTable.getLabel(label).getAttributes().getLayoutConstraint();
        if (layoutConstraint == null) {
            return true;
        }
        this.disambiguationCount = 0;
        ++this.filterCallCount;
        Boolean b = this.evalConstraint(layoutConstraint, kids, new HashMap<String, Object>(), Boolean.class);
        if (b == this.NO_VALUE) {
            return true;
        }
        return b;
    }

    private <T> T evalConstraint(IStrategoTerm constraint, AbstractParseNode[] kids, Map<String, Object> env, Class<T> cl) {
        Object o = this.evalConstraint(constraint, kids, env);
        this.ensureType(o, cl, constraint);
        return (T)o;
    }

    private Object evalConstraint(IStrategoTerm constraint, AbstractParseNode[] kids, Map<String, Object> env) {
        switch (constraint.getTermType()) {
            case 3: {
                int i = Term.asJavaInt(constraint);
                return this.getSubtree(i, kids);
            }
            case 5: {
                String v = Term.asJavaString(constraint);
                Object o = env.get(v);
                if (o == null) {
                    throw new IllegalStateException("undefined variable " + v);
                }
                return o;
            }
            case 1: {
                IStrategoConstructor cons = Term.tryGetConstructor(constraint);
                String consName = cons.getName();
                if (consName.equals("num")) {
                    String num = Term.asJavaString(constraint.getSubterm(0));
                    int i = Integer.parseInt(num);
                    return i;
                }
                if (consName.equals("tree")) {
                    String num = Term.asJavaString(constraint.getSubterm(0));
                    int i = Integer.parseInt(num);
                    return this.getSubtree(i, kids);
                }
                if (consName.equals("eq") || consName.equals("gt") || consName.equals("ge") || consName.equals("lt") || consName.equals("le")) {
                    this.ensureChildCount(constraint, 2, consName);
                    Integer i1 = this.evalConstraint(constraint.getSubterm(0), kids, env, Integer.class);
                    Integer i2 = this.evalConstraint(constraint.getSubterm(1), kids, env, Integer.class);
                    return this.binArithComp(consName, i1, i2);
                }
                if (consName.equals("add") || consName.equals("sub") || consName.equals("mul") || consName.equals("div")) {
                    this.ensureChildCount(constraint, 2, consName);
                    Integer i1 = this.evalConstraint(constraint.getSubterm(0), kids, env, Integer.class);
                    Integer i2 = this.evalConstraint(constraint.getSubterm(1), kids, env, Integer.class);
                    return this.binArithOp(consName, i1, i2);
                }
                if (consName.equals("first") || consName.equals("left") || consName.equals("right") || consName.equals("last")) {
                    this.ensureChildCount(constraint, 1, consName);
                    AbstractParseNode n = this.evalConstraint(constraint.getSubterm(0), kids, env, AbstractParseNode.class);
                    return this.nodeSelector(consName, n);
                }
                if (consName.equals("or")) {
                    this.ensureChildCount(constraint, 2, consName);
                    Boolean b1 = this.evalConstraint(constraint.getSubterm(0), kids, env, Boolean.class);
                    if (b1 != this.NO_VALUE && b1.booleanValue()) {
                        return true;
                    }
                    Boolean b2 = this.evalConstraint(constraint.getSubterm(1), kids, env, Boolean.class);
                    return b2;
                }
                if (consName.equals("and")) {
                    this.ensureChildCount(constraint, 2, consName);
                    Boolean b1 = this.evalConstraint(constraint.getSubterm(0), kids, env, Boolean.class);
                    if (b1 != this.NO_VALUE && !b1.booleanValue()) {
                        return false;
                    }
                    Boolean b2 = this.evalConstraint(constraint.getSubterm(1), kids, env, Boolean.class);
                    return b2;
                }
                if (consName.equals("not")) {
                    this.ensureChildCount(constraint, 1, consName);
                    Boolean b1 = this.evalConstraint(constraint.getSubterm(0), kids, env, Boolean.class);
                    if (b1 == this.NO_VALUE) {
                        return this.NO_VALUE;
                    }
                    return b1 == false;
                }
                if (consName.equals("all")) {
                    this.ensureChildCount(constraint, 3, consName);
                    this.ensureType(constraint.getSubterm(0), IStrategoString.class, constraint.getSubterm(0));
                    String v = Term.asJavaString(constraint.getSubterm(0));
                    AbstractParseNode n = this.evalConstraint(constraint.getSubterm(1), kids, env, AbstractParseNode.class);
                    return this.checkAll(n, v, constraint, kids, env);
                }
                if (consName.equals("col")) {
                    this.ensureChildCount(constraint, 1, consName);
                    AbstractParseNode n = this.evalConstraint(constraint.getSubterm(0), kids, env, AbstractParseNode.class);
                    if (n == this.NO_VALUE) {
                        return this.NO_VALUE;
                    }
                    return n.getColumn();
                }
                if (consName.equals("line")) {
                    this.ensureChildCount(constraint, 1, consName);
                    AbstractParseNode n = this.evalConstraint(constraint.getSubterm(0), kids, env, AbstractParseNode.class);
                    if (n == this.NO_VALUE) {
                        return this.NO_VALUE;
                    }
                    return n.getLine();
                }
                throw new IllegalStateException("unhandeled constructor " + consName);
            }
        }
        throw new IllegalStateException("unhandeled constraint " + constraint);
    }

    private Boolean checkAll(AbstractParseNode n, String v, IStrategoTerm constraint, AbstractParseNode[] kids, Map<String, Object> env) {
        if (this.atParseTime) {
            return (Boolean)this.noValue();
        }
        Stack<AbstractParseNode> all = new Stack<AbstractParseNode>();
        all.push(n);
        String sort = null;
        while (!all.isEmpty()) {
            AbstractParseNode next = (AbstractParseNode)all.pop();
            if (sort == null && !next.isAmbNode() && !next.isParseProductionNode()) {
                sort = this.sortOfNode(next);
            }
            if (next.isAmbNode()) {
                boolean left = this.checkAll(next.getChildren()[0], v, constraint, kids, env);
                boolean right = this.checkAll(next.getChildren()[1], v, constraint, kids, env);
                if (!left && !right) {
                    return false;
                }
                if (left && !right) {
                    ((ParseNode)next).disambiguate(next.getChildren()[0]);
                    ++this.disambiguationCount;
                }
                if (left || !right) continue;
                ((ParseNode)next).disambiguate(next.getChildren()[1]);
                ++this.disambiguationCount;
                continue;
            }
            if (next.isParseProductionNode() || sort != null && !sort.equals(this.sortOfNode(next)) || !this.isListNode(next)) {
                Object old = env.get(v);
                env.put(v, next);
                try {
                    Boolean b = this.evalConstraint(constraint.getSubterm(2), kids, env, Boolean.class);
                    if (b == this.NO_VALUE || b.booleanValue()) continue;
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (old == null) {
                        env.remove(v);
                    } else {
                        env.put(v, old);
                    }
                }
            }
            int j = next.getChildren().length - 1;
            while (j >= 0) {
                AbstractParseNode kid = next.getChildren()[j];
                if (kid.isAmbNode() || sort.equals(this.sortOfNode(kid))) {
                    all.push(kid);
                }
                --j;
            }
        }
        return true;
    }

    private String sortOfNode(AbstractParseNode node) {
        return this.attrReader.getSort((IStrategoAppl)this.parseTable.getLabel(node.getLabel()).getProduction().getSubterm(1));
    }

    private boolean isListNode(AbstractParseNode node) {
        IStrategoAppl prod = this.parseTable.getLabel(node.getLabel()).getProduction();
        return this.attrReader.isList((IStrategoAppl)prod.getSubterm(1), (IStrategoAppl)prod.getSubterm(2)) && !this.attrReader.isFlatten((IStrategoAppl)prod.getSubterm(1), (IStrategoAppl)prod.getSubterm(2));
    }

    private AbstractParseNode getSubtree(int i, AbstractParseNode[] kids) {
        int elems = (kids.length + 1) / 2;
        if (--i < 0 || i >= elems) {
            throw new IllegalStateException("index out of bounds: index is " + i + " but only " + elems + " children available");
        }
        return kids[2 * i];
    }

    private Integer binArithOp(String op, Integer i1, Integer i2) {
        if (i1 == this.NO_VALUE || i2 == this.NO_VALUE) {
            return (Integer)this.noValue();
        }
        if (op.equals("add")) {
            return i1 + i2;
        }
        if (op.equals("sub")) {
            return i1 - i2;
        }
        if (op.equals("mult")) {
            return i1 * i2;
        }
        if (op.equals("div")) {
            return i1 / i2;
        }
        throw new IllegalStateException("unknown operator " + op);
    }

    private Boolean binArithComp(String comp, Integer i1, Integer i2) {
        if (i1 == this.NO_VALUE || i2 == this.NO_VALUE) {
            return (Boolean)this.noValue();
        }
        if (comp.equals("eq")) {
            return i1.equals(i2);
        }
        if (comp.equals("gt")) {
            if (i1 > i2) {
                return true;
            }
            return false;
        }
        if (comp.equals("ge")) {
            if (i1 >= i2) {
                return true;
            }
            return false;
        }
        if (comp.equals("lt")) {
            if (i1 < i2) {
                return true;
            }
            return false;
        }
        if (comp.equals("le")) {
            if (i1 <= i2) {
                return true;
            }
            return false;
        }
        throw new IllegalStateException("unknown comparator " + comp);
    }

    private AbstractParseNode nodeSelector(String sel, AbstractParseNode t) {
        if (this.isNothing(t)) {
            return (AbstractParseNode)this.noValue();
        }
        if (sel.equals("first")) {
            return t;
        }
        if (sel.equals("last")) {
            return t.getLast();
        }
        if (this.atParseTime) {
            return (AbstractParseNode)this.noValue();
        }
        if (sel.equals("left")) {
            return t.getLeft();
        }
        if (sel.equals("right")) {
            return t.getRight();
        }
        throw new IllegalStateException("unknown selector " + sel);
    }

    private void ensureType(Object o, Class<?> cl, IStrategoTerm term) {
        if (o != null && !cl.isInstance(o)) {
            throw new IllegalStateException("ill-typed term " + term + ". Expected type " + cl.getName() + ", was " + o.getClass().getName());
        }
    }

    private void ensureChildCount(IStrategoTerm t, int count, String what) {
        if (t.getAllSubterms().length != count) {
            throw new IllegalStateException("not enough arguments to " + what);
        }
    }

    private <T> T noValue() {
        return (T)this.NO_VALUE;
    }

    private boolean isNothing(AbstractParseNode n) {
        if (n.isAmbNode()) {
            return this.isNothing(n.getChildren()[0]) && this.isNothing(n.getChildren()[1]);
        }
        return n.isLayout() || n.isEmpty() || n.isIgnoreLayout();
    }
}

