/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

public class LineStartOffsetList {
    private static final double EXPECTED_NEWLINES_DIVIDER = 12.0;
    private int[] lineStarts;
    private int lastLineStartOffset;

    public LineStartOffsetList(String input) {
        int size = (int)((double)input.length() / 12.0) + 1;
        this.lineStarts = new int[size];
        this.addLineStartOffset(0);
        int i = 0;
        int max = input.length();
        while (i < max) {
            if (input.charAt(i) == '\n') {
                this.addLineStartOffset(i);
            }
            ++i;
        }
    }

    public void addLineStartOffset(int lineStartOffset) {
        if (this.lastLineStartOffset == this.lineStarts.length) {
            int[] oldLineStarts = this.lineStarts;
            this.lineStarts = new int[this.lineStarts.length * 2];
            System.arraycopy(oldLineStarts, 0, this.lineStarts, 0, oldLineStarts.length);
        }
        this.lineStarts[this.lastLineStartOffset++] = lineStartOffset;
    }

    public int getLine(int index) {
        return index + 1;
    }

    public int getColumn(int index, int offset) {
        assert (offset >= this.lineStarts[index]);
        return offset - this.lineStarts[index];
    }

    public int getIndex(int offset) {
        int i = 0;
        int max = this.lineStarts.length;
        while (i < max) {
            if (offset > this.lineStarts[i]) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

