/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.BottomupTreeBuilder;
import org.spoofax.jsglr.client.imploder.TopdownTreeBuilder;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.NotImplementedException;

public class ParseNode
extends AbstractParseNode {
    private static final int AMB_LABEL = -1;
    private int label;
    AbstractParseNode[] kids;
    private boolean isParseProductionChain;
    private boolean isSetPPC;
    private int nodeType;
    private int cachedHashCode;
    private AbstractParseNode left;
    private final boolean isLayout;
    private final boolean isIgnoreLayout;
    private final boolean isPlaceholderInsertion;
    private final boolean isLiteralCompletion;
    private Boolean isEmpty;

    public ParseNode(int label, AbstractParseNode[] kids, int type, int line, int column, boolean isLayout, boolean isIgnoreLayout, boolean isPlaceholderInsertion, boolean isLiteralCompletion, boolean isProposal, boolean isNestedProposal, boolean isSinglePlaceholderInsertion) {
        super(line, column);
        super.setProposal(isProposal);
        super.setNestedProposal(isNestedProposal);
        super.setSinglePlaceholderInsertion(isSinglePlaceholderInsertion);
        this.isLayout = isLayout;
        this.isIgnoreLayout = isIgnoreLayout;
        this.isPlaceholderInsertion = isPlaceholderInsertion;
        this.isLiteralCompletion = isLiteralCompletion;
        this.setFields(label, kids, type);
        if (type == 3) {
            this.isParseProductionChain = false;
            this.isSetPPC = true;
            assert (this.label == -1);
        }
    }

    @Override
    public int getLabel() {
        if (this.isAmbNode() || this.label == -1) {
            throw new UnsupportedOperationException();
        }
        return this.label;
    }

    public static ParseNode createAmbNode(AbstractParseNode ... kids) {
        assert (kids.length > 0);
        int line = kids[0].getLine();
        int column = kids[0].getColumn();
        boolean isPlaceholderInsertion = false;
        boolean isLiteralCompletion = false;
        boolean completed = false;
        boolean nestedCompleted = false;
        boolean singlePlaceholderInsertion = false;
        int i = 1;
        while (i < kids.length) {
            assert (kids[i].getLine() == line);
            assert (kids[i].getColumn() == column);
            if (kids[i].isPlaceholderInsertionNode()) {
                isPlaceholderInsertion = true;
            }
            if (kids[i].isLiteralCompletionNode()) {
                isLiteralCompletion = true;
            }
            if (kids[i].isProposal()) {
                completed = true;
            }
            if (kids[i].isNestedProposal()) {
                nestedCompleted = true;
            }
            if (kids[i].isSinglePlaceholderInsertion()) {
                singlePlaceholderInsertion = true;
            }
            ++i;
        }
        ParseNode amb = new ParseNode(-1, kids, 3, line, column, kids[0].isLayout(), kids[0].isIgnoreLayout(), isPlaceholderInsertion, isLiteralCompletion, completed, nestedCompleted, singlePlaceholderInsertion);
        return amb;
    }

    private void setFields(int label, AbstractParseNode[] kids, int type) {
        assert (type != 3 || label == -1);
        this.nodeType = type;
        this.label = label;
        this.kids = kids;
        this.isParseProductionChain = false;
        this.isSetPPC = false;
        AbstractParseNode[] abstractParseNodeArray = kids;
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode kid = abstractParseNodeArray[n2];
            if (!(kid.isLayout() || kid.isEmpty() || kid.isIgnoreLayout())) {
                AbstractParseNode kidLeft;
                if (kid.getLine() > this.getLine() && (this.left == null || kid.getColumn() < this.left.getColumn())) {
                    this.left = kid;
                }
                if ((kidLeft = kid.getLeft()) != null && kidLeft.getLine() > this.getLine() && (this.left == null || kidLeft.getColumn() < this.left.getColumn())) {
                    this.left = kidLeft;
                }
            }
            ++n2;
        }
    }

    @Override
    public void reject() {
        this.nodeType = 6;
    }

    public void makeAmbiguity(AbstractParseNode pn) {
        if (this == pn || this.isAmbNode() && this.isInAmbiguityCluster(pn)) {
            return;
        }
        assert (this.getLine() == pn.getLine());
        assert (this.getColumn() == pn.getColumn());
        ParseNode left = new ParseNode(this.label, this.kids, this.nodeType, this.getLine(), this.getColumn(), this.isLayout, this.isIgnoreLayout, this.isPlaceholderInsertion, this.isLiteralCompletion, super.isProposal(), super.isNestedProposal(), super.isSinglePlaceholderInsertion());
        if (pn instanceof ParseNode) {
            ((ParseNode)pn).replaceCycle(this, left);
        }
        this.setFields(-1, new AbstractParseNode[]{left, pn}, 3);
        assert (this.cachedHashCode == 0) : "Hashcode should not be cached during parsing because descendant nodes may change";
        assert (!this.isParseProductionChain) : "PPC is not set to true during parsing because descendents may change";
    }

    public void disambiguate(AbstractParseNode n) {
        assert (this.isAmbNode());
        assert (n.isParseNode());
        assert (this.getChildren().length == 2 && (n == this.getChildren()[0] || n == this.getChildren()[1]));
        this.setFields(n.isAmbNode() ? -1 : n.getLabel(), n.getChildren(), n.getNodeType());
        this.cachedHashCode = 0;
    }

    private boolean isInAmbiguityCluster(AbstractParseNode pn) {
        AbstractParseNode[] abstractParseNodeArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode existing = abstractParseNodeArray[n2];
            if (pn == existing) {
                return true;
            }
            if (existing.isAmbNode() && ((ParseNode)existing).isInAmbiguityCluster(pn)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void replaceCycle(ParseNode before, ParseNode after) {
        assert (after != null);
        if (this.isAmbNode()) {
            int i = 0;
            while (i < this.kids.length) {
                this.replaceDescendantAt(before, after, i);
                ++i;
            }
        } else if (this.kids.length > 0) {
            this.replaceDescendantAt(before, after, this.kids.length - 1);
        }
    }

    private void replaceDescendantAt(ParseNode before, ParseNode after, int index) {
        AbstractParseNode kid = this.kids[index];
        if (kid == before) {
            this.kids[index] = after;
            return;
        }
        if (kid instanceof ParseNode && kid.getLine() == this.getLine() && kid.getColumn() == this.getColumn()) {
            ((ParseNode)kid).replaceCycle(before, after);
        }
    }

    @Override
    public boolean isParseProductionChain() {
        if (!this.isSetPPC) {
            this.initParseProductionChain();
        }
        return this.isParseProductionChain;
    }

    private void initParseProductionChain() {
        AbstractParseNode deepest = this.getDeepestNonChainNode();
        if (deepest == this) {
            this.isSetPPC = true;
            this.isParseProductionChain = false;
        } else {
            this.setParseProductionChainUpTo(deepest == null, deepest);
        }
    }

    private AbstractParseNode getDeepestNonChainNode() {
        AbstractParseNode current = this;
        block5: while (true) {
            AbstractParseNode[] kids = current.getChildren();
            switch (kids.length) {
                case 2: {
                    if (current instanceof ParseNode && ((ParseNode)current).isSetPPC) {
                        return current.isParseProductionChain() ? null : current;
                    }
                    if (!kids[0].isParseProductionNode()) {
                        return kids[0];
                    }
                    current = kids[1];
                    continue block5;
                }
                case 1: {
                    current = kids[0];
                    continue block5;
                }
                case 0: {
                    return current.isParseProductionNode() ? null : current;
                }
            }
            break;
        }
        return current;
    }

    private void setParseProductionChainUpTo(boolean value, AbstractParseNode end) {
        ParseNode current = this;
        AbstractParseNode next = this;
        do {
            current = next;
            ParseNode parseCurrent = null;
            if (current instanceof ParseNode) {
                parseCurrent = current;
            }
            if (parseCurrent == null) {
                assert (current.isCycle() || current.isParseProductionNode());
                return;
            }
            parseCurrent.isParseProductionChain = value;
            parseCurrent.isSetPPC = true;
            AbstractParseNode[] kids = parseCurrent.kids;
            switch (kids.length) {
                case 2: {
                    next = kids[1];
                    break;
                }
                case 1: {
                    next = kids[0];
                    break;
                }
                default: {
                    return;
                }
            }
        } while (current != end);
    }

    @Override
    public Object toTreeBottomup(BottomupTreeBuilder builder) {
        if (this.isAmbNode()) {
            return this.toTreeBottomupAmb(builder);
        }
        builder.visitLabel(this.label);
        ArrayList<Object> subtrees = new ArrayList<Object>(this.kids.length);
        int i = 0;
        while (i < this.kids.length) {
            subtrees.add(this.kids[i].toTreeBottomup(builder));
            ++i;
        }
        Object result = builder.buildNode(this.label, subtrees);
        builder.endVisitLabel(this.label);
        return result;
    }

    public Object toTreeBottomupAmb(BottomupTreeBuilder builder) {
        ArrayList<Object> collect = new ArrayList<Object>();
        this.addToTreeAmb(builder, collect);
        return builder.buildAmb(collect);
    }

    @Override
    public Object toTreeTopdown(TopdownTreeBuilder builder) {
        if (this.isAmbNode()) {
            return builder.buildTreeAmb(this);
        }
        return builder.buildTreeNode(this);
    }

    private void addToTreeAmb(BottomupTreeBuilder builder, List<Object> collect) {
        int i = this.kids.length - 1;
        while (i >= 0) {
            AbstractParseNode alt = this.kids[i];
            if (alt.isAmbNode()) {
                ((ParseNode)alt).addToTreeAmb(builder, collect);
            } else {
                collect.add(alt.toTreeBottomup(builder));
            }
            --i;
        }
    }

    public static IStrategoList makeList(TermFactory factory, List<IStrategoTerm> terms) {
        IStrategoList result = factory.makeList();
        int i = terms.size() - 1;
        while (i >= 0) {
            result = factory.makeListCons(terms.get(i), result);
            --i;
        }
        return result;
    }

    @Override
    public String toString() {
        switch (this.nodeType) {
            case 3: {
                return "amb(" + Arrays.toString(this.kids) + ")";
            }
            case 2: {
                return "regular(aprod(" + this.label + ")," + Arrays.toString(this.kids) + ")";
            }
            case 5: {
                return "avoid(" + this.getLabel() + "," + Arrays.toString(this.kids) + ")";
            }
            case 4: {
                return "prefer(" + this.getLabel() + "," + Arrays.toString(this.kids) + ")";
            }
            case 6: {
                return "reject(" + this.getLabel() + "," + Arrays.toString(this.kids) + ")";
            }
        }
        throw new NotImplementedException();
    }

    @Override
    public int getNodeType() {
        return this.nodeType;
    }

    @Override
    public AbstractParseNode[] getChildren() {
        return this.kids;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ParseNode) || !super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ParseNode o = (ParseNode)obj;
        if (this.getNodeType() != o.getNodeType() || this.label != o.label || this.kids.length != o.kids.length || this.hashCode() != o.hashCode()) {
            return false;
        }
        int i = 0;
        while (i < this.kids.length) {
            if (!this.kids[i].equals(o.kids[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = 31 * this.label;
        AbstractParseNode[] abstractParseNodeArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode n3 = abstractParseNodeArray[n2];
            result += 31 * n3.hashCode();
            ++n2;
        }
        this.cachedHashCode = result;
        return result;
    }

    @Override
    public String toStringShallow() {
        if (this.isAmbNode()) {
            return "Amb";
        }
        return "regular*(" + this.label + ", {" + this.kids.length + "})";
    }

    @Override
    public boolean isEmpty() {
        if (this.isEmpty != null) {
            return this.isEmpty;
        }
        this.isEmpty = true;
        AbstractParseNode[] abstractParseNodeArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode kid = abstractParseNodeArray[n2];
            if (!kid.isEmpty()) {
                this.isEmpty = false;
                break;
            }
            ++n2;
        }
        return this.isEmpty;
    }

    @Override
    public AbstractParseNode getLeft() {
        return this.left;
    }

    @Override
    public boolean isLayout() {
        return this.isLayout;
    }

    @Override
    public boolean isIgnoreLayout() {
        return this.isIgnoreLayout;
    }

    @Override
    public boolean isPlaceholderInsertionNode() {
        return this.isPlaceholderInsertion;
    }

    @Override
    public boolean isLiteralCompletionNode() {
        return this.isLiteralCompletion;
    }
}

