/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import java.util.Collections;
import org.spoofax.jsglr.client.IndentInfo;
import org.spoofax.jsglr.client.IndentationHandler;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.StructuralTokenRecognizer;
import org.spoofax.jsglr.client.StructureSkipSuggestion;

public class NewStructureSkipper {
    private static final int MAX_NR_OF_LINES = 15;
    private static final int MAX_NR_OF_STRUCTURES = 8;
    private SGLR myParser;
    private StructuralTokenRecognizer structTokens;

    public ParserHistory getHistory() {
        return this.myParser.getHistory();
    }

    public NewStructureSkipper(SGLR sglr) {
        this.myParser = sglr;
        this.structTokens = new StructuralTokenRecognizer();
    }

    public ArrayList<StructureSkipSuggestion> getPreviousSkipSuggestions(int failureIndex) {
        return this.selectPrevRegion(failureIndex);
    }

    public ArrayList<StructureSkipSuggestion> getCurrentSkipSuggestions(int failureIndex) {
        ArrayList<StructureSkipSuggestion> result = this.getCurrentRegionSkips(failureIndex);
        this.addNextRegionMerges(result);
        return result;
    }

    private void addNextRegionMerges(ArrayList<StructureSkipSuggestion> result) {
        ArrayList<StructureSkipSuggestion> includeNexts = new ArrayList<StructureSkipSuggestion>();
        for (StructureSkipSuggestion skip : result) {
            for (StructureSkipSuggestion skipFW : this.selectRegion(skip.getIndexHistoryEnd())) {
                includeNexts.add(this.mergeRegions(skipFW, skip));
            }
        }
        result.addAll(includeNexts);
    }

    private ArrayList<StructureSkipSuggestion> getCurrentRegionSkips(int failureIndex) {
        ArrayList<StructureSkipSuggestion> result = new ArrayList<StructureSkipSuggestion>();
        if (failureIndex > 0 && this.isScopeOpeningLine(failureIndex) && this.getHistory().getLine(failureIndex - 1).getIndentValue() == this.getHistory().getLine(failureIndex).getIndentValue()) {
            result.addAll(this.selectRegion(failureIndex - 1));
        }
        result.addAll(this.selectRegion(failureIndex));
        return result;
    }

    public ArrayList<StructureSkipSuggestion> getPriorSkipSuggestions(int failureIndex) {
        return this.getPriorRegions(failureIndex);
    }

    public ArrayList<StructureSkipSuggestion> getSibblingBackwardSuggestions(int failureIndex) {
        ArrayList<StructureSkipSuggestion> bwSkips = new ArrayList<StructureSkipSuggestion>();
        ArrayList<StructureSkipSuggestion> priorSiblings = this.getPriorRegions(failureIndex);
        ArrayList<StructureSkipSuggestion> currentRegionSuggestions = this.selectRegion(failureIndex);
        if (currentRegionSuggestions.isEmpty()) {
            currentRegionSuggestions = this.selectPrevRegion(failureIndex);
        }
        for (StructureSkipSuggestion currSugestion : currentRegionSuggestions) {
            int i = 0;
            while (i < priorSiblings.size()) {
                StructureSkipSuggestion priorSuggestion = priorSiblings.get(i);
                if (currSugestion.getAdditionalTokens().length == 0) {
                    StructureSkipSuggestion mergedSkip = this.mergeRegions(currSugestion, priorSuggestion);
                    bwSkips.add(mergedSkip);
                }
                ++i;
            }
        }
        return bwSkips;
    }

    public ArrayList<StructureSkipSuggestion> getSibblingForwardSuggestions(int failureIndex) {
        ArrayList<StructureSkipSuggestion> fwSkips = new ArrayList<StructureSkipSuggestion>();
        ArrayList<StructureSkipSuggestion> nextSiblings = this.getCurrentAndNextSkipSuggestions(failureIndex);
        ArrayList<StructureSkipSuggestion> prevRegionSuggestions = this.selectPrevRegion(failureIndex);
        if (prevRegionSuggestions.isEmpty() && nextSiblings.size() > 0) {
            prevRegionSuggestions = this.getCurrentRegionSkips(failureIndex);
            nextSiblings.remove(0);
        }
        for (StructureSkipSuggestion priorSuggestion : prevRegionSuggestions) {
            int i = 0;
            while (i < nextSiblings.size()) {
                StructureSkipSuggestion nextSuggestion = nextSiblings.get(i);
                StructureSkipSuggestion mergedSkip = this.mergeRegions(nextSuggestion, priorSuggestion);
                fwSkips.add(mergedSkip);
                ++i;
            }
        }
        return fwSkips;
    }

    public ArrayList<StructureSkipSuggestion> getSibblingSurroundingSuggestions(int failureIndex) {
        ArrayList<StructureSkipSuggestion> surroundingSkips = new ArrayList<StructureSkipSuggestion>();
        ArrayList<StructureSkipSuggestion> priorSiblings = this.getPriorRegions(failureIndex);
        ArrayList<StructureSkipSuggestion> nextSiblings = this.getCurrentAndNextSkipSuggestions(failureIndex);
        if (nextSiblings.size() > 1 && priorSiblings.size() > 0) {
            nextSiblings.remove(0);
            StructureSkipSuggestion nextSuggestion = null;
            StructureSkipSuggestion priorSuggestion = null;
            int j = 0;
            int i = 0;
            while (i < nextSiblings.size() || j < priorSiblings.size()) {
                if (i < nextSiblings.size()) {
                    nextSuggestion = nextSiblings.get(i);
                    ++i;
                }
                if (j < priorSiblings.size()) {
                    priorSuggestion = priorSiblings.get(j);
                    ++j;
                }
                StructureSkipSuggestion mergedSkip = this.mergeRegions(nextSuggestion, priorSuggestion);
                surroundingSkips.add(mergedSkip);
                if (j >= priorSiblings.size() || (priorSuggestion = priorSiblings.get(j)).getAdditionalTokens().length == 0) continue;
                StructureSkipSuggestion mergedSkipPlus = this.mergeRegions(nextSuggestion, priorSuggestion);
                surroundingSkips.add(mergedSkipPlus);
                ++j;
            }
        }
        return surroundingSkips;
    }

    public ArrayList<StructureSkipSuggestion> getParentSkipSuggestions(int failureIndex) {
        ArrayList<StructureSkipSuggestion> parentSkips = new ArrayList<StructureSkipSuggestion>();
        int errorLineIndex = failureIndex;
        int maxBW = Math.max(failureIndex - 15, 0);
        int nrOfStructs = 0;
        while (errorLineIndex > maxBW && nrOfStructs < 8) {
            ++nrOfStructs;
            int startSkipIndex = this.findParentBegin(errorLineIndex);
            ArrayList<StructureSkipSuggestion> skips = this.selectRegion(startSkipIndex);
            if (skips.isEmpty()) {
                StructureSkipSuggestion closingSkip = new StructureSkipSuggestion();
                closingSkip.setSkipLocations(IndentInfo.cloneIndentInfo(this.getHistory().getLine(startSkipIndex)), IndentInfo.cloneIndentInfo(this.getHistory().getLine(failureIndex)), startSkipIndex, failureIndex);
                parentSkips.add(closingSkip);
            }
            parentSkips.addAll(skips);
            errorLineIndex = skips.size() > 0 ? skips.get(0).getIndexHistoryStart() : -1;
        }
        this.addNextRegionMerges(parentSkips);
        return parentSkips;
    }

    public StructureSkipSuggestion getErroneousPrefix(int failureIndex) {
        StructureSkipSuggestion prefix = new StructureSkipSuggestion();
        if (this.getHistory().getIndexLastLine() >= 0) {
            prefix.setSkipLocations(IndentInfo.cloneIndentInfo(this.getHistory().getLine(0)), IndentInfo.cloneIndentInfo(this.getHistory().getLine(failureIndex)), 0, failureIndex);
        }
        return prefix;
    }

    public ArrayList<StructureSkipSuggestion> getZoomOnPreviousSuggestions(StructureSkipSuggestion prevRegion) {
        int startIndexZoom;
        ArrayList<StructureSkipSuggestion> result = new ArrayList<StructureSkipSuggestion>();
        if (!prevRegion.canBeDecomposed()) {
            return result;
        }
        ArrayList<Integer> indentLevels = new ArrayList<Integer>();
        int i = startIndexZoom = Math.max(prevRegion.getIndexHistoryStart(), prevRegion.getIndexHistoryEnd() - 15);
        while (i < prevRegion.getIndexHistoryEnd()) {
            int indentOfLine = this.getHistory().getLine(i).getIndentValue();
            if (!indentLevels.contains(indentOfLine)) {
                indentLevels.add(indentOfLine);
            }
            ++i;
        }
        Collections.sort(indentLevels);
        indentLevels.remove(0);
        int level = 0;
        while (level < indentLevels.size()) {
            int indentOfLevel = (Integer)indentLevels.get(level);
            int lineIndex = startIndexZoom;
            while (lineIndex < prevRegion.getIndexHistoryEnd()) {
                int indentOfLine = this.getHistory().getLine(lineIndex).getIndentValue();
                if (indentOfLine == indentOfLevel) {
                    ArrayList<StructureSkipSuggestion> regions = this.selectRegion(lineIndex);
                    if (regions.size() > 0) {
                        lineIndex = regions.get(0).getIndexHistoryEnd();
                        Collections.reverse(regions);
                        result.addAll(regions);
                        continue;
                    }
                    ++lineIndex;
                    continue;
                }
                ++lineIndex;
            }
            ++level;
        }
        Collections.reverse(result);
        return result;
    }

    private ArrayList<StructureSkipSuggestion> selectRegion(int indexLine) {
        if (this.isScopeClosingLine(indexLine)) {
            return new ArrayList<StructureSkipSuggestion>();
        }
        ArrayList<Integer> endLocations = this.findCurrentEnd(indexLine);
        ArrayList<StructureSkipSuggestion> skipSuggestions = new ArrayList<StructureSkipSuggestion>();
        IndentInfo startLine = IndentInfo.cloneIndentInfo(this.getHistory().getLine(indexLine));
        for (Integer endSkipIndex : endLocations) {
            if (endSkipIndex <= indexLine) continue;
            IndentInfo endSkip = IndentInfo.cloneIndentInfo(this.getHistory().getLine(endSkipIndex));
            StructureSkipSuggestion skipConstruct = new StructureSkipSuggestion();
            skipConstruct.setSkipLocations(startLine, endSkip, indexLine, endSkipIndex);
            skipSuggestions.add(skipConstruct);
            this.addSeparatorIncludingRegion_Forwards(skipSuggestions, skipConstruct);
            this.addSeperatorIncludingRegion_Backwards(skipSuggestions, skipConstruct);
        }
        return skipSuggestions;
    }

    private ArrayList<StructureSkipSuggestion> selectPrevRegion(int indexEnd) {
        ArrayList<StructureSkipSuggestion> prevRegions = new ArrayList<StructureSkipSuggestion>();
        boolean onClosing = this.isScopeClosingLine(indexEnd);
        int indexStart = this.findPreviousBegin(indexEnd, onClosing);
        if (onClosing) {
            if (indexEnd > 0) {
                if (this.isScopeClosingLine(indexEnd - 1)) {
                    prevRegions.addAll(this.selectPrevRegion(indexEnd - 1));
                } else {
                    prevRegions.addAll(this.selectRegion(indexEnd - 1));
                }
            }
            ++indexEnd;
        }
        if (indexStart < 0 || indexEnd > this.getHistory().getIndexLastLine()) {
            return prevRegions;
        }
        IndentInfo endSkip = IndentInfo.cloneIndentInfo(this.getHistory().getLine(indexEnd));
        IndentInfo startSkip = IndentInfo.cloneIndentInfo(this.getHistory().getLine(indexStart));
        StructureSkipSuggestion previousRegion = new StructureSkipSuggestion();
        previousRegion.setSkipLocations(startSkip, endSkip, indexStart, indexEnd);
        prevRegions.add(previousRegion);
        this.addSeperatorIncludingRegion_Backwards(prevRegions, previousRegion);
        this.addSeparatorIncludingRegion_Forwards(prevRegions, previousRegion);
        return prevRegions;
    }

    private void addSeperatorIncludingRegion_Backwards(ArrayList<StructureSkipSuggestion> prevRegions, StructureSkipSuggestion previousRegion) {
        int indexStart = previousRegion.getIndexHistoryStart();
        if (indexStart > 0 && this.isSeparatorEndingLine(indexStart - 1)) {
            char[] toParse = this.structTokens.removeSeparatorAtTheEnd(this.readLine(indexStart - 1));
            IndentInfo startSkip2 = IndentInfo.cloneIndentInfo(this.getHistory().getLine(indexStart - 1));
            IndentInfo endSkip2 = IndentInfo.cloneIndentInfo(previousRegion.getEndSkip());
            StructureSkipSuggestion previousRegion2 = new StructureSkipSuggestion();
            previousRegion2.setSkipLocations(startSkip2, endSkip2, indexStart - 1, previousRegion.getIndexHistoryEnd());
            previousRegion2.setAdditionalTokens(toParse);
            prevRegions.add(previousRegion2);
        }
    }

    private void addSeparatorIncludingRegion_Forwards(ArrayList<StructureSkipSuggestion> regions, StructureSkipSuggestion aRegion) {
        if (this.isSeparatorStartingLine(aRegion.getIndexHistoryEnd())) {
            IndentInfo startSkip = IndentInfo.cloneIndentInfo(aRegion.getStartSkip());
            IndentInfo endSkip = IndentInfo.cloneIndentInfo(aRegion.getEndSkip());
            int indentShift2 = this.separatorIndent(aRegion.getIndexHistoryEnd()) - endSkip.getIndentValue();
            endSkip.setTokensSeen(endSkip.getTokensSeen() + indentShift2);
            StructureSkipSuggestion previousRegion3 = new StructureSkipSuggestion();
            previousRegion3.setSkipLocations(startSkip, endSkip, aRegion.getIndexHistoryStart(), aRegion.getIndexHistoryEnd());
            regions.add(previousRegion3);
        }
    }

    private ArrayList<StructureSkipSuggestion> getPriorRegions(int pos) {
        ArrayList<StructureSkipSuggestion> priorRegions = new ArrayList<StructureSkipSuggestion>();
        ArrayList<StructureSkipSuggestion> prevRegions = this.selectPrevRegion(pos);
        int bwMax = Math.max(pos - 15, 0);
        int nrOfStructures = 0;
        do {
            ++nrOfStructures;
            if (!prevRegions.isEmpty()) {
                pos = prevRegions.get(0).getIndexHistoryStart();
            }
            prevRegions = this.selectPrevRegion(pos);
            priorRegions.addAll(prevRegions);
        } while (pos > bwMax && nrOfStructures < 8 && !prevRegions.isEmpty());
        return priorRegions;
    }

    private ArrayList<StructureSkipSuggestion> getCurrentAndNextSkipSuggestions(int failureIndex) {
        ArrayList<StructureSkipSuggestion> nextRegions = new ArrayList<StructureSkipSuggestion>();
        ArrayList<StructureSkipSuggestion> currRegions = this.selectRegion(failureIndex);
        int fwMax = failureIndex + 15;
        int lineIndex = failureIndex;
        int nrOfStructs = 0;
        int indentValueStart = -1;
        if (currRegions.size() > 0) {
            indentValueStart = currRegions.get(0).getStartSkip().getIndentValue();
        }
        do {
            ++nrOfStructs;
            for (StructureSkipSuggestion r : currRegions) {
                if (r.getAdditionalTokens().length != 0) continue;
                nextRegions.add(r);
            }
            if (currRegions.isEmpty()) continue;
            lineIndex = currRegions.get(0).getIndexHistoryEnd();
            if (currRegions.get(0).getStartSkip().getIndentValue() >= indentValueStart) {
                currRegions = this.selectRegion(currRegions.get(0).getIndexHistoryEnd());
                continue;
            }
            currRegions.clear();
        } while (nrOfStructs < 8 && lineIndex < fwMax && !currRegions.isEmpty());
        return nextRegions;
    }

    private ArrayList<Integer> findCurrentEnd(int indexStartLine) {
        int indentStartLine = this.separatorIndent(indexStartLine);
        boolean hasIndentChilds = false;
        boolean isSecondLine = true;
        ArrayList<Integer> endLocations = new ArrayList<Integer>();
        int indexNextLine = this.skipLine(indexStartLine);
        while (this.myParser.getCurrentToken().getToken() != 256 && indexNextLine >= 0 && indexNextLine <= this.getHistory().getIndexLastLine()) {
            IndentInfo nextLine = this.getHistory().getLine(indexNextLine);
            int indentSkipPosition = nextLine.getIndentValue();
            indentShift shift = this.calculateShift(indentStartLine, indentSkipPosition);
            switch (shift) {
                case DEDENT: {
                    endLocations.add(indexNextLine);
                    return endLocations;
                }
                case INDENT: {
                    hasIndentChilds = true;
                    break;
                }
                case SAME_INDENT: {
                    if (hasIndentChilds && this.isScopeClosingLine(indexNextLine)) {
                        indexNextLine = this.skipLine(indexNextLine);
                        endLocations.add(indexNextLine);
                        return endLocations;
                    }
                    if (isSecondLine && this.isScopeOpeningLine(indexNextLine) || this.isSeparatorStartingLine(indexNextLine)) break;
                    endLocations.add(indexNextLine);
                    return endLocations;
                }
            }
            isSecondLine = false;
            indexNextLine = this.skipLine(indexNextLine);
        }
        endLocations.add(this.getHistory().getIndexLastLine());
        return endLocations;
    }

    private int findPreviousBegin(int indexLine, boolean onClosing) {
        int indentValue = this.getHistory().getLine(indexLine).getIndentValue();
        boolean sawChilds = false;
        boolean closingSeen = onClosing;
        boolean ignoreSeps = !this.isSeparatorStartingLine(indexLine);
        int indexHistoryLines = indexLine;
        block5: while (indexHistoryLines > 0) {
            int indentSkipPosition = this.getHistory().getLine(--indexHistoryLines).getIndentValue();
            indentShift shift = this.calculateShift(indentValue, indentSkipPosition);
            switch (shift) {
                case DEDENT: {
                    if (!sawChilds) {
                        return -1;
                    }
                    return indexHistoryLines;
                }
                case INDENT: {
                    if (!ignoreSeps && !this.isSeparatorStartingLine(indexHistoryLines) && this.separatorIndent(indexLine) == indentSkipPosition) {
                        return indexHistoryLines;
                    }
                    sawChilds = true;
                    break;
                }
                case SAME_INDENT: {
                    if (!sawChilds && this.isScopeClosingLine(indexHistoryLines)) {
                        if (closingSeen) {
                            return indexHistoryLines + 1;
                        }
                        closingSeen = true;
                        break;
                    }
                    if (sawChilds && this.isScopeOpeningLine(indexHistoryLines) || ignoreSeps && this.isSeparatorStartingLine(indexHistoryLines)) continue block5;
                    return indexHistoryLines;
                }
            }
        }
        return 0;
    }

    private int findParentBegin(int startLineIndex) {
        int indentStartLine = this.separatorIndent(startLineIndex);
        int indexHistoryLines = startLineIndex - 1;
        while (indexHistoryLines > 0) {
            int indentSkipPosition = this.separatorIndent(indexHistoryLines);
            indentShift shift = this.calculateShift(indentStartLine, indentSkipPosition);
            if (shift == indentShift.DEDENT) {
                if (this.isScopeOpeningLine(indexHistoryLines)) {
                    IndentInfo prevLine = this.getHistory().getLine(indexHistoryLines - 1);
                    if (!this.isScopeClosingLine(indexHistoryLines - 1) && this.calculateShift(indentSkipPosition, prevLine.getIndentValue()) == indentShift.SAME_INDENT) {
                        return indexHistoryLines - 1;
                    }
                }
                return indexHistoryLines;
            }
            --indexHistoryLines;
        }
        return 0;
    }

    private int separatorIndent(int indexLine) {
        int indentValue = this.getHistory().getLine(indexLine).getIndentValue();
        String lineContent = this.readLine(indexLine);
        return indentValue + this.structTokens.separatorIndent(lineContent);
    }

    private boolean isScopeOpeningLine(int index) {
        String lineContent = this.readLine(index);
        return this.structTokens.isScopeOpeningLine(lineContent);
    }

    private boolean isScopeClosingLine(int index) {
        String lineContent = this.readLine(index);
        return this.structTokens.isScopeClosingLine(lineContent);
    }

    private boolean isSeparatorStartingLine(int index) {
        String lineContent = this.readLine(index);
        return this.structTokens.isSeparatorStartedLine(lineContent);
    }

    private boolean isSeparatorEndingLine(int index) {
        String lineContent = this.readLine(index);
        return this.structTokens.isSeparatorEndingLine(lineContent);
    }

    private String readLine(int index) {
        while (this.getHistory().getIndexLastLine() <= index && this.myParser.getCurrentToken().getToken() != 256) {
            this.getHistory().readRecoverToken(this.myParser, false);
        }
        if (index >= 0 && index <= this.getHistory().getIndexLastLine()) {
            IndentInfo line = this.getHistory().getLine(index);
            return this.readLine(line);
        }
        return "";
    }

    private String readLine(IndentInfo line) {
        int startTok = line.getTokensSeen();
        String lineContent = this.getHistory().readLine(startTok, this.myParser.currentInputStream);
        return lineContent;
    }

    private indentShift calculateShift(int indentStartLine, int indentSkipPosition) {
        int difference = indentStartLine - indentSkipPosition;
        if (difference > 0) {
            return indentShift.DEDENT;
        }
        if (difference < 0) {
            return indentShift.INDENT;
        }
        return indentShift.SAME_INDENT;
    }

    private int skipLine(int indexLine) {
        IndentInfo line = this.getHistory().getLine(indexLine);
        IndentationHandler skipIndentHandler = new IndentationHandler();
        this.getHistory().setTokenIndex(Math.max(0, line.getTokensSeen() - 1));
        skipIndentHandler.setInLeftMargin(false);
        this.getHistory().readRecoverToken(this.myParser, false);
        while (this.myParser.getCurrentToken().getToken() != 256) {
            this.getHistory().readRecoverToken(this.myParser, false);
            skipIndentHandler.updateIndentation(this.myParser.getCurrentToken().getToken());
            if (!skipIndentHandler.lineMarginEnded()) continue;
            return ++indexLine;
        }
        return this.getHistory().getIndexLastLine();
    }

    private StructureSkipSuggestion mergeRegions(StructureSkipSuggestion fwSuggestion, StructureSkipSuggestion bwSuggestion) {
        StructureSkipSuggestion mergedSkip = new StructureSkipSuggestion();
        mergedSkip.setSkipLocations(IndentInfo.cloneIndentInfo(bwSuggestion.getStartSkip()), IndentInfo.cloneIndentInfo(fwSuggestion.getEndSkip()), bwSuggestion.getIndexHistoryStart(), fwSuggestion.getIndexHistoryEnd());
        mergedSkip.setAdditionalTokens(bwSuggestion.getAdditionalTokens());
        return mergedSkip;
    }

    public ArrayList<StructureSkipSuggestion> getBlockSuggestions(int structStartIndex) {
        ArrayList<StructureSkipSuggestion> result = this.getCurrentRegionSkips(structStartIndex);
        int endIndex = Math.min(this.getHistory().getIndexLastLine() + 1, structStartIndex + 15);
        int i = structStartIndex;
        while (i < endIndex) {
            IndentInfo startSkip = IndentInfo.cloneIndentInfo(this.getHistory().getLine(structStartIndex));
            IndentInfo endSkip = IndentInfo.cloneIndentInfo(this.getHistory().getLine(i));
            StructureSkipSuggestion block = new StructureSkipSuggestion();
            block.setSkipLocations(startSkip, endSkip, structStartIndex, i);
            result.add(block);
            ++i;
        }
        return result;
    }

    static enum indentShift {
        INDENT,
        DEDENT,
        SAME_INDENT;

    }
}

