/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.Serializable;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.ProductionAttributes;
import org.spoofax.terms.Term;

public class Label
implements Serializable {
    private static final long serialVersionUID = -4080621639747161438L;
    final int labelNumber;
    final IStrategoAppl prod;
    private final ProductionAttributes productionAttributes;
    private final boolean injection;
    private Boolean isLayout;

    public Label(int labelNumber, IStrategoAppl prod, ProductionAttributes productionAttributes, boolean injection) {
        this.labelNumber = labelNumber;
        this.prod = prod;
        this.productionAttributes = productionAttributes;
        this.injection = injection;
        if (productionAttributes == null) {
            throw new RuntimeException();
        }
    }

    public boolean isLeftAssociative() {
        return this.productionAttributes.getType() == 5;
    }

    public boolean isRightAssociative() {
        return this.productionAttributes.getType() == 6;
    }

    public boolean isRecoverProduction() {
        return this.productionAttributes.isRecoverProduction();
    }

    public boolean isCompletionProduction() {
        return this.productionAttributes.isCompletionProduction();
    }

    public boolean isMoreEager(Label rightProd) {
        return this.productionAttributes.isMoreEager(rightProd.productionAttributes);
    }

    public ProductionAttributes getAttributes() {
        return this.productionAttributes;
    }

    public boolean isInjection() {
        return this.injection;
    }

    public IStrategoAppl getProduction() {
        return this.prod;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Label && ((Label)obj).labelNumber == this.labelNumber;
    }

    public int hashCode() {
        return this.labelNumber;
    }

    public boolean isLayout() {
        block4: {
            if (this.isLayout != null) {
                return this.isLayout;
            }
            IStrategoTerm t = this.prod.getSubterm(1);
            while (true) {
                if (t.getTermType() != 1) {
                    this.isLayout = false;
                    break block4;
                }
                IStrategoAppl app = (IStrategoAppl)t;
                if (Term.hasConstructor(app, "layout")) {
                    this.isLayout = true;
                    break block4;
                }
                if (app.getSubtermCount() != 1 || !Term.hasConstructor(app, "cf") && !Term.hasConstructor(app, "lex") && !Term.hasConstructor(app, "opt") && !Term.hasConstructor(app, "iter")) break;
                t = app.getSubterm(0);
            }
            this.isLayout = false;
        }
        return this.isLayout;
    }
}

