
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://GitHub.com/Naereen/StrapDown.js/graphs/commit-activity)
[![PR's Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat)](http://makeapullrequest.com) 


# A Survey on Generative Modeling with Limited Data, Few Shots, and Zero Shot
### [Project Page](https://gmdc-survey.github.io) | [Paper](https://arxiv.org/abs/2307.14397) | [Bibtex](#bibtex)
[Milad Abdollahzadeh](https://miladabd.github.io/), [Touba Malekzadeh](https://scholar.google.com/citations?user=DgnZKiQAAAAJ&hl=en)\*, [Christopher T. H. Teo](https://scholar.google.com/citations?user=JhyGETcAAAAJ&hl=en)\*, [Keshigeyan Chandrasegaran](https://keshik6.github.io/)\*, [Guimeng Liu](https://scholar.google.com/citations?user=wJskd84AAAAJ&hl=en&oi=sra), [Ngai-Man Cheung](https://sites.google.com/site/mancheung0407/)<span>&#8224;</span>
<br>
(* Equal contribution, <span>&#8224;</span> Corresponding author)


This repo contains the list of papers with public code implementations for Generative Modeling under Data Constraint (GM-DC).
For each work, we determine the generative task(s) addressed, the approach, and the type of generative model used. 

First, we define the generative tasks, and the approach definition, and then provide our comprehensive list of the works for GM-DC with the required details for each work.


## :star: Overview
> In machine learning, generative modeling aims to learn to generate new data statistically similar to the
training data distribution. In this paper, we survey learning generative models under limited data, few shots
and zero shot, referred to as Generative Modeling under Data Constraint (GM-DC). This is an important
topic when data acquisition is challenging, e.g. healthcare applications. We discuss background, challenges,
and propose two taxonomies: one on GM-DC tasks and another on GM-DC approaches. Importantly, we
study interactions between different GM-DC tasks and approaches. Furthermore, we highlight research gaps,
research trends, and potential avenues for future exploration.

##  :earth_asia: News
* **Oct 28, 2024:** The slides for our ICIP tutorial on *"Generative Modeling for Limited Data, Few Shots and Zero Shot"* can be found [here](https://drive.google.com/file/d/1L4k2VTywZDnIhl51Or4I-kOcMt26CSP4/view?usp=sharing).
* **July 28, 2023:** First release (113 works included)!


## Generative Tasks Definition
We define 8 different generative tasks under data constraints based on the rigorous review of the literature. The description of these tasks can be found in the follwing table:

| Task | Description & Example | Illustration |
|:---------|:---------------------:|:------------:|
| **uGM-1** | **Description:** Given $K$ samples from a domain $\mathcal{D}$, learn to generate diverse and  high-quality samples from $\mathcal{D}$ <br /> **Example:** [ADA](https://arxiv.org/abs/2006.06676) learns a StyleGAN2 using 1k images from AFHQ-Dog| ![uGM1](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/14495003-55e9-4643-a798-5cfd7e43a5b7)|
| **uGM-2** | **Description:** Given a pre-trained generator on a source domain $\mathcal{D}_s$ and $K$ samples from a target domain $\mathcal{D}_t$, learn to generate diverse and high-quality samples from $\mathcal{D}_t$ <br /> **Example:** [CDC](https://arxiv.org/abs/2104.06820) adapts a pre-trained GAN on FFHQ (Human Faces) to Sketches using 10 samples| ![uGM2](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/fa0a4549-0dee-4125-a643-11c14e161405)|
| **uGM-3** | **Description:** Given a pre-trained generator on a source domain $\mathcal{D}_s$ and a text prompt describing a target domain $\mathcal{D}_t$, learn to generate diverse and high-quality samples from $\mathcal{D}_t$ <br /> **Example:** [StyleGAN-NADA](https://arxiv.org/abs/2108.00946) adapts pre-trained GAN on FFHQ to the painting domain using `Fernando Botero Painting` as input| ![uGM3](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/05dc48fa-d794-4448-9ccf-70d961a2214d)|
| **cGM-1** | **Description:** Given $K$ samples with class labels from a domain $\mathcal{D}$, learn to generate diverse and high-quality samples conditioning on the class labels from $\mathcal{D}$ <br /> **Example:** [CbC](https://arxiv.org/abs/2201.06578) trains conditional generator on 20 classes of ImageNet Carnivores using 100 images per class | ![cGM1](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/b74f20df-9499-434a-afa1-76a0ca519c2f)|
| **cGM-2** | **Description:** Given a pre-trained generator on the seen classes $C_{seen}$ of a domain $\mathcal{D}$ and $K$ samples with class labels from unseen classes $C_{unseen}$ of $\mathcal{D}$, learn to generate diverse and high-quality samples conditioning on the class labels for $C_{unseen}$ from $\mathcal{D}$ <br /> **Example:** [LoFGAN](https://ieeexplore.ieee.org/document/9710556) learns from 85 classes of Flowers to generate images for an unseen class with only 3 samples| ![cGM2](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/a2d4d83f-6de6-4b68-a929-58a97009caf6)|
| **cGM-3** | **Description:** Given a pre-trained generator on a source domain $\mathcal{D}_s$ and $K$ samples with class labels from a target domain $\mathcal{D}_t$ , learn to generate diverse and high-quality samples conditioning on the class labels from $\mathcal{D}_t$ <br /> **Example:** [VPT](https://arxiv.org/abs/2210.00990) adapts a pre-trained conditional generator on ImageNet to Places365 with 500 images per class| ![cGM3](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/d0a58267-f782-46d7-aa6a-d53d520c9ece)|
| **IGM** | **Description:** Given $K$ samples (usually $K=1$) and assuming rich internal distribution for patches within these samples, learn to generate diverse and high-quality samples with the same internal patch distribution <br /> **Example:** [SinDDM](https://arxiv.org/abs/2211.16582) trains a generator using a single image of Marina Bay Sands, and generates variants of it |![IGM](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/7d0ee556-cb72-4766-9dc1-363369719eef)|
| **SGM** | **Description:** Given a pre-trained generator, $K$ samples of a particular subject, and a text prompt, learn to generate diverse and high-quality samples containing the same subject <br /> **Example:** [DreamBooth](https://arxiv.org/abs/2208.12242) trains a  generator using 4 images of a particular backpack and adapts it with a text-prompt to be in the `grand canyon` |![SGM](https://github.com/sutd-visual-computing-group/awesome-generative-modeling-under-data-constraints/assets/29326313/d56a9fd3-45c3-4c36-aede-212cc32cc95f)|

Please refer to our survey for a more detailed discussion of these generative tasks including the attributes of each task and the data limitation range that addressed for each task.






<!-- ## Generative Modeling Tasks
Please refer to our survey paper for more details on the task definitions.

*Table in the paper is supposed to be uploaded here*

## Approaches for Generative Modeling under Data Constraints
*[link to] Sankey Diagram and other details can be included here*

*Each category and subcategory and list of all papers can be included here*
-->


<h2>Transfer Learning</h2>

<details open>
  <summary>Click to expand/collapse 50 works</summary>

- **Transferring GANs: generating images from limited data**<br>ECCV 2018<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-030-01231-1_14' target='_blank'>Paper</a>] [<a href='https://github.com/yaxingwang/Transferring-GANs' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-3.svg' width='60'/>](#0)  [<img src='./assets/task/uGM-2.svg' width='60'/>](#0)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#0)  [<img src='./assets/model/GAN.svg' width='60'/>](#0)</div>
- **Image Generation from Small Datasets via Batch Statistics Adaptation**<br>ICCV 2019<br>[<a href='https://openaccess.thecvf.com/content_ICCV_2019/html/Noguchi_Image_Generation_From_Small_Datasets_via_Batch_Statistics_Adaptation_ICCV_2019_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/nogu-atsu/small-dataset-image-generation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#2)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#2)  [<img src='./assets/model/GAN.svg' width='60'/>](#2)</div>
- **Freeze the Discriminator: a Simple Baseline for Fine-tuning GANs**<br>CVPR 2020-W<br>[<a href='https://arxiv.org/abs/2002.10964' target='_blank'>Paper</a>] [<a href='https://github.com/sangwoomo/FreezeD' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#3)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#3)  [<img src='./assets/model/GAN.svg' width='60'/>](#3)</div>
- **On Leveraging Pretrained GANs for Generation with Limited Data**<br>ICML 2020<br>[<a href='https://proceedings.mlr.press/v119/zhao20a.html' target='_blank'>Paper</a>] [<a href='https://github.com/MiaoyunZhao/GANTransferLimitedData' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#8)  [<img src='./assets/approaches/Modulation.svg' width='115'/>](#8)  [<img src='./assets/model/GAN.svg' width='60'/>](#8)</div>
- **Few-Shot Image Generation with Elastic Weight Consolidation**<br>NeurIPS 2020<br>[<a href='https://proceedings.neurips.cc//paper_files/paper/2020/hash/b6d767d2f8ed5d21a44b0e5886680cb9-Abstract.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#9)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#9)  [<img src='./assets/model/GAN.svg' width='60'/>](#9)</div>
- **GAN Memory with No Forgetting**<br>NeurIPS 2020<br>[<a href='https://papers.nips.cc/paper_files/paper/2020/hash/bf201d5407a6509fa536afc4b380577e-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/MiaoyunZhao/GANmemory_LifelongLearning' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#10)  [<img src='./assets/approaches/Modulation.svg' width='115'/>](#10)  [<img src='./assets/model/GAN.svg' width='60'/>](#10)</div>
- **Few-Shot Adaptation of Generative Adversarial Networks**<br>arXiv 2020<br>[<a href='https://arxiv.org/abs/2010.11943' target='_blank'>Paper</a>] [<a href='https://github.com/e-271/few-shot-gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#31)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#31)  [<img src='./assets/model/GAN.svg' width='60'/>](#31)</div>
- **Effective Knowledge Transfer from GANs to Target domains with Few Images**<br>CVPR 2021<br>[<a href='https://openaccess.thecvf.com/content_CVPR_2020/html/Wang_MineGAN_Effective_Knowledge_Transfer_From_GANs_to_Target_Domains_With_CVPR_2020_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/yaxingwang/MineGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-3.svg' width='60'/>](#4)  [<img src='./assets/task/uGM-2.svg' width='60'/>](#4)  [<img src='./assets/approaches/Latent Space.svg' width='125'/>](#4)  [<img src='./assets/model/GAN.svg' width='60'/>](#4)</div>
- **Few-Shot Image Generation via Cross-domain Correspondence**<br>CVPR 2021<br>[<a href='https://openaccess.thecvf.com/content/CVPR2021/html/Ojha_Few-Shot_Image_Generation_via_Cross-Domain_Correspondence_CVPR_2021_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/utkarshojha/few-shot-gan-adaptation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#12)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#12)  [<img src='./assets/model/GAN.svg' width='60'/>](#12)</div>
- **Efficient Conditional GAN Transfer with Konwledge Propagation across Classes**<br>CVPR 2021<br>[<a href='https://openaccess.thecvf.com/content/CVPR2021/html/Shahbazi_Efficient_Conditional_GAN_Transfer_With_Knowledge_Propagation_Across_Classes_CVPR_2021_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/mshahbazi72/cGANTransfer' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#13)  [<img src='./assets/task/cGM-3.svg' width='60'/>](#13)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#13)  [<img src='./assets/model/GAN.svg' width='60'/>](#13)</div>
- **CAM-GAN: Continual Adaptation Modules for Generative Adversarial Networks**<br>NeurIPS 2021<br>[<a href='https://papers.nips.cc/paper_files/paper/2021/hash/8073bd4ed0fe0c330290c58056a2cd5e-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/sakshivarshney/CAM-GAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#11)  [<img src='./assets/approaches/Modulation.svg' width='115'/>](#11)  [<img src='./assets/model/GAN.svg' width='60'/>](#11)</div>
- **Contrastive Learning for Cross-domain Correspondence in Few-shot Image Generation**<br>NeurIPS 2021-W<br>[<a href='https://ctrlgenworkshop.github.io/camready/40/CameraReady/NIPS_Workshop_camera_ready.pdf' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#41)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#41)  [<img src='./assets/model/GAN.svg' width='60'/>](#41)</div>
- **Instance-Conditioned GAN**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/e7ac288b0f2d41445904d071ba37aaff-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/facebookresearch/ic_gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#48)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#48)  [<img src='./assets/model/GAN.svg' width='60'/>](#48)</div>
- **Mining Generative Models for Efficient Knowledge Transfer to Limited Data Domains**<br>arXiv 2021<br>[<a href='https://arxiv.org/abs/2104.13742' target='_blank'>Paper</a>] [<a href='https://github.com/yaxingwang/MineGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-3.svg' width='60'/>](#6)  [<img src='./assets/task/uGM-2.svg' width='60'/>](#6)  [<img src='./assets/approaches/Latent Space.svg' width='125'/>](#6)  [<img src='./assets/model/GAN.svg' width='60'/>](#6)</div>
- **One-Shot Generative Domain Adaptation**<br>arXiv 2021<br>[<a href='https://arxiv.org/abs/2111.09876' target='_blank'>Paper</a>] [<a href='https://github.com/genforce/genda' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#30)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#30)  [<img src='./assets/model/GAN.svg' width='60'/>](#30)</div>
- **When, Why, and Which Pre-trained GANs are useful?**<br>ICLR 2022<br>[<a href='https://openreview.net/forum?id=4Ycr8oeCoIh' target='_blank'>Paper</a>] [<a href='https://github.com/yandex-research/gan-transfer' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#15)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#15)  [<img src='./assets/model/GAN.svg' width='60'/>](#15)</div>
- **Domain Gap Control for Single Shot Domain Adaptation for Generative Adversarial Networks**<br>ICLR 2022<br>[<a href='https://openreview.net/forum?id=vqGi8Kp0wM' target='_blank'>Paper</a>] [<a href='https://github.com/ZPdesu/MindTheGap' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-3.svg' width='60'/>](#23)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#23)  [<img src='./assets/model/GAN.svg' width='60'/>](#23)</div>
- **A Closer Look at Few-Shot Image Generation**<br>CVPR 2022<br>[<a href='https://openaccess.thecvf.com/content/CVPR2022/html/Zhao_A_Closer_Look_at_Few-Shot_Image_Generation_CVPR_2022_paper.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#16)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#16)  [<img src='./assets/model/GAN.svg' width='60'/>](#16)</div>
- **Few shot generative model adaption via relaxed spatial structural alignment**<br>CVPR 2022<br>[<a href='https://openaccess.thecvf.com/content/CVPR2022/html/Xiao_Few_Shot_Generative_Model_Adaption_via_Relaxed_Spatial_Structural_Alignment_CVPR_2022_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/StevenShaw1999/RSSA' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#17)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#17)  [<img src='./assets/model/GAN.svg' width='60'/>](#17)</div>
- **One Shot Face Stylization**<br>ECCV 2022<br>[<a href='https://www.ecva.net/papers/eccv_2022/papers_ECCV/html/3623_ECCV_2022_paper.php' target='_blank'>Paper</a>] [<a href='https://github.com/mchong6/JoJoGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#32)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#32)  [<img src='./assets/model/GAN.svg' width='60'/>](#32)</div>
- **Few-shot Image Generation via Adaptation-Aware Kernel Modulation**<br>NeurIPS 2022<br>[<a href='https://papers.nips.cc/paper_files/paper/2022/hash/7b122d0a0dcb1a86ffa25ccba154652b-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/yunqing-me/AdAM' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#18)  [<img src='./assets/approaches/Modulation.svg' width='115'/>](#18)  [<img src='./assets/approaches/Adaptation-Aware.svg' width='175'/>](#18)  [<img src='./assets/model/GAN.svg' width='60'/>](#18)</div>
- **Universal Domain Adaptation for Generative Adversarial Networks**<br>NeurIPS 2022<br>[<a href='https://papers.nips.cc/paper_files/paper/2022/hash/bd1fc5cbedfe4d90d0ac2d23966fa27e-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/MACderRu/HyperDomainNet' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#24)  [<img src='./assets/task/uGM-3.svg' width='60'/>](#24)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#24)  [<img src='./assets/approaches/Modulation.svg' width='115'/>](#24)  [<img src='./assets/model/GAN.svg' width='60'/>](#24)</div>
- **Generalized One-shot Domain Adaptation of Generative Adversarial Networks**<br>NeurIPS 2022<br>[<a href='https://papers.nips.cc/paper_files/paper/2022/hash/58ce6a4b9c16d11975f11e4a23871041-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/zhangzc21/Generalized-One-shot-GAN-adaptation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#28)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#28)  [<img src='./assets/model/GAN.svg' width='60'/>](#28)</div>
- **Towards Diverse and Faithful One-shot Adaption of Generative Adversarial Networks**<br>NeurIPS 2022<br>[<a href='https://papers.nips.cc/paper_files/paper/2022/hash/f2184e55a13b73b89f618ad24abb6ca7-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/YBYBZhang/DiFa' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#58)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#58)  [<img src='./assets/model/GAN.svg' width='60'/>](#58)</div>
- **CLIP-Guided Domain Adaptation of Image Generators**<br>ACM-TOG 2022<br>[<a href='https://dl.acm.org/doi/abs/10.1145/3528223.3530164' target='_blank'>Paper</a>] [<a href='https://github.com/rinongal/StyleGAN-nada' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-3.svg' width='60'/>](#22)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#22)  [<img src='./assets/model/GAN.svg' width='60'/>](#22)</div>
- **Dynamic Few-shot Adaptation of GANs to Multiple Domains**<br>SIGGRAPH-Asia 2022<br>[<a href='https://dl.acm.org/doi/fullHtml/10.1145/3550469.3555416' target='_blank'>Paper</a>] [<a href='https://github.com/blueGorae/DynaGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#29)  [<img src='./assets/approaches/Modulation.svg' width='115'/>](#29)  [<img src='./assets/model/GAN.svg' width='60'/>](#29)</div>
- **Exploiting Knowledge Distillation for Few-Shot Image Generation**<br>arXiv 2022<br>[<a href='https://openreview.net/forum?id=vsEi1UMa7TC' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#35)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#35)  [<img src='./assets/model/GAN.svg' width='60'/>](#35)</div>
- **Few-shot Artistic Portraits Generation with Contrastive Transfer Learning**<br>arXiv 2022<br>[<a href='https://arxiv.org/abs/2203.08612' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#36)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#36)  [<img src='./assets/model/GAN.svg' width='60'/>](#36)</div>
- **Dynamic Weighted Semantic Correspondence for Few-Shot Image Generative Adaptation**<br>ACM-MM 2022<br>[<a href='https://dl.acm.org/doi/abs/10.1145/3503161.3548270' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#50)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#50)  [<img src='./assets/model/GAN.svg' width='60'/>](#50)</div>
- **Fair Generative Models via Transfer Learning**<br>AAAI 2023<br>[<a href='https://ojs.aaai.org/index.php/AAAI/article/view/25339' target='_blank'>Paper</a>] [<a href='https://github.com/Bearwithchris/Fair-Generative-Model-via-Transfer-Learning' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#20)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#20)  [<img src='./assets/model/GAN.svg' width='60'/>](#20)</div>
- **Progressive Few-Shot Adaptation of Generative Model with Align-Free Spatial Correlation**<br>AAAI 2023<br>[<a href='https://ojs.aaai.org/index.php/AAAI/article/view/25283' target='_blank'>Paper</a>] [<a href='https://github.com/arith3/Progressive-Few-Shot-GAN-Adaptation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#54)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#54)  [<img src='./assets/model/GAN.svg' width='60'/>](#54)</div>
- **Few-shot Cross-domain Image Generation via Inference-time Latent-code Learning**<br>ICLR 2023<br>[<a href='https://openreview.net/forum?id=sCYXJr3QJM8' target='_blank'>Paper</a>] [<a href='https://github.com/arnabkmondal/GenDA' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#37)  [<img src='./assets/approaches/Latent Space.svg' width='125'/>](#37)  [<img src='./assets/model/GAN.svg' width='60'/>](#37)</div>
- **Exploring Incompatible Knowledge Transfer in Few-shot Image Generation**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Zhao_Exploring_Incompatible_Knowledge_Transfer_in_Few-Shot_Image_Generation_CVPR_2023_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/yunqing-me/RICK' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#21)  [<img src='./assets/approaches/Adaptation-Aware.svg' width='175'/>](#21)  [<img src='./assets/model/GAN.svg' width='60'/>](#21)</div>
- **Zero-shot Generative Model Adaptation via Image-specific Prompt Learning**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Guo_Zero-Shot_Generative_Model_Adaptation_via_Image-Specific_Prompt_Learning_CVPR_2023_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/Picsart-AI-Research/IPL-Zero-Shot-Generative-Model-Adaptation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-3.svg' width='60'/>](#38)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#38)  [<img src='./assets/model/GAN.svg' width='60'/>](#38)</div>
- **Visual Prompt Tuning for Generative Transfer Learning**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Sohn_Visual_Prompt_Tuning_for_Generative_Transfer_Learning_CVPR_2023_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/google-research/generative_transfer' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#39)  [<img src='./assets/task/cGM-3.svg' width='60'/>](#39)  [<img src='./assets/approaches/Prompt Tuning.svg' width='125'/>](#39)  [<img src='./assets/model/VQ-VAE.svg' width='60'/>](#39)</div>
- **SINgle Image Editing with Text-to-Image Diffusion Models**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Zhang_SINE_SINgle_Image_Editing_With_Text-to-Image_Diffusion_Models_CVPR_2023_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/zhang-zx/SINE' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#42)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#42)  [<img src='./assets/model/DM.svg' width='60'/>](#42)</div>
- **DreamBooth: Fine Tuning Text-to-Image Diffusion Models for Subject-Driven Generation**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Ruiz_DreamBooth_Fine_Tuning_Text-to-Image_Diffusion_Models_for_Subject-Driven_Generation_CVPR_2023_paper.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/SGM.svg' width='60'/>](#43)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#43)  [<img src='./assets/model/DM.svg' width='60'/>](#43)</div>
- **Multi-Concept Customization of Text-to-Image Diffusion**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Kumari_Multi-Concept_Customization_of_Text-to-Image_Diffusion_CVPR_2023_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/adobe-research/custom-diffusion' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/SGM.svg' width='60'/>](#44)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#44)  [<img src='./assets/model/DM.svg' width='60'/>](#44)</div>
- **Plug-and-Play Sample-Efficient Fine-Tuning of Text-to-Image Diffusion Models to Learn Any Unseen Style**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Lu_Specialist_Diffusion_Plug-and-Play_Sample-Efficient_Fine-Tuning_of_Text-to-Image_Diffusion_Models_To_CVPR_2023_paper.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#56)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#56)  [<img src='./assets/model/DM.svg' width='60'/>](#56)</div>
- **Target-Aware Generative Augmentations for Single-Shot Adaptation**<br>ICML 2023<br>[<a href='https://proceedings.mlr.press/v202/thopalli23a.html' target='_blank'>Paper</a>] [<a href='https://github.com/Rakshith-2905/SiSTA' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#51)  [<img src='./assets/approaches/Latent Space.svg' width='125'/>](#51)  [<img src='./assets/model/GAN.svg' width='60'/>](#51)</div>
- **MultiDiffusion:Fusing Diffusion Paths for Controlled Image Generation**<br>ICML 2023<br>[<a href='https://proceedings.mlr.press/v202/bar-tal23a.html' target='_blank'>Paper</a>] [<a href='https://github.com/omerbt/MultiDiffusion' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#52)  [<img src='./assets/approaches/Latent Space.svg' width='125'/>](#52)  [<img src='./assets/model/DM.svg' width='60'/>](#52)</div>
- **Data-Dependent Domain Transfer GANs for Image Generation with Limited Data**<br>AC-MTMCCA 2023<br>[<a href='https://dl.acm.org/doi/abs/10.1145/3576858' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#33)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#33)  [<img src='./assets/model/GAN.svg' width='60'/>](#33)</div>
- **One-Shot Adaptation of GAN in Just One CLIP**<br>TPAMI 2023<br>[<a href='https://arxiv.org/abs/2203.09301' target='_blank'>Paper</a>] [<a href='https://github.com/cyclomon/OneshotCLIP' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#34)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#34)  [<img src='./assets/model/GAN.svg' width='60'/>](#34)</div>
- **Few-shot Image Generation via Masked Discrimination**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2210.15194' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#45)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#45)  [<img src='./assets/model/GAN.svg' width='60'/>](#45)</div>
- **Few-shot Image Generation via Latent Space Relocation**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2305.06671' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#46)  [<img src='./assets/approaches/Latent Space.svg' width='125'/>](#46)  [<img src='./assets/model/GAN.svg' width='60'/>](#46)</div>
- **Faster Few-Shot Face Image Generation with Features of Specific Group Using Pivotal Tuning Inversion and PCA**<br>ICAIIC 2023<br>[<a href='https://ieeexplore.ieee.org/document/10067122' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#47)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#47)  [<img src='./assets/model/GAN.svg' width='60'/>](#47)</div>
- **Few-shot Image Generation with Diffusion Models**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2211.03264' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#49)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#49)  [<img src='./assets/model/DM.svg' width='60'/>](#49)</div>
- **Rethinking cross-domain semantic relation for few-shot image generation**<br>Applied-Inteligence 2023<br>[<a href='https://link.springer.com/article/10.1007/s10489-023-04602-8' target='_blank'>Paper</a>] [<a href='https://github.com/gouayao/CSR' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#53)  [<img src='./assets/approaches/Regularizer-based Fine-Tuning.svg' width='225'/>](#53)  [<img src='./assets/model/GAN.svg' width='60'/>](#53)</div>
- **An Image is Worth One Word: Personalizing Text-to-Image Generation using Textual Inversion**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2208.01618' target='_blank'>Paper</a>] [<a href='https://github.com/rinongal/textual_inversion' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/SGM.svg' width='60'/>](#55)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#55)  [<img src='./assets/model/DM.svg' width='60'/>](#55)</div>
- **BLIP-Diffusion: Pre-trained Subject Representation for Controllable Text-to-Image Generation and Editing**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2305.14720' target='_blank'>Paper</a>] [<a href='https://github.com/salesforce/LAVIS/tree/main/projects/blip-diffusion' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/SGM.svg' width='60'/>](#57)  [<img src='./assets/approaches/Natural-Language Guided.svg' width='225'/>](#57)  [<img src='./assets/model/DM.svg' width='60'/>](#57)</div>


</details>



## Data Augmentation

<details open>
  <summary>Click to expand/collapse 12 works</summary>

- **Consistency Regularization for Generative Adversarial Networks**<br>ICLR 2019<br>[<a href='https://openreview.net/forum?id=S1lxKlSKPH' target='_blank'>Paper</a>] [<a href='https://github.com/google/compare_gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#0)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#0)  [<img src='./assets/model/GAN.svg' width='60'/>](#0)</div>
- **Training generative adversarial networks with limited data**<br>NeurIPS 2020<br>[<a href='https://papers.nips.cc/paper/2020/hash/8d30aa96e72440759f74bd2306c1fa3d-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/NVlabs/stylegan2-ada-pytorch' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#2)  [<img src='./assets/task/cGM-1.svg' width='60'/>](#2)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#2)  [<img src='./assets/model/GAN.svg' width='60'/>](#2)</div>
- **Differentiable Augmentation for Data-efficient GAN Training**<br>NeurIPS 2020<br>[<a href='https://proceedings.neurips.cc/paper/2020/hash/55479c55ebd1efd3ff125f1337100388-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/mit-han-lab/data-efficient-gans' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#4)  [<img src='./assets/task/cGM-1.svg' width='60'/>](#4)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#4)  [<img src='./assets/model/GAN.svg' width='60'/>](#4)</div>
- **Image Augmentations for GAN Training**<br>arXiv 2020<br>[<a href='https://arxiv.org/abs/2006.02595' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#7)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#7)  [<img src='./assets/model/GAN.svg' width='60'/>](#7)</div>
- **Improved Consistency Regularization for GANs**<br>AAAI 2021<br>[<a href='https://ojs.aaai.org/index.php/AAAI/article/view/17317' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#1)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#1)  [<img src='./assets/model/GAN.svg' width='60'/>](#1)</div>
- **DeceiveD: Adaptive pseudo augmentation for gan training with limited data**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/b534ba68236ba543ae44b22bd110a1d6-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/EndlessSora/DeceiveD' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#8)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#8)  [<img src='./assets/model/GAN.svg' width='60'/>](#8)</div>
- **Data-efficient gan training beyond (just) augmentations: A lottery ticket perspective**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/af4f00ca48321fb026865c5a1772dafd-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/VITA-Group/Ultra-Data-Efficient-GAN-Training' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#9)  [<img src='./assets/approaches/Feature-level Augmentation.svg' width='225'/>](#9)  [<img src='./assets/model/GAN.svg' width='60'/>](#9)</div>
- **Self-Supervised GANs with Label Augmentation**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/6cb5da3513bd26085ee3fad631ebb37a-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/liang-hou/ssgan-la' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#10)  [<img src='./assets/approaches/Transformation-Driven Design.svg' width='225'/>](#10)  [<img src='./assets/model/GAN.svg' width='60'/>](#10)</div>
- **On Data Augmentation for GAN Training**<br>TIP 2021<br>[<a href='https://dl.acm.org/doi/10.1109/TIP.2021.3049346' target='_blank'>Paper</a>] [<a href='https://github.com/sutd-visual-computing-group/dag-gans' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#6)  [<img src='./assets/approaches/Transformation-Driven Design.svg' width='225'/>](#6)  [<img src='./assets/model/GAN.svg' width='60'/>](#6)</div>
- **Adaptive Feature Interpolation for Low-Shot Image Generation**<br>ECCV 2022<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-031-19784-0_15' target='_blank'>Paper</a>] [<a href='https://github.com/dzld00/adaptive-feature-interpolation-for-low-shot-image-generation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#13)  [<img src='./assets/approaches/Feature-level Augmentation.svg' width='225'/>](#13)  [<img src='./assets/model/GAN.svg' width='60'/>](#13)</div>
- **Training GANs with Diffusion**<br>ICLR 2023<br>[<a href='https://openreview.net/forum?id=HZf7UbpWHuA' target='_blank'>Paper</a>] [<a href='https://github.com/Zhendong-Wang/Diffusion-GAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#12)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#12)  [<img src='./assets/model/DM.svg' width='60'/>](#12)</div>
- **Faster and More Data-Efficient Training of Diffusion Models**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2304.12526' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#11)  [<img src='./assets/approaches/Image-level Augmentation.svg' width='200'/>](#11)  [<img src='./assets/model/DM.svg' width='60'/>](#11)</div>


</details>


## Network Architectures

<details open>
  <summary>Click to expand/collapse 11 works</summary>

- **Towards faster and stabilized gan training for high-fidelity few-shot image synthesis**<br>ICLR 2021<br>[<a href='https://openreview.net/forum?id=1Fqg133qRaI' target='_blank'>Paper</a>] [<a href='https://github.com/odegeasslbc/FastGAN-pytorch' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#1)  [<img src='./assets/approaches/Feature Enhancement.svg' width='175'/>](#1)  [<img src='./assets/model/GAN.svg' width='60'/>](#1)</div>
- **Data-efficient gan training beyond (just) augmentations: A lottery ticket perspective**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/af4f00ca48321fb026865c5a1772dafd-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/VITA-Group/Ultra-Data-Efficient-GAN-Training' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#0)  [<img src='./assets/approaches/Dynamic Network Architecture.svg' width='225'/>](#0)  [<img src='./assets/model/GAN.svg' width='60'/>](#0)</div>
- **Projected GANs Converge Faster**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/9219adc5c42107c4911e249155320648-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/autonomousvision/projected-gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#2)  [<img src='./assets/approaches/Ensemble Large Pretrained Vision Models.svg' width='300'/>](#2)  [<img src='./assets/model/GAN.svg' width='60'/>](#2)</div>
- **Prototype Memory and Attention Mechanisms for Few Shot Image Generation**<br>ICLR 2022<br>[<a href='https://openreview.net/forum?id=lY0-7bj0Vfz' target='_blank'>Paper</a>] [<a href='https://github.com/Crazy-Jack/MoCA_release' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#3)  [<img src='./assets/approaches/Feature Enhancement.svg' width='175'/>](#3)  [<img src='./assets/model/GAN.svg' width='60'/>](#3)</div>
- **Collapse by conditioning: Training class-conditional GANs with limited data**<br>ICLR 2022<br>[<a href='https://openreview.net/forum?id=7TZeCsNOUB_' target='_blank'>Paper</a>] [<a href='https://github.com/mshahbazi72/transitional-cGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-1.svg' width='60'/>](#4)  [<img src='./assets/approaches/Dynamic Network Architecture.svg' width='225'/>](#4)  [<img src='./assets/model/GAN.svg' width='60'/>](#4)</div>
- **Ensembling Off-the-shelf Models for GAN Training**<br>CVPR 2022<br>[<a href='https://openaccess.thecvf.com/content/CVPR2022/html/Kumari_Ensembling_Off-the-Shelf_Models_for_GAN_Training_CVPR_2022_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/nupurkmr9/vision-aided-gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#5)  [<img src='./assets/approaches/Ensemble Large Pretrained Vision Models.svg' width='300'/>](#5)  [<img src='./assets/model/GAN.svg' width='60'/>](#5)</div>
- **Hierarchical Context Aggregation for Few-Shot Generation**<br>ICML 2022<br>[<a href='https://proceedings.mlr.press/v162/giannone22a.html' target='_blank'>Paper</a>] [<a href='https://github.com/georgosgeorgos/hierarchical-few-shot-generative-models' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#9)  [<img src='./assets/approaches/Feature Enhancement.svg' width='175'/>](#9)  [<img src='./assets/model/VAE.svg' width='60'/>](#9)</div>
- **Improving GANs with A Dynamic Discriminator**<br>NeurIPS 2022<br>[<a href='https://proceedings.neurips.cc/paper_files/paper/2022/hash/6174c67b136621f3f2e4a6b1d3286f6b-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/genforce/dynamicd' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#6)  [<img src='./assets/approaches/Dynamic Network Architecture.svg' width='225'/>](#6)  [<img src='./assets/model/GAN.svg' width='60'/>](#6)</div>
- **Data-Efficient GANs Training via Architectural Reconfiguration**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Saxena_Re-GAN_Data-Efficient_GANs_Training_via_Architectural_Reconfiguration_CVPR_2023_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/intellicentai-lab/re-gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#8)  [<img src='./assets/approaches/Dynamic Network Architecture.svg' width='225'/>](#8)  [<img src='./assets/model/GAN.svg' width='60'/>](#8)</div>
- **Introducing editable and representative attributes for few-shot image generation**<br>Engineering Applications of AI 2023<br>[<a href='https://www.sciencedirect.com/science/article/pii/S0952197622005097' target='_blank'>Paper</a>] [<a href='https://github.com/kobeshegu/DFSGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#7)  [<img src='./assets/approaches/Feature Enhancement.svg' width='175'/>](#7)  [<img src='./assets/model/GAN.svg' width='60'/>](#7)</div>
- **Toward a better image synthesis GAN framework for high-fidelity few-shot datasets via NAS and contrastive learning**<br>Elsevier KBS 2023<br>[<a href='https://www.sciencedirect.com/science/article/pii/S0950705123005075' target='_blank'>Paper</a>] [<a href='https://github.com/shijiachen1/AutoInfoGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#10)  [<img src='./assets/approaches/Dynamic Network Architecture.svg' width='225'/>](#10)  [<img src='./assets/model/GAN.svg' width='60'/>](#10)</div>


</details>


## Multi-Task Objectives

<details open>
  <summary>Click to expand/collapse 25 works</summary>

- **Image Augmentations for GAN Training**<br>arXiv 2020<br>[<a href='https://arxiv.org/abs/2006.02595' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#5)  [<img src='./assets/approaches/Contrastive Learning.svg' width='175'/>](#5)  [<img src='./assets/model/GAN.svg' width='60'/>](#5)</div>
- **Regularizing generative adversarial networks under limited data**<br>CVPR 2021<br>[<a href='https://openaccess.thecvf.com/content/CVPR2021/html/Tseng_Regularizing_Generative_Adversarial_Networks_Under_Limited_Data_CVPR_2021_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/google/lecam-gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#9)  [<img src='./assets/approaches/Regularizer.svg' width='125'/>](#9)  [<img src='./assets/model/GAN.svg' width='60'/>](#9)</div>
- **Contrastive Learning for Cross-domain Correspondence in Few-shot Image Generation**<br>NeurIPS 2021-W<br>[<a href='https://ctrlgenworkshop.github.io/camready/40/CameraReady/NIPS_Workshop_camera_ready.pdf' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#3)  [<img src='./assets/approaches/Contrastive Learning.svg' width='175'/>](#3)  [<img src='./assets/model/GAN.svg' width='60'/>](#3)</div>
- **Data-Efficient Instance Generation from Instance Discrimination**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/4e0d67e54ad6626e957d15b08ae128a6-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/genforce/insgen' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#11)  [<img src='./assets/approaches/Contrastive Learning.svg' width='175'/>](#11)  [<img src='./assets/model/GAN.svg' width='60'/>](#11)</div>
- **Diffusion-Decoding Models for Few-Shot Conditional Generation**<br>NeurIPS 2021<br>[<a href='https://proceedings.neurips.cc/paper/2021/hash/682e0e796084e163c5ca053dd8573b0c-Abstract.html' target='_blank'>Paper</a>] [<a href='https://github.com/jiamings/d2c' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-1.svg' width='60'/>](#20)  [<img src='./assets/approaches/Other Multi-Task Objectives.svg' width='200'/>](#20)  [<img src='./assets/model/VAE.svg' width='60'/>](#20)</div>
- **Generative Co-training for Generative Adversarial Networks with Limited Data**<br>AAAI 2022<br>[<a href='https://ojs.aaai.org/index.php/AAAI/article/view/19928' target='_blank'>Paper</a>] [<a href='https://github.com/jxhuang0508/GenCo' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#13)  [<img src='./assets/approaches/Other Multi-Task Objectives.svg' width='200'/>](#13)  [<img src='./assets/model/GAN.svg' width='60'/>](#13)</div>
- **Prototype Memory and Attention Mechanisms for Few Shot Image Generation**<br>ICLR 2022<br>[<a href='https://openreview.net/forum?id=lY0-7bj0Vfz' target='_blank'>Paper</a>] [<a href='https://github.com/Crazy-Jack/MoCA_release' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#8)  [<img src='./assets/approaches/Prototype Learning.svg' width='150'/>](#8)  [<img src='./assets/model/GAN.svg' width='60'/>](#8)</div>
- **A Closer Look at Few-Shot Image Generation**<br>CVPR 2022<br>[<a href='https://openaccess.thecvf.com/content/CVPR2022/html/Zhao_A_Closer_Look_at_Few-Shot_Image_Generation_CVPR_2022_paper.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#0)  [<img src='./assets/approaches/Contrastive Learning.svg' width='175'/>](#0)  [<img src='./assets/model/GAN.svg' width='60'/>](#0)</div>
- **Few-shot Image Generation with Mixup-based Distance Learning**<br>ECCV 2022<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-031-19784-0_33' target='_blank'>Paper</a>] [<a href='https://github.com/reyllama/mixdl' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#15)  [<img src='./assets/approaches/Regularizer.svg' width='125'/>](#15)  [<img src='./assets/model/GAN.svg' width='60'/>](#15)</div>
- **Exploring Contrastive Learning for Solving Latent Discontinuity in Data-Efficient GANs**<br>ECCV 2022<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-031-19784-0_35' target='_blank'>Paper</a>] [<a href='https://github.com/iceli1007/FakeCLR' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#16)  [<img src='./assets/approaches/Contrastive Learning.svg' width='175'/>](#16)  [<img src='./assets/model/GAN.svg' width='60'/>](#16)</div>
- **Any-resolution Training for High-resolution Image Synthesis**<br>ECCV 2022<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-031-19787-1_10' target='_blank'>Paper</a>] [<a href='https://github.com/chail/anyres-gan' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#19)  [<img src='./assets/approaches/Other Multi-Task Objectives.svg' width='200'/>](#19)  [<img src='./assets/model/GAN.svg' width='60'/>](#19)</div>
- **Discriminator gradIent Gap Regularization for GAN Training with Limited Data**<br>NeurIPS 2022<br>[<a href='https://proceedings.neurips.cc/paper_files/paper/2022/hash/ce26d21662c979d515164b416d4571fe-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/AilsaF/DigGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#10)  [<img src='./assets/approaches/Regularizer.svg' width='125'/>](#10)  [<img src='./assets/model/GAN.svg' width='60'/>](#10)</div>
- **Masked Generative Adversarial Networks are Data-Efficient Generation Learners**<br>NeurIPS 2022<br>[<a href='https://proceedings.neurips.cc/paper_files/paper/2022/hash/0efcb1885b8534109f95ca82a5319d25-Abstract-Conference.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#14)  [<img src='./assets/approaches/Masking.svg' width='85'/>](#14)  [<img src='./assets/model/GAN.svg' width='60'/>](#14)</div>
- **Exploiting Knowledge Distillation for Few-Shot Image Generation**<br>arXiv 2022<br>[<a href='https://openreview.net/forum?id=vsEi1UMa7TC' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#1)  [<img src='./assets/approaches/Knowledge Distillation.svg' width='175'/>](#1)  [<img src='./assets/model/GAN.svg' width='60'/>](#1)</div>
- **Few-shot Artistic Portraits Generation with Contrastive Transfer Learning**<br>arXiv 2022<br>[<a href='https://arxiv.org/abs/2203.08612' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#2)  [<img src='./assets/approaches/Contrastive Learning.svg' width='175'/>](#2)  [<img src='./assets/model/GAN.svg' width='60'/>](#2)</div>
- **Few-Shot Diffusion Models**<br>arXiv 2022<br>[<a href='https://arxiv.org/abs/2205.15463' target='_blank'>Paper</a>] [<a href='https://github.com/georgosgeorgos/few-shot-diffusion-models' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#21)  [<img src='./assets/approaches/Other Multi-Task Objectives.svg' width='200'/>](#21)  [<img src='./assets/model/DM.svg' width='60'/>](#21)</div>
- **Few-shot image generation based on contrastive meta-learning generative adversarial network**<br>Visual Computer 2022<br>[<a href='https://link.springer.com/article/10.1007/s00371-022-02566-3' target='_blank'>Paper</a>] <br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#24)  [<img src='./assets/approaches/Contrastive Learning.svg' width='175'/>](#24)  [<img src='./assets/model/GAN.svg' width='60'/>](#24)</div>
- **Training GANs with Diffusion**<br>ICLR 2023<br>[<a href='https://openreview.net/forum?id=HZf7UbpWHuA' target='_blank'>Paper</a>] [<a href='https://github.com/Zhendong-Wang/Diffusion-GAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#7)  [<img src='./assets/approaches/Other Multi-Task Objectives.svg' width='200'/>](#7)  [<img src='./assets/model/DM.svg' width='60'/>](#7)</div>
- **Data Limited Image Generation via Knowledge Distillation**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Cui_KD-DLGAN_Data_Limited_Image_Generation_via_Knowledge_Distillation_CVPR_2023_paper.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#17)  [<img src='./assets/approaches/Knowledge Distillation.svg' width='175'/>](#17)  [<img src='./assets/model/GAN.svg' width='60'/>](#17)</div>
- **Adaptive IMLE for Few-shot Pretraining-free Generative Modelling**<br>ICML 2023<br>[<a href='https://proceedings.mlr.press/v202/aghabozorgi23a.html' target='_blank'>Paper</a>] [<a href='https://github.com/mehranagh20/AdaIMLE' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#23)  [<img src='./assets/approaches/Other Multi-Task Objectives.svg' width='200'/>](#23)  [<img src='./assets/model/GAN.svg' width='60'/>](#23)</div>
- **Few-shot Image Generation via Masked Discrimination**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2210.15194' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-2.svg' width='60'/>](#4)  [<img src='./assets/approaches/Masking.svg' width='85'/>](#4)  [<img src='./assets/model/GAN.svg' width='60'/>](#4)</div>
- **Faster and More Data-Efficient Training of Diffusion Models**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2304.12526' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#6)  [<img src='./assets/approaches/Other Multi-Task Objectives.svg' width='200'/>](#6)  [<img src='./assets/model/DM.svg' width='60'/>](#6)</div>
- **Towards high diversity and fidelity image synthesis under limited data**<br>Information Sciences 2023<br>[<a href='https://www.sciencedirect.com/science/article/pii/S0020025523003389' target='_blank'>Paper</a>] [<a href='https://github.com/kobeshegu/ProtoGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#12)  [<img src='./assets/approaches/Prototype Learning.svg' width='150'/>](#12)  [<img src='./assets/model/GAN.svg' width='60'/>](#12)</div>
- **Regularizing Label-Augmented Generative Adversarial Networks Under Limited Data**<br>IEEE Access 2023<br>[<a href='https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=10076457' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#18)  [<img src='./assets/approaches/Regularizer.svg' width='125'/>](#18)  [<img src='./assets/model/GAN.svg' width='60'/>](#18)</div>
- **Dynamically Masked Discriminator for Generative Adversarial Networks**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2306.07716' target='_blank'>Paper</a>] <br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#22)  [<img src='./assets/approaches/Masking.svg' width='85'/>](#22)  [<img src='./assets/model/GAN.svg' width='60'/>](#22)</div>


</details>


## Exploiting Frequency Components
<details open>
  <summary>Click to expand/collapse 4 works</summary>

- **Generative Co-training for Generative Adversarial Networks with Limited Data**<br>AAAI 2022<br>[<a href='https://ojs.aaai.org/index.php/AAAI/article/view/19928' target='_blank'>Paper</a>] [<a href='https://github.com/jxhuang0508/GenCo' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#3)  [<img src='./assets/model/GAN.svg' width='60'/>](#3)</div>
- **Frequency-Aware GAN for High-Fidelity Few-Shot Image Generation**<br>ECCV 2022<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-031-19784-0_1' target='_blank'>Paper</a>] [<a href='https://github.com/kobeshegu/ECCV2022_WaveGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#1)  [<img src='./assets/model/GAN.svg' width='60'/>](#1)</div>
- **Improving GANs with A Dynamic Discriminator**<br>NeurIPS 2022<br>[<a href='https://proceedings.neurips.cc/paper_files/paper/2022/hash/6174c67b136621f3f2e4a6b1d3286f6b-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/genforce/dynamicd' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#0)  [<img src='./assets/model/GAN.svg' width='60'/>](#0)</div>
- **Exploiting Frequency Components for Training GANs under Limited Data**<br>NeurIPS 2022<br>[<a href='https://proceedings.neurips.cc/paper_files/paper/2022/hash/d804cef41362be39d3972c1a71cfc4e9-Abstract-Conference.html' target='_blank'>Paper</a>] [<a href='https://github.com/kobeshegu/FreGAN_NeurIPS2022' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/uGM-1.svg' width='60'/>](#2)  [<img src='./assets/model/GAN.svg' width='60'/>](#2)</div>


</details>


## Meta-learning
<details open>
  <summary>Click to expand/collapse 17 works</summary>

- **Data Augmentaion Generative Adversarial Networks**<br>arXiv 2017<br>[<a href='https://arxiv.org/abs/1711.04340' target='_blank'>Paper</a>] [<a href='https://github.com/AntreasAntoniou/DAGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#2)  [<img src='./assets/approaches/Transformation.svg' width='125'/>](#2)  [<img src='./assets/model/GAN.svg' width='60'/>](#2)</div>
- **Few-shot Generative Modelling with Generative Matching Networks**<br>AISTATS 2018<br>[<a href='https://proceedings.mlr.press/v84/bartunov18a.html' target='_blank'>Paper</a>] <br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#3)  [<img src='./assets/approaches/Optimization.svg' width='125'/>](#3)  [<img src='./assets/model/VAE.svg' width='60'/>](#3)</div>
- **Few-shot Image Generation with Reptile**<br>arXiv 2019<br>[<a href='https://arxiv.org/abs/1901.02199' target='_blank'>Paper</a>] [<a href='https://github.com/LuEE-C/FIGR' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#4)  [<img src='./assets/approaches/Optimization.svg' width='125'/>](#4)  [<img src='./assets/model/GAN.svg' width='60'/>](#4)</div>
- **A domain adaptive few shot generation framework**<br>arXiv 2020<br>[<a href='https://arxiv.org/abs/2001.00576' target='_blank'>Paper</a>] <br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#5)  [<img src='./assets/approaches/Optimization.svg' width='125'/>](#5)  [<img src='./assets/model/GAN.svg' width='60'/>](#5)</div>
- **Matching-based Few-shot Image Generation**<br>ICME 2020<br>[<a href='https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=9102917' target='_blank'>Paper</a>] [<a href='https://github.com/bcmi/MatchingGAN-Few-Shot-Image-Generation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#6)  [<img src='./assets/approaches/Fusion.svg' width='85'/>](#6)  [<img src='./assets/model/GAN.svg' width='60'/>](#6)</div>
- **Fusing-and-Filling GAN for Few-shot Image Generation**<br>ACM-MM 2020<br>[<a href='https://dl.acm.org/doi/10.1145/3394171.3413561' target='_blank'>Paper</a>] [<a href='https://github.com/bcmi/F2GAN-Few-Shot-Image-Generation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#7)  [<img src='./assets/approaches/Fusion.svg' width='85'/>](#7)  [<img src='./assets/model/GAN.svg' width='60'/>](#7)</div>
- **Fusing Local Representations for Few-shot Image Generation**<br>ICCV 2021<br>[<a href='https://openaccess.thecvf.com/content/ICCV2021/html/Gu_LoFGAN_Fusing_Local_Representations_for_Few-Shot_Image_Generation_ICCV_2021_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/edward3862/LoFGAN-pytorch' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#8)  [<img src='./assets/approaches/Fusion.svg' width='85'/>](#8)  [<img src='./assets/model/GAN.svg' width='60'/>](#8)</div>
- **Fast Adaptive Meta-Learning for Few-Shot Image Generation**<br>TMM 2021<br>[<a href='https://ieeexplore.ieee.org/document/9424414' target='_blank'>Paper</a>] [<a href='https://github.com/phaphuang/FAML' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#10)  [<img src='./assets/approaches/Optimization.svg' width='125'/>](#10)  [<img src='./assets/model/GAN.svg' width='60'/>](#10)</div>
- **Frequency-Aware GAN for High-Fidelity Few-Shot Image Generation**<br>ECCV 2022<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-031-19784-0_1' target='_blank'>Paper</a>] [<a href='https://github.com/kobeshegu/ECCV2022_WaveGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#0)  [<img src='./assets/approaches/Fusion.svg' width='85'/>](#0)  [<img src='./assets/model/GAN.svg' width='60'/>](#0)</div>
- **Towards Diverse Few-shot Image Generation with Sample-Specific Delta**<br>ECCV 2022<br>[<a href='https://link.springer.com/chapter/10.1007/978-3-031-19787-1_15' target='_blank'>Paper</a>] [<a href='https://github.com/bcmi/DeltaGAN-Few-Shot-Image-Generation' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#9)  [<img src='./assets/approaches/Transformation.svg' width='125'/>](#9)  [<img src='./assets/model/GAN.svg' width='60'/>](#9)</div>
- **Few-shot image generation based on contrastive meta-learning generative adversarial network**<br>Visual Computer 2022<br>[<a href='https://link.springer.com/article/10.1007/s00371-022-02566-3' target='_blank'>Paper</a>] <br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#1)  [<img src='./assets/approaches/Optimization.svg' width='125'/>](#1)  [<img src='./assets/model/GAN.svg' width='60'/>](#1)</div>
- **Few-shot Image Generation Using Discrete Content Representation**<br>ACM MM 2022<br>[<a href='https://dl.acm.org/doi/abs/10.1145/3503161.3548158' target='_blank'>Paper</a>] <br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#12)  [<img src='./assets/approaches/Transformation.svg' width='125'/>](#12)  [<img src='./assets/model/GAN.svg' width='60'/>](#12)</div>
- **The Euclidean Space is Evil: Hyperbolic Attribute Editing for Few-shot Image Generation**<br>arXiv 2022<br>[<a href='https://arxiv.org/abs/2211.12347' target='_blank'>Paper</a>] <br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#16)  [<img src='./assets/approaches/Transformation.svg' width='125'/>](#16)  [<img src='./assets/model/GAN.svg' width='60'/>](#16)</div>
- **Where is My Spot? Few-shot Image Generation via Latent Subspace Optimization**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2023/html/Zheng_Where_Is_My_Spot_Few-Shot_Image_Generation_via_Latent_Subspace_CVPR_2023_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/chansey0529/LSO' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#13)  [<img src='./assets/approaches/Transformation.svg' width='125'/>](#13)  [<img src='./assets/model/GAN.svg' width='60'/>](#13)</div>
- **Attribute Group Editing for Reliable Few-shot Image Generation**<br>CVPR 2023<br>[<a href='https://openaccess.thecvf.com/content/CVPR2022/html/Ding_Attribute_Group_Editing_for_Reliable_Few-Shot_Image_Generation_CVPR_2022_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/UniBester/AGE' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#14)  [<img src='./assets/approaches/Transformation.svg' width='125'/>](#14)  [<img src='./assets/model/GAN.svg' width='60'/>](#14)</div>
- **Adaptive multi-scale modulation generative adversarial network for few-shot image generation**<br>Applied Intelligence 2023<br>[<a href='https://link.springer.com/article/10.1007/s10489-023-04559-8' target='_blank'>Paper</a>] <br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#11)  [<img src='./assets/approaches/Fusion.svg' width='85'/>](#11)  [<img src='./assets/model/GAN.svg' width='60'/>](#11)</div>
- **Stable Attribute Group Editing for Reliable Few-shot Image Generation**<br>arXiv 2023<br>[<a href='https://arxiv.org/abs/2302.00179' target='_blank'>Paper</a>] [<a href='https://github.com/UniBester/SAGE' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/cGM-2.svg' width='60'/>](#15)  [<img src='./assets/approaches/Transformation.svg' width='125'/>](#15)  [<img src='./assets/model/GAN.svg' width='60'/>](#15)</div>


</details>





## Modeling Internal Patch Distribution
<details open>
  <summary>Click to expand/collapse 8 works</summary>

- **Learning a Generative Model from a Single Natural Image**<br>ICCV 2019<br>[<a href='https://openaccess.thecvf.com/content_ICCV_2019/html/Shaham_SinGAN_Learning_a_Generative_Model_From_a_Single_Natural_Image_ICCV_2019_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/tamarott/SinGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/IGM.svg' width='60'/>](#0)  [<img src='./assets/approaches/Progressive Training.svg' width='175'/>](#0)  [<img src='./assets/model/GAN.svg' width='60'/>](#0)</div>
- **Learning to generate samples from single images and videos**<br>CVPR 2021-W<br>[<a href='https://openaccess.thecvf.com/content/CVPR2021W/LLID/html/Sushko_One-Shot_GAN_Learning_To_Generate_Samples_From_Single_Images_and_CVPRW_2021_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/boschresearch/one-shot-synthesis' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/IGM.svg' width='60'/>](#1)  [<img src='./assets/approaches/Non-Progressive Training.svg' width='200'/>](#1)  [<img src='./assets/model/GAN.svg' width='60'/>](#1)</div>
- **Improved techniques for training single image gans**<br>WACV 2021<br>[<a href='https://openaccess.thecvf.com/content/WACV2021/html/Hinz_Improved_Techniques_for_Training_Single-Image_GANs_WACV_2021_paper.html' target='_blank'>Paper</a>] [<a href='https://github.com/tohinz/ConSinGAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/IGM.svg' width='60'/>](#2)  [<img src='./assets/approaches/Progressive Training.svg' width='175'/>](#2)  [<img src='./assets/model/GAN.svg' width='60'/>](#2)</div>
- **Learning a Diffusion Model from a Single Natural Image**<br>arXiv 2022<br>[<a href='https://arxiv.org/abs/2211.12445' target='_blank'>Paper</a>] [<a href='https://github.com/WeilunWang/SinDiffusion' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/IGM.svg' width='60'/>](#4)  [<img src='./assets/approaches/Progressive Training.svg' width='175'/>](#4)  [<img src='./assets/model/DM.svg' width='60'/>](#4)</div>
- **Learning and Blending the Internal Distributions of Single Images by Spatial Image-Identity Conditioning**<br>arXiv 2022<br>[<a href='https://arxiv.org/abs/2212.01589' target='_blank'>Paper</a>] <br>[<img src='./assets/task/IGM.svg' width='60'/>](#5)  [<img src='./assets/approaches/Progressive Training.svg' width='175'/>](#5)  [<img src='./assets/model/GAN.svg' width='60'/>](#5)</div>
- **Training Diffusion Models on a Single Image or Video**<br>ICML 2023<br>[<a href='https://proceedings.mlr.press/v202/nikankin23a.html' target='_blank'>Paper</a>] [<a href='https://github.com/yanivnik/sinfusion-code' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/IGM.svg' width='60'/>](#6)  [<img src='./assets/approaches/Non-Progressive Training.svg' width='200'/>](#6)  [<img src='./assets/model/DM.svg' width='60'/>](#6)</div>
- **A Single Image Denoising Diffusion Model**<br>ICML 2023<br>[<a href='https://proceedings.mlr.press/v202/kulikov23a.html' target='_blank'>Paper</a>] [<a href='https://github.com/fallenshock/SinDDM' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/IGM.svg' width='60'/>](#7)  [<img src='./assets/approaches/Progressive Training.svg' width='175'/>](#7)  [<img src='./assets/model/DM.svg' width='60'/>](#7)</div>
- **Diverse Attribute Transfer for Few-Shot Image Synthesis**<br>VISIGRAPP 2023<br>[<a href='https://arxiv.org/abs/2302.14533' target='_blank'>Paper</a>] [<a href='https://github.com/rajiv1990/Data-Efficient-GAN-DEff-GAN' target='_blank'>Official Code</a>]<br>[<img src='./assets/task/IGM.svg' width='60'/>](#3)  [<img src='./assets/approaches/Progressive Training.svg' width='175'/>](#3)  [<img src='./assets/model/GAN.svg' width='60'/>](#3)</div>


</details>



## Citation
<a name="bibtex"></a>
If you find this repo useful, please cite our paper
<pre><code class="language-bib" style="font-size: 0.9rem;" id="citation">@article{abdollahzadeh2023survey,
      title={A Survey on Generative Modeling with Limited Data, Few Shots, and Zero Shot}, 
      author={Milad Abdollahzadeh and Touba Malekzadeh and Christopher T. H. Teo and Keshigeyan Chandrasegaran and Guimeng Liu and Ngai-Man Cheung},
      year={2023},
      eprint={2307.14397},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}
</code></pre>




