# Bocker

Docker implemented in around 100 lines of bash.

-   [Prerequisites](#prerequisites)
-   [Example Usage](#example-usage)
-   [Functionality: Currently Implemented](#functionality-currently-implemented)
-   [Functionality: Not Yet Implemented](#functionality-not-yet-implemented)
-   [License](#license)

## Prerequisites

The following packages are needed to run bocker.

-   btrfs-progs
-   curl
-   iproute2
-   iptables
-   libcgroup-tools
-   util-linux >= 2.25.2
-   coreutils >= 7.5

Because most distributions do not ship a new enough version of util-linux you will probably need to grab the sources from [here](https://www.kernel.org/pub/linux/utils/util-linux/v2.25/) and compile it yourself.

Additionally your system will need to be configured with the following :-

-   A btrfs filesystem mounted under `/var/bocker`
-   A network bridge called `bridge0` and an IP of 10.0.0.1/24
-   IP forwarding enabled in `/proc/sys/net/ipv4/ip_forward`
-   A firewall routing traffic from `bridge0` to a physical interface.

For ease of use a Vagrantfile is included which will build the needed environment.

Even if you meet the above prerequisites you probably still want to **run bocker in a virtual machine**. Bocker runs as root and among other things needs to make changes to your network interfaces, routing table, and firewall rules. **I can make no guarantees that it won't trash your system**.

## Example Usage

```
$ bocker pull centos 7
######################################################################## 100.0%
######################################################################## 100.0%
######################################################################## 100.0%
Created: img_42150

$ bocker images
IMAGE_ID        SOURCE
img_42150       centos:7

$ bocker run img_42150 cat /etc/centos-release
CentOS Linux release 7.1.1503 (Core)

$ bocker ps
CONTAINER_ID       COMMAND
ps_42045           cat /etc/centos-release

$ bocker logs ps_42045
CentOS Linux release 7.1.1503 (Core)

$ bocker rm ps_42045
Removed: ps_42045

$ bocker run img_42150 which wget
which: no wget in (/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/root/bin)

$ bocker run img_42150 yum install -y wget
Installing : wget-1.14-10.el7_0.1.x86_64                                  1/1
Verifying  : wget-1.14-10.el7_0.1.x86_64                                  1/1
Installed  : wget.x86_64 0:1.14-10.el7_0.1
Complete!

$ bocker ps
CONTAINER_ID       COMMAND
ps_42018           yum install -y wget
ps_42182           which wget

$ bocker commit ps_42018 img_42150
Removed: img_42150
Created: img_42150

$ bocker run img_42150 which wget
/usr/bin/wget

$ bocker run img_42150 cat /proc/1/cgroup
...
4:memory:/ps_42152
3:cpuacct,cpu:/ps_42152

$ cat /sys/fs/cgroup/cpu/ps_42152/cpu.shares
512

$ cat /sys/fs/cgroup/memory/ps_42152/memory.limit_in_bytes
512000000

$ BOCKER_CPU_SHARE=1024 \
	BOCKER_MEM_LIMIT=1024 \
	bocker run img_42150 cat /proc/1/cgroup
...
4:memory:/ps_42188
3:cpuacct,cpu:/ps_42188

$ cat /sys/fs/cgroup/cpu/ps_42188/cpu.shares
1024

$ cat /sys/fs/cgroup/memory/ps_42188/memory.limit_in_bytes
1024000000
```

## Functionality: Currently Implemented

-   `docker build` †
-   `docker pull`
-   `docker images`
-   `docker ps`
-   `docker run`
-   `docker exec`
-   `docker logs`
-   `docker commit`
-   `docker rm` / `docker rmi`
-   Networking
-   Quota Support / CGroups

† `bocker init` provides a very limited implementation of `docker build`

## Functionality: Not Yet Implemented

-   Data Volume Containers
-   Data Volumes
-   Port Forwarding

## License

This script is a modified version of docker implementation by Peter Wilmott.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
