﻿/*
* Copyright (c) 2006-2007 Erin Catto http://www.gphysics.com
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

package Box2D.Dynamics.Contacts
{
	
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Dynamics.*;
	
	/**
	 * @private
	 */
	public class b2PolygonContact extends b2Contact
	{
		static public function Create(allocator:*):b2Contact
		{
			//void* mem = allocator->Allocate(sizeof(b2PolyContact));
			return new b2PolygonContact();
		}
		
		static public function Destroy(contact:b2Contact, allocator:*):void
		{
			//((b2PolyContact*)contact)->~b2PolyContact();
			//allocator->Free(contact, sizeof(b2PolyContact));
		}
		
		public override function Reset(fixtureA:b2Fixture = null, fixtureB:b2Fixture = null):void
		{
			super.Reset(fixtureA, fixtureB);
			//b2Settings.b2Assert(m_shape1.m_type == b2Shape.e_polygonShape);
			//b2Settings.b2Assert(m_shape2.m_type == b2Shape.e_polygonShape);
		}
		
		//~b2PolyContact() {}
		
		public override function Evaluate():void
		{
			var bA:b2Body = m_fixtureA.GetBody();
			var bB:b2Body = m_fixtureB.GetBody();
			
			b2Collision.CollidePolygons(m_manifold,
				m_fixtureA.GetShape() as b2PolygonShape, bA.m_xf,
				m_fixtureB.GetShape() as b2PolygonShape, bB.m_xf);
		}
	};
	
}
