---
description: Learn how to run Superlinked in production.
icon: bullseye-arrow
---

# Overview

The [Superlinked Server](https://pypi.org/project/superlinked-server/) allows you to leverage the power of Superlinked in deployable projects. With a single command, you can run a Superlinked-powered app instance that creates REST endpoints and connects to external Vector Databases. This makes it an ideal solution for those seeking an easy-to-deploy environment for their Superlinked projects.

To get started, check out the [Superlinked Server Setup](setup/index.md).

If your are interested in learning more about running at scale, [Book a demo](https://links.superlinked.com/sl-docs-readme-form) for an early access to our managed cloud.

### Supported VDBs

We have started partnering with vector database providers to allow you to use Superlinked with your VDB of choice. If you are unsure, which VDB to chose, check-out our [Vector DB Comparison](https://superlinked.com/vector-db-comparison/).

- [Redis](vdbs/redis.md)
- [MongoDB](vdbs/mongodb.md)
- [Qdrant](vdbs/qdrant.md)

Missing your favorite VDB? [Tell us which vector database we should support next!](https://github.com/superlinked/superlinked/discussions/41)