---
description: >-
icon: hand-wave
---

# Welcome

Superlinked is a Python framework for AI Engineers building <b>high-performance search & recommendation applications</b> that combine <b>structured</b> and <b>unstructured</b> data.

- **WHY**: Improve your vector search relevance by encoding metadata togehter with your unstructured data into vectors. Read more at [Why Superlinked](getting-started/why-superlinked.md)
- **WHAT**: A framework and a self-hostable REST API server that connects your data, vector database and backend services.
- **HOW**: Construct custom data & query embedding models from pre-trained encoders from `sentence-transformers`, `open-clip` and custom encoders for numbers, timestamps and categorical data. See <b>[concepts](concepts/overview.md)</b> and <b>[use cases](use-cases/overview.md)</b> for examples.

If you like what we do, give us a [star](https://github.com/superlinked/superlinked)! ⭐

![Superlinked framework diagram](.gitbook/assets/superlinked_diagram.png)


### Discover Superlinked

<table data-view="cards">
<thead>
<tr><th></th><th></th><th data-type="content-ref"></th><th data-hidden data-card-cover data-type="files"></th><th data-hidden data-card-target data-type="content-ref">
</th></tr>
</thead>
<tbody>
    <tr>
        <td><strong>Getting Started</strong></td>
        <td>Begin your journey with Superlinked by setting up and understanding the basics.</td>
        <td></td>
        <td><a href=".gitbook/assets/getting-started-thumbnails/getting started.png">getting started.png</a></td>
        <td><a href="getting-started/installation.md">link</a></td>
    </tr>
    <tr>
        <td><strong>Concepts</strong></td>
        <td>Explore the core ideas and principles behind Superlinked's functionality.</td>
        <td></td>
        <td><a href=".gitbook/assets/getting-started-thumbnails/concept.png">concepts.png</a></td>
        <td><a href="concepts/overview.md">link</a></td>
    </tr>
    <tr>
        <td><strong>Use Cases</strong></td>
        <td>Learn how Superlinked can be applied to solve real-world problems.</td>
        <td></td>
        <td><a href=".gitbook/assets/getting-started-thumbnails/use cases.png">use-cases.png</a></td>
        <td><a href="use-cases/overview.md">link</a></td>
    </tr>
    <tr>
        <td><strong>Reference</strong></td>
        <td>Access detailed documentation for Superlinked's components.</td>
        <td></td>
        <td><a href=".gitbook/assets/getting-started-thumbnails/reference.png">reference.png</a></td>
        <td><a href="reference/overview.md">link</a></td>
    </tr>
    <tr>
        <td><strong>Changelog</strong></td>
        <td>View the changelog for Superlinked.</td>
        <td></td>
        <td><a href=".gitbook/assets/getting-started-thumbnails/changelog.png">changelog.png</a></td>
        <td><a href="reference/changelog.md">link</a></td>
    </tr>
    
</tbody>
</table>


### Resources

<table data-view="cards">
<thead>
<tr><th></th><th></th><th data-type="content-ref"></th><th data-hidden data-card-cover data-type="files"></th><th data-hidden data-card-target data-type="content-ref">
</th></tr>
</thead>
<tbody>
    <tr>
        <td><strong>VectorHub</strong></td>
        <td>free and open-sourced learning hub for people interested in adding vector retrieval to their ML stack.</td>
        <td></td>
        <td><a href=".gitbook/assets/resources-thumbnails/vectorhub.png">vectorhub.png</a></td>
        <td><a href="https://superlinked.com/vectorhub" target="_blank">link</a></td>
    </tr>
    <tr>
        <td><strong>Vector DB Comparison</strong></td>
        <td>Open-source collaborative comparison of vector databases by Superlinked</td>
        <td></td>
        <td><a href=".gitbook/assets/resources-thumbnails/vdb table.png">vector-db-comparison.png</a></td>
        <td><a href="https://superlinked.com/vector-db-comparison" target="_blank">link</a></td>
    </tr>
    
</tbody>
</table>
