
# Reusable Django Applications and Packages

Welcome to our collection of reusable Django applications and packages. Our goal is to provide you with high-quality, easy-to-use components that you can integrate into your own projects.

## Applications

- #### Custom User Model
Our first package is a custom user model that allows you to easily implement user authentication in your Django projects. With this package, you can create accounts, login, and recover lost passwords. It also implements an abstract user model, so you can customize it to your needs.

- #### Real-time Chat Application
Our second package is a real-time chat application that allows your users to communicate with each other in real-time. It is fully integrated with Django and can be easily added to your existing projects. This package provides a simple and user-friendly interface for chatting and includes features such as online/offline status, typing indicators, and message history.

## Installation and Removal

To install these packages, simply run the following command in your project environment:

```bash
python3 -m pip install /path/to_file/django-user-auth-0.1.tar.gz
python3 -m pip install /path/to_file/django-chat-app-0.1.tar.gz

```

Replace with the path to the zipped file in the dist folder of each application.

#### To uninstall  

```bash
python3 -m pip uninstall /path/to_file/django-user-auth-0.1.tar.gz
python3 -m pip uninstall /path/to_file/django-chat-app-0.1.tar.gz

```

## Usage

Please refer to the documentation in the "docs" directory for detailed instructions on how to use these packages.
## Contributing

We are always looking for ways to improve our packages, so if you have any suggestions or find any bugs, please open an issue or submit a pull request.
## Support

If you need any help or have any questions, please don't hesitate to contact me.

Thank you for choosing our reusable Django applications and packages. We hope they will be a valuable addition to your projects.
