<?php
/**
 * Created by PhpStorm.
 * User: alikaviani
 * Date: 2019-04-20
 * Time: 13:56
 */

namespace Subzerobo\ElasticApmPhpAgent\ActionWrappers;

use Subzerobo\ElasticApmPhpAgent\Wrappers\SpanContextData;

class APMGeneralActionWrapper extends APMHandlerAbstract
{
    const SPAN_TYPE = "general";

    public function handleBefore($object, string $actionName, array $actionData = [])
    {
        parent::handleBefore($object, $actionName, $actionData); // TODO: Change the autogenerated stub
        if ($this->apmAgent->isActive()) {
            $txName = $this->apmAgent->getCurrentTransactionName();
            $tx     = $this->apmAgent->getTransactionEvent($txName);

            $this->span = $tx->startSpan($actionName , $actionData['type'] ?? self::SPAN_TYPE);
            $this->span->setSubType("http");

        }
    }

    public function handleAfter($object, string $actionName, array $actionData = [])
    {
        parent::handleAfter($object, $actionName, $actionData); // TODO: Change the autogenerated stub

        if ($this->apmAgent->isActive()) {

            $spanContextData = new SpanContextData();
            $tags = $actionData;
            $spanContextData->setTags($tags);
            $this->span->setContextFromContextData($spanContextData);
            $this->span->stop();
        }
    }


}