# React Styleguidist react-native example style guide

![](https://media.giphy.com/media/3ohs4v5loJ50dKw9FK/giphy.gif)

How to start locally:

```
git clone https://github.com/styleguidist/react-styleguidist.git
cd react-styleguidist/examples/react-native
npm install
```

Run Styleguidist

```
npx styleguidist server
```

(Optional) Run the react-native app via simulator (or [Expo](https://expo.io/learn))

```
npm run start
```

Then open [http://localhost:6060](http://localhost:6060) in your browser.

## Add Styleguidist to an existing react-native project

A collection of dev-dependencies related to webpack are required to get `react-native` and `react-styleguidist` running on a browser. `module:metro-react-native-babel-preset` reflects the bundle server that normally serves to react-native apps to the simulators and/or devices.

```
npm install --save-dev @babel/core @babel/plugin-proposal-class-properties @babel/plugin-proposal-object-rest-spread @babel/polyfill @babel/preset-env babel-loader babel-plugin-react-native-web file-loader metro-react-native-babel-preset react-art react-dom react-native-web react-styleguidist webpack
```

Add and configure `styleguide.config.js` to the root of your `react-native` project.

## Common Caveats

[react-native-web](https://github.com/necolas/react-native-web) does not support everything, components requiring DeviceInfo is a common breaking point for example. Configuring components or selections in your `styleguide.config.js` to only select ui components is recommended. A good rule of thumb is to expect an approximate visual representation with code examples and props documentation.

[react-native-vector-icons](https://oblador.github.io/react-native-vector-icons/) (or any other dependency using external assets) can be solved by adding a custom template to `styleguide.config.js`

# Generated by Expo

This project was bootstrapped with [Expo](https://expo.io/).

The most recent version of this guide is available [here](https://expo.io/learn).
