﻿// This file is part of BowPad.
//
// Copyright (C) 2014-2018, 2020-2023 - Stefan Kueng
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// See <http://www.gnu.org/licenses/> for a copy of the full license text
//
#include "stdafx.h"
#include "BasicScriptObject.h"
#include "UnicodeUtils.h"
#include "ClipboardHelper.h"
#include "OnOutOfScope.h"
#include "StringUtils.h"
#include "version.h"
#include "../../ext/sktoolslib/PathUtils.h"
#include "../Commands/CommandHandler.h"

static auto CF_HTML = RegisterClipboardFormat(L"HTML Format");

static const ScintillaCmd g_scintillaCmd[] = {
    // SCI_GETTEXT
    // SCI_SETTEXT
    // SCI_GETSTYLEDTEXT
    // SCI_ADDSTYLEDTEXT
    // SCI_POINTXFROMPOSITION
    // SCI_POINTYFROMPOSITION
    // SCI_SETSTYLINGEX
    // SCI_SETREPRESENTATION
    // SCI_GETREPRESENTATION
    // SCI_CLEARREPRESENTATION
    // SCI_SETCONTROLCHARSYMBOL
    // SCI_GETCONTROLCHARSYMBOL
    // SCI_SETMARGINLEFT
    // SCI_GETMARGINLEFT
    // SCI_SETMARGINRIGHT
    // SCI_GETMARGINRIGHT
    // SCI_MARGINSETSTYLES
    // SCI_MARGINGETSTYLES
    // SCI_ANNOTATIONSETSTYLES
    // SCI_ANNOTATIONGETSTYLES
    // SCI_MARKERDEFINEPIXMAP
    // SCI_MARKERDEFINERGBAIMAGE
    // SCI_REGISTERIMAGE
    // SCI_REGISTERRGBAIMAGE
    // SCI_CLEARREGISTEREDIMAGES
    // SCI_SETLEXERLANGUAGE
    // SCI_GETLEXERLANGUAGE
    // SCI_LOADLEXERLIBRARY
    // SCI_PROPERTYNAMES
    // SCI_PROPERTYTYPE
    // SCI_DESCRIBEPROPERTY
    // SCI_SETPROPERTY
    // SCI_GETPROPERTY
    // SCI_GETPROPERTYEXPANDED
    // SCI_GETPROPERTYINT
    // SCI_DESCRIBEKEYWORDSETS
    // SCI_GETSUBSTYLEBASES
    // SCI_DISTANCETOSECONDARYSTYLES
    // SCI_ALLOCATESUBSTYLES
    // SCI_FREESUBSTYLES
    // SCI_GETSUBSTYLESSTART
    // SCI_GETSUBSTYLESLENGTH
    // SCI_GETSTYLEFROMSUBSTYLE
    // SCI_GETPRIMARYSTYLEFROMSTYLE
    // SCI_SETIDENTIFIERS
    {L"SciSetSavePoint", SCI_SETSAVEPOINT, SCI_SETSAVEPOINT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciGetLine", SCI_GETLINE, SCI_GETLINE, VT_BSTR, VT_INT, VT_NULL},
    {L"SciReplaceSel", SCI_REPLACESEL, SCI_REPLACESEL, VT_NULL, VT_BSTR, VT_NULL},
    {L"SciReadOnly", SCI_SETREADONLY, SCI_GETREADONLY, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciAllocate", SCI_ALLOCATE, SCI_ALLOCATE, VT_NULL, VT_INT, VT_NULL},
    {L"SciAddText", SCI_ADDTEXT, SCI_ADDTEXT, VT_NULL, VT_INT, VT_BSTR},
    {L"SciAppendText", SCI_APPENDTEXT, SCI_APPENDTEXT, VT_NULL, VT_INT, VT_BSTR},
    {L"SciInsertText", SCI_INSERTTEXT, SCI_INSERTTEXT, VT_NULL, VT_INT, VT_BSTR},
    {L"SciClearAll", SCI_CLEARALL, SCI_CLEARALL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDeleteRange", SCI_DELETERANGE, SCI_DELETERANGE, VT_NULL, VT_INT, VT_INT},
    {L"SciClearDocumentStyle", SCI_CLEARDOCUMENTSTYLE, SCI_CLEARDOCUMENTSTYLE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciGetStyleAt", SCI_GETSTYLEAT, SCI_GETSTYLEAT, VT_INT, VT_INT, VT_NULL},
    {L"SciReleaseAllExtendedStyles", SCI_RELEASEALLEXTENDEDSTYLES, SCI_RELEASEALLEXTENDEDSTYLES, VT_NULL, VT_NULL, VT_NULL},
    {L"SciAllocateExtendedStyles", SCI_ALLOCATEEXTENDEDSTYLES, SCI_ALLOCATEEXTENDEDSTYLES, VT_NULL, VT_INT, VT_NULL},
    {L"SciSearchAnchor", SCI_SEARCHANCHOR, SCI_SEARCHANCHOR, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSearchNext", SCI_SEARCHNEXT, SCI_SEARCHNEXT, VT_INT, VT_INT, VT_BSTR},
    {L"SciSearchPrev", SCI_SEARCHPREV, SCI_SEARCHPREV, VT_INT, VT_INT, VT_BSTR},
    {L"SciSetTargetStart", SCI_SETTARGETSTART, SCI_SETTARGETSTART, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetTargetStart", SCI_GETTARGETSTART, SCI_GETTARGETSTART, VT_INT, VT_NULL, VT_NULL},
    {L"SciTargetStart", SCI_SETTARGETSTART, SCI_GETTARGETSTART, VT_INT, VT_INT, VT_NULL},
    {L"SciSetTargetEnd", SCI_SETTARGETEND, SCI_SETTARGETEND, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetTargetEnd", SCI_GETTARGETEND, SCI_GETTARGETEND, VT_INT, VT_NULL, VT_NULL},
    {L"SciTargetEnd", SCI_SETTARGETEND, SCI_GETTARGETEND, VT_INT, VT_INT, VT_NULL},
    {L"SciTargetFromSelection", SCI_TARGETFROMSELECTION, SCI_TARGETFROMSELECTION, VT_NULL, VT_NULL, VT_NULL},
    {L"SciTargetWholeDocument", SCI_TARGETWHOLEDOCUMENT, SCI_TARGETWHOLEDOCUMENT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSetSearchFlags", SCI_SETSEARCHFLAGS, SCI_SETSEARCHFLAGS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetSearchFlags", SCI_GETSEARCHFLAGS, SCI_GETSEARCHFLAGS, VT_INT, VT_NULL, VT_NULL},
    {L"SciSearchFlags", SCI_SETSEARCHFLAGS, SCI_GETSEARCHFLAGS, VT_INT, VT_INT, VT_NULL},
    {L"SciSearchInTarget", SCI_SEARCHINTARGET, SCI_SEARCHINTARGET, VT_INT, VT_INT, VT_BSTR},
    {L"SciReplaceTarget", SCI_REPLACETARGET, SCI_REPLACETARGET, VT_INT, VT_INT, VT_BSTR},
    {L"SciReplaceTargetRe", SCI_REPLACETARGETRE, SCI_REPLACETARGETRE, VT_INT, VT_INT, VT_BSTR},
    {L"SciGetTag", SCI_GETTAG, SCI_GETTAG, VT_BSTR, VT_INT, VT_NULL},
    {L"SciSetOvertype", SCI_SETOVERTYPE, SCI_SETOVERTYPE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetOvertype", SCI_GETOVERTYPE, SCI_GETOVERTYPE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciOvertype", SCI_SETOVERTYPE, SCI_GETOVERTYPE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciCut", SCI_CUT, SCI_CUT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCopy", SCI_COPY, SCI_COPY, VT_NULL, VT_NULL, VT_NULL},
    {L"SciPaste", SCI_PASTE, SCI_PASTE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciClear", SCI_CLEAR, SCI_CLEAR, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCanPaste", SCI_CANPASTE, SCI_CANPASTE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciCopyRange", SCI_COPYRANGE, SCI_COPYRANGE, VT_NULL, VT_INT, VT_INT},
    {L"SciCopyText", SCI_COPYTEXT, SCI_COPYTEXT, VT_NULL, VT_INT, VT_BSTR},
    {L"SciCopyAllowLine", SCI_COPYALLOWLINE, SCI_COPYALLOWLINE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSetPasteConvertEndings", SCI_SETPASTECONVERTENDINGS, SCI_SETPASTECONVERTENDINGS, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetPasteConvertEndings", SCI_GETPASTECONVERTENDINGS, SCI_GETPASTECONVERTENDINGS, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciPasteConvertEndings", SCI_SETPASTECONVERTENDINGS, SCI_GETPASTECONVERTENDINGS, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetStatus", SCI_SETSTATUS, SCI_SETSTATUS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetStatus", SCI_GETSTATUS, SCI_GETSTATUS, VT_INT, VT_NULL, VT_NULL},
    {L"SciStatus", SCI_SETSTATUS, SCI_GETSTATUS, VT_INT, VT_INT, VT_NULL},
    {L"SciUndo", SCI_UNDO, SCI_UNDO, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCanUndo", SCI_CANUNDO, SCI_CANUNDO, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciEmptyUndoBuffer", SCI_EMPTYUNDOBUFFER, SCI_EMPTYUNDOBUFFER, VT_NULL, VT_NULL, VT_NULL},
    {L"SciRedo", SCI_REDO, SCI_REDO, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCanRedo", SCI_CANREDO, SCI_CANREDO, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSetUndoCollection", SCI_SETUNDOCOLLECTION, SCI_SETUNDOCOLLECTION, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetUndoCollection", SCI_GETUNDOCOLLECTION, SCI_GETUNDOCOLLECTION, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciUndoCollection", SCI_SETUNDOCOLLECTION, SCI_GETUNDOCOLLECTION, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciBeginUndoAction", SCI_BEGINUNDOACTION, SCI_BEGINUNDOACTION, VT_NULL, VT_NULL, VT_NULL},
    {L"SciEndUndoAction", SCI_ENDUNDOACTION, SCI_ENDUNDOACTION, VT_NULL, VT_NULL, VT_NULL},
    {L"SciAddUndoAction", SCI_ADDUNDOACTION, SCI_ADDUNDOACTION, VT_NULL, VT_INT, VT_INT},
    {L"SciGetTextLength", SCI_GETTEXTLENGTH, SCI_GETTEXTLENGTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciTextLength", SCI_GETTEXTLENGTH, SCI_GETTEXTLENGTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciGetLength", SCI_GETLENGTH, SCI_GETLENGTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciLength", SCI_GETLENGTH, SCI_GETLENGTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciGetLineCount", SCI_GETLINECOUNT, SCI_GETLINECOUNT, VT_INT, VT_NULL, VT_NULL},
    {L"SciLineCount", SCI_GETLINECOUNT, SCI_GETLINECOUNT, VT_INT, VT_NULL, VT_NULL},
    {L"SciSetFirstVisibleLine", SCI_SETFIRSTVISIBLELINE, SCI_SETFIRSTVISIBLELINE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetFirstVisibleLine", SCI_GETFIRSTVISIBLELINE, SCI_GETFIRSTVISIBLELINE, VT_INT, VT_NULL, VT_NULL},
    {L"SciFirstVisibleLine", SCI_SETFIRSTVISIBLELINE, SCI_GETFIRSTVISIBLELINE, VT_INT, VT_INT, VT_NULL},
    {L"SciLinesOnScreen", SCI_LINESONSCREEN, SCI_LINESONSCREEN, VT_INT, VT_NULL, VT_NULL},
    {L"SciGetModify", SCI_GETMODIFY, SCI_GETMODIFY, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciModified", SCI_GETMODIFY, SCI_GETMODIFY, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSetSel", SCI_SETSEL, SCI_SETSEL, VT_NULL, VT_INT, VT_INT},
    {L"SciGotoPos", SCI_GOTOPOS, SCI_GOTOPOS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGotoLine", SCI_GOTOLINE, SCI_GOTOLINE, VT_NULL, VT_INT, VT_NULL},
    {L"SciSetCurrentPos", SCI_SETCURRENTPOS, SCI_SETCURRENTPOS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCurrentPos", SCI_GETCURRENTPOS, SCI_GETCURRENTPOS, VT_INT, VT_NULL, VT_NULL},
    {L"SciCurrentPos", SCI_SETCURRENTPOS, SCI_GETCURRENTPOS, VT_INT, VT_INT, VT_NULL},
    {L"SciSetAnchor", SCI_SETANCHOR, SCI_SETANCHOR, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetAnchor", SCI_GETANCHOR, SCI_GETANCHOR, VT_INT, VT_NULL, VT_NULL},
    {L"SciAnchor", SCI_SETANCHOR, SCI_GETANCHOR, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionStart", SCI_SETSELECTIONSTART, SCI_SETSELECTIONSTART, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetSelectionStart", SCI_GETSELECTIONSTART, SCI_GETSELECTIONSTART, VT_INT, VT_NULL, VT_NULL},
    {L"SciSelectionStart", SCI_SETSELECTIONSTART, SCI_GETSELECTIONSTART, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionEnd", SCI_SETSELECTIONEND, SCI_SETSELECTIONEND, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetSelectionEnd", SCI_GETSELECTIONEND, SCI_GETSELECTIONEND, VT_INT, VT_NULL, VT_NULL},
    {L"SciSelectionEnd", SCI_SETSELECTIONEND, SCI_GETSELECTIONEND, VT_INT, VT_INT, VT_NULL},
    {L"SciSetEmptySelection", SCI_SETEMPTYSELECTION, SCI_SETEMPTYSELECTION, VT_NULL, VT_INT, VT_NULL},
    {L"SciSelectAll", SCI_SELECTALL, SCI_SELECTALL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineFromPosition", SCI_LINEFROMPOSITION, SCI_LINEFROMPOSITION, VT_INT, VT_INT, VT_NULL},
    {L"SciPositionFromLine", SCI_POSITIONFROMLINE, SCI_POSITIONFROMLINE, VT_INT, VT_INT, VT_NULL},
    {L"SciGetLineEndPosition", SCI_GETLINEENDPOSITION, SCI_GETLINEENDPOSITION, VT_INT, VT_INT, VT_NULL},
    {L"SciLineLength", SCI_LINELENGTH, SCI_LINELENGTH, VT_INT, VT_INT, VT_NULL},
    {L"SciGetColumn", SCI_GETCOLUMN, SCI_GETCOLUMN, VT_INT, VT_INT, VT_NULL},
    {L"SciFindColumn", SCI_FINDCOLUMN, SCI_FINDCOLUMN, VT_INT, VT_INT, VT_INT},
    {L"SciPositionFromPoint", SCI_POSITIONFROMPOINT, SCI_POSITIONFROMPOINT, VT_INT, VT_INT, VT_INT},
    {L"SciPositionFromPointClose", SCI_POSITIONFROMPOINTCLOSE, SCI_POSITIONFROMPOINTCLOSE, VT_INT, VT_INT, VT_INT},
    {L"SciCharPositionFromPoint", SCI_CHARPOSITIONFROMPOINT, SCI_CHARPOSITIONFROMPOINT, VT_INT, VT_INT, VT_INT},
    {L"SciCharPositionFromPointClose", SCI_CHARPOSITIONFROMPOINTCLOSE, SCI_CHARPOSITIONFROMPOINTCLOSE, VT_INT, VT_INT, VT_INT},
    {L"SciHideSelection", SCI_HIDESELECTION, SCI_HIDESELECTION, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetSelText", SCI_GETSELTEXT, SCI_GETSELTEXT, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciSelectedText", SCI_GETSELTEXT, SCI_GETSELTEXT, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciSelText", SCI_GETSELTEXT, SCI_GETSELTEXT, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciGetCurLine", SCI_GETCURLINE, SCI_GETCURLINE, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciCurLine", SCI_GETCURLINE, SCI_GETCURLINE, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciCurrentLine", SCI_GETCURLINE, SCI_GETCURLINE, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciSelectionIsRectangle", SCI_SELECTIONISRECTANGLE, SCI_SELECTIONISRECTANGLE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSetSelectionMode", SCI_SETSELECTIONMODE, SCI_SETSELECTIONMODE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetSelectionMode", SCI_GETSELECTIONMODE, SCI_GETSELECTIONMODE, VT_INT, VT_NULL, VT_NULL},
    {L"SciSelectionMode", SCI_SETSELECTIONMODE, SCI_GETSELECTIONMODE, VT_INT, VT_INT, VT_NULL},
    {L"SciGetLineSelStartPosition", SCI_GETLINESELSTARTPOSITION, SCI_GETLINESELSTARTPOSITION, VT_INT, VT_INT, VT_NULL},
    {L"SciGetLineSelEndPosition", SCI_GETLINESELENDPOSITION, SCI_GETLINESELENDPOSITION, VT_INT, VT_INT, VT_NULL},
    {L"SciMoveCaretInsideView", SCI_MOVECARETINSIDEVIEW, SCI_MOVECARETINSIDEVIEW, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordEndPosition", SCI_WORDENDPOSITION, SCI_WORDENDPOSITION, VT_NULL, VT_INT, VT_BOOL},
    {L"SciWordStartPosition", SCI_WORDSTARTPOSITION, SCI_WORDSTARTPOSITION, VT_NULL, VT_INT, VT_BOOL},
    {L"SciIsRangeWord", SCI_ISRANGEWORD, SCI_ISRANGEWORD, VT_BOOL, VT_INT, VT_INT},
    {L"SciPositionBefore", SCI_POSITIONBEFORE, SCI_POSITIONBEFORE, VT_INT, VT_INT, VT_NULL},
    {L"SciPositionAfter", SCI_POSITIONAFTER, SCI_POSITIONAFTER, VT_INT, VT_INT, VT_NULL},
    {L"SciPositionRelative", SCI_POSITIONRELATIVE, SCI_POSITIONRELATIVE, VT_INT, VT_INT, VT_INT},
    {L"SciCountCharacters", SCI_COUNTCHARACTERS, SCI_COUNTCHARACTERS, VT_INT, VT_INT, VT_INT},
    {L"SciTextWidth", SCI_TEXTWIDTH, SCI_TEXTWIDTH, VT_INT, VT_INT, VT_BSTR},
    {L"SciTextHeight", SCI_TEXTHEIGHT, SCI_TEXTHEIGHT, VT_INT, VT_INT, VT_NULL},
    {L"SciChooseCaretX", SCI_CHOOSECARETX, SCI_CHOOSECARETX, VT_NULL, VT_NULL, VT_NULL},
    {L"SciMoveSelectedLinesUp", SCI_MOVESELECTEDLINESUP, SCI_MOVESELECTEDLINESUP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciMoveSelectedLinesDown", SCI_MOVESELECTEDLINESDOWN, SCI_MOVESELECTEDLINESDOWN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSetMouseSelectionRectangularSwitch", SCI_SETMOUSESELECTIONRECTANGULARSWITCH, SCI_SETMOUSESELECTIONRECTANGULARSWITCH, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetMouseSelectionRectangularSwitch", SCI_GETMOUSESELECTIONRECTANGULARSWITCH, SCI_GETMOUSESELECTIONRECTANGULARSWITCH, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciMouseSelectionRectangularSwitch", SCI_SETMOUSESELECTIONRECTANGULARSWITCH, SCI_GETMOUSESELECTIONRECTANGULARSWITCH, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetMultipleSelection", SCI_SETMULTIPLESELECTION, SCI_SETMULTIPLESELECTION, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetMultipleSelection", SCI_GETMULTIPLESELECTION, SCI_GETMULTIPLESELECTION, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciMultipleSelection", SCI_SETMULTIPLESELECTION, SCI_GETMULTIPLESELECTION, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetAdditionalSelectionTyping", SCI_SETADDITIONALSELECTIONTYPING, SCI_SETADDITIONALSELECTIONTYPING, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetAdditionalSelectionTyping", SCI_GETADDITIONALSELECTIONTYPING, SCI_GETADDITIONALSELECTIONTYPING, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAdditionalSelectionTyping", SCI_SETADDITIONALSELECTIONTYPING, SCI_GETADDITIONALSELECTIONTYPING, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetMultiPaste", SCI_SETMULTIPASTE, SCI_SETMULTIPASTE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetMultiPaste", SCI_GETMULTIPASTE, SCI_GETMULTIPASTE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciMultiPaste", SCI_SETMULTIPASTE, SCI_GETMULTIPASTE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetVirtualSpaceOptions", SCI_SETVIRTUALSPACEOPTIONS, SCI_SETVIRTUALSPACEOPTIONS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetVirtualSpaceOptions", SCI_GETVIRTUALSPACEOPTIONS, SCI_GETVIRTUALSPACEOPTIONS, VT_INT, VT_NULL, VT_NULL},
    {L"SciVirtualSpaceOptions", SCI_SETVIRTUALSPACEOPTIONS, SCI_GETVIRTUALSPACEOPTIONS, VT_INT, VT_INT, VT_NULL},
    {L"SciSetRectangularSelectionModifier", SCI_SETRECTANGULARSELECTIONMODIFIER, SCI_SETRECTANGULARSELECTIONMODIFIER, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetRectangularSelectionModifier", SCI_GETRECTANGULARSELECTIONMODIFIER, SCI_GETRECTANGULARSELECTIONMODIFIER, VT_INT, VT_NULL, VT_NULL},
    {L"SciRectangularSelectionModifier", SCI_SETRECTANGULARSELECTIONMODIFIER, SCI_GETRECTANGULARSELECTIONMODIFIER, VT_INT, VT_INT, VT_NULL},
    {L"SciGetSelections", SCI_GETSELECTIONS, SCI_GETSELECTIONS, VT_INT, VT_NULL, VT_NULL},
    {L"SciGetSelectionEmpty", SCI_GETSELECTIONEMPTY, SCI_GETSELECTIONEMPTY, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSelectionEmpty", SCI_GETSELECTIONEMPTY, SCI_GETSELECTIONEMPTY, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSelectionIsEmpty", SCI_GETSELECTIONEMPTY, SCI_GETSELECTIONEMPTY, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciClearSelections", SCI_CLEARSELECTIONS, SCI_CLEARSELECTIONS, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSetSelection", SCI_SETSELECTION, SCI_SETSELECTION, VT_NULL, VT_INT, VT_INT},
    {L"SciAddSelection", SCI_ADDSELECTION, SCI_ADDSELECTION, VT_NULL, VT_INT, VT_INT},
    {L"SciDropSelectionN", SCI_DROPSELECTIONN, SCI_DROPSELECTIONN, VT_NULL, VT_INT, VT_NULL},
    {L"SciDropSelection", SCI_DROPSELECTIONN, SCI_DROPSELECTIONN, VT_NULL, VT_INT, VT_NULL},
    {L"SciSetMainSelection", SCI_SETMAINSELECTION, SCI_SETMAINSELECTION, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetMainSelection", SCI_GETMAINSELECTION, SCI_GETMAINSELECTION, VT_INT, VT_NULL, VT_NULL},
    {L"SciMainSelection", SCI_SETMAINSELECTION, SCI_GETMAINSELECTION, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionNCaret", SCI_SETSELECTIONNCARET, SCI_SETSELECTIONNCARET, VT_NULL, VT_INT, VT_INT},
    {L"SciGetSelectionNCaret", SCI_GETSELECTIONNCARET, SCI_GETSELECTIONNCARET, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionNCaretVirtualSpace", SCI_SETSELECTIONNCARETVIRTUALSPACE, SCI_SETSELECTIONNCARETVIRTUALSPACE, VT_NULL, VT_INT, VT_INT},
    {L"SciGetSelectionNCaretVirtualSpace", SCI_GETSELECTIONNCARETVIRTUALSPACE, SCI_GETSELECTIONNCARETVIRTUALSPACE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionNAnchor", SCI_SETSELECTIONNANCHOR, SCI_SETSELECTIONNANCHOR, VT_NULL, VT_INT, VT_INT},
    {L"SciGetSelectionNAnchor", SCI_GETSELECTIONNANCHOR, SCI_GETSELECTIONNANCHOR, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionNAnchorVirtualSpace", SCI_SETSELECTIONNANCHORVIRTUALSPACE, SCI_SETSELECTIONNANCHORVIRTUALSPACE, VT_NULL, VT_INT, VT_INT},
    {L"SciGetSelectionNAnchorVirtualSpace", SCI_GETSELECTIONNANCHORVIRTUALSPACE, SCI_GETSELECTIONNANCHORVIRTUALSPACE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionNStart", SCI_SETSELECTIONNSTART, SCI_SETSELECTIONNSTART, VT_NULL, VT_INT, VT_INT},
    {L"SciGetSelectionNStart", SCI_GETSELECTIONNSTART, SCI_GETSELECTIONNSTART, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionNEnd", SCI_SETSELECTIONNEND, SCI_SETSELECTIONNEND, VT_NULL, VT_INT, VT_INT},
    {L"SciGetSelectionNEnd", SCI_GETSELECTIONNEND, SCI_GETSELECTIONNEND, VT_INT, VT_INT, VT_NULL},
    {L"SciSetRectangularSelectionCaret", SCI_SETRECTANGULARSELECTIONCARET, SCI_SETRECTANGULARSELECTIONCARET, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetRectangularSelectionCaret", SCI_GETRECTANGULARSELECTIONCARET, SCI_GETRECTANGULARSELECTIONCARET, VT_INT, VT_NULL, VT_NULL},
    {L"SciRectangularSelectionCaret", SCI_SETRECTANGULARSELECTIONCARET, SCI_GETRECTANGULARSELECTIONCARET, VT_INT, VT_INT, VT_NULL},
    {L"SciSetRectangularSelectionCaretVirtualSpace", SCI_SETRECTANGULARSELECTIONCARETVIRTUALSPACE, SCI_SETRECTANGULARSELECTIONCARETVIRTUALSPACE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetRectangularSelectionCaretVirtualSpace", SCI_GETRECTANGULARSELECTIONCARETVIRTUALSPACE, SCI_GETRECTANGULARSELECTIONCARETVIRTUALSPACE, VT_INT, VT_NULL, VT_NULL},
    {L"SciRectangularSelectionCaretVirtualSpace", SCI_SETRECTANGULARSELECTIONCARETVIRTUALSPACE, SCI_GETRECTANGULARSELECTIONCARETVIRTUALSPACE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetRectangularSelectionAnchor", SCI_SETRECTANGULARSELECTIONANCHOR, SCI_SETRECTANGULARSELECTIONANCHOR, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetRectangularSelectionAnchor", SCI_GETRECTANGULARSELECTIONANCHOR, SCI_GETRECTANGULARSELECTIONANCHOR, VT_INT, VT_NULL, VT_NULL},
    {L"SciRectangularSelectionAnchor", SCI_SETRECTANGULARSELECTIONANCHOR, SCI_GETRECTANGULARSELECTIONANCHOR, VT_INT, VT_INT, VT_NULL},
    {L"SciSetRectangularSelectionAnchorVirtualSpace", SCI_SETRECTANGULARSELECTIONANCHORVIRTUALSPACE, SCI_SETRECTANGULARSELECTIONANCHORVIRTUALSPACE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetRectangularSelectionAnchorVirtualSpace", SCI_GETRECTANGULARSELECTIONANCHORVIRTUALSPACE, SCI_GETRECTANGULARSELECTIONANCHORVIRTUALSPACE, VT_INT, VT_NULL, VT_NULL},
    {L"SciRectangularSelectionAnchorVirtualSpace", SCI_SETRECTANGULARSELECTIONANCHORVIRTUALSPACE, SCI_GETRECTANGULARSELECTIONANCHORVIRTUALSPACE, VT_INT, VT_INT, VT_NULL},
    {L"SciAdditionalSelAlpha", SCI_SETADDITIONALSELALPHA, SCI_GETADDITIONALSELALPHA, VT_INT, VT_INT, VT_NULL},
    {L"SciAdditionalCaretFore", SCI_SETADDITIONALCARETFORE, SCI_GETADDITIONALCARETFORE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetAdditionalCaretsBlink", SCI_SETADDITIONALCARETSBLINK, SCI_SETADDITIONALCARETSBLINK, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetAdditionalCaretsBlink", SCI_GETADDITIONALCARETSBLINK, SCI_GETADDITIONALCARETSBLINK, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAdditionalCaretsBlink", SCI_SETADDITIONALCARETSBLINK, SCI_GETADDITIONALCARETSBLINK, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetAdditionalCaretsVisible", SCI_SETADDITIONALCARETSVISIBLE, SCI_SETADDITIONALCARETSVISIBLE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetAdditionalCaretsVisible", SCI_GETADDITIONALCARETSVISIBLE, SCI_GETADDITIONALCARETSVISIBLE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAdditionalCaretsVisible", SCI_SETADDITIONALCARETSVISIBLE, SCI_GETADDITIONALCARETSVISIBLE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSwapMainAnchorCaret", SCI_SWAPMAINANCHORCARET, SCI_SWAPMAINANCHORCARET, VT_NULL, VT_NULL, VT_NULL},
    {L"SciRotateSelection", SCI_ROTATESELECTION, SCI_ROTATESELECTION, VT_NULL, VT_NULL, VT_NULL},
    {L"SciMultipleSelectAddNext", SCI_MULTIPLESELECTADDNEXT, SCI_MULTIPLESELECTADDNEXT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciMultipleAddEach", SCI_MULTIPLESELECTADDEACH, SCI_MULTIPLESELECTADDEACH, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineScroll", SCI_LINESCROLL, SCI_LINESCROLL, VT_NULL, VT_INT, VT_INT},
    {L"SciScrollCaret", SCI_SCROLLCARET, SCI_SCROLLCARET, VT_NULL, VT_NULL, VT_NULL},
    {L"SciScrollRange", SCI_SCROLLRANGE, SCI_SCROLLRANGE, VT_NULL, VT_INT, VT_INT},
    {L"SciSetCaretXPolicy", SCI_SETXCARETPOLICY, SCI_SETXCARETPOLICY, VT_NULL, VT_INT, VT_INT},
    {L"SciSetCaretYPolicy", SCI_SETYCARETPOLICY, SCI_SETYCARETPOLICY, VT_NULL, VT_INT, VT_INT},
    {L"SciSetVisiblePolicy", SCI_SETVISIBLEPOLICY, SCI_SETVISIBLEPOLICY, VT_NULL, VT_INT, VT_INT},
    {L"SciSetHScrollBar", SCI_SETHSCROLLBAR, SCI_SETHSCROLLBAR, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetHScrollBar", SCI_GETHSCROLLBAR, SCI_GETHSCROLLBAR, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciHScrollBar", SCI_SETHSCROLLBAR, SCI_GETHSCROLLBAR, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetVScrollBar", SCI_SETVSCROLLBAR, SCI_SETVSCROLLBAR, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetVScrollBar", SCI_GETVSCROLLBAR, SCI_GETVSCROLLBAR, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciVScrollBar", SCI_SETVSCROLLBAR, SCI_GETVSCROLLBAR, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetXOffset", SCI_SETXOFFSET, SCI_SETXOFFSET, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetXOffset", SCI_GETXOFFSET, SCI_GETXOFFSET, VT_INT, VT_NULL, VT_NULL},
    {L"SciXOffset", SCI_SETXOFFSET, SCI_GETXOFFSET, VT_INT, VT_INT, VT_NULL},
    {L"SciSetScrollWidth", SCI_SETSCROLLWIDTH, SCI_SETSCROLLWIDTH, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetScrollWidth", SCI_GETSCROLLWIDTH, SCI_GETSCROLLWIDTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciScrollWidth", SCI_SETSCROLLWIDTH, SCI_GETSCROLLWIDTH, VT_INT, VT_INT, VT_NULL},
    {L"SciSetScrollWidthTracking", SCI_SETSCROLLWIDTHTRACKING, SCI_SETSCROLLWIDTHTRACKING, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetScrollWidthTracking", SCI_GETSCROLLWIDTHTRACKING, SCI_GETSCROLLWIDTHTRACKING, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciScrollWidthTracking", SCI_SETSCROLLWIDTHTRACKING, SCI_GETSCROLLWIDTHTRACKING, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetEndAtLastLine", SCI_SETENDATLASTLINE, SCI_SETENDATLASTLINE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetEndAtLastLine", SCI_GETENDATLASTLINE, SCI_GETENDATLASTLINE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciEndAtLastLine", SCI_SETENDATLASTLINE, SCI_GETENDATLASTLINE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetViewWs", SCI_SETVIEWWS, SCI_SETVIEWWS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetViewWs", SCI_GETVIEWWS, SCI_GETVIEWWS, VT_INT, VT_NULL, VT_NULL},
    {L"SciViewWs", SCI_SETVIEWWS, SCI_GETVIEWWS, VT_INT, VT_INT, VT_NULL},
    {L"SciSetWhiteSpaceSize", SCI_SETWHITESPACESIZE, SCI_SETWHITESPACESIZE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetWhiteSpaceSize", SCI_GETWHITESPACESIZE, SCI_GETWHITESPACESIZE, VT_INT, VT_NULL, VT_NULL},
    {L"SciWhiteSpaceSize", SCI_SETWHITESPACESIZE, SCI_GETWHITESPACESIZE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetExtraAscent", SCI_SETEXTRAASCENT, SCI_SETEXTRAASCENT, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetExtraAscent", SCI_GETEXTRAASCENT, SCI_GETEXTRAASCENT, VT_INT, VT_NULL, VT_NULL},
    {L"SciExtraAscent", SCI_SETEXTRAASCENT, SCI_GETEXTRAASCENT, VT_INT, VT_INT, VT_NULL},
    {L"SciSetExtraDescent", SCI_SETEXTRADESCENT, SCI_SETEXTRADESCENT, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetExtraDescent", SCI_GETEXTRADESCENT, SCI_GETEXTRADESCENT, VT_INT, VT_NULL, VT_NULL},
    {L"SciExtraDescent", SCI_SETEXTRADESCENT, SCI_GETEXTRADESCENT, VT_INT, VT_INT, VT_NULL},
    {L"SciSetCursor", SCI_SETCURSOR, SCI_SETCURSOR, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCursor", SCI_GETCURSOR, SCI_GETCURSOR, VT_INT, VT_NULL, VT_NULL},
    {L"SciCursor", SCI_SETCURSOR, SCI_GETCURSOR, VT_INT, VT_INT, VT_NULL},
    {L"SciSetMouseDownCaptures", SCI_SETMOUSEDOWNCAPTURES, SCI_SETMOUSEDOWNCAPTURES, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetMouseDownCaptures", SCI_GETMOUSEDOWNCAPTURES, SCI_GETMOUSEDOWNCAPTURES, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciMouseDownCaptures", SCI_SETMOUSEDOWNCAPTURES, SCI_GETMOUSEDOWNCAPTURES, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetEOLMode", SCI_SETEOLMODE, SCI_SETEOLMODE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetEOLMode", SCI_GETEOLMODE, SCI_GETEOLMODE, VT_INT, VT_NULL, VT_NULL},
    {L"SciEOLMode", SCI_SETEOLMODE, SCI_GETEOLMODE, VT_INT, VT_INT, VT_NULL},
    {L"SciConvertEOLs", SCI_CONVERTEOLS, SCI_CONVERTEOLS, VT_NULL, VT_INT, VT_NULL},
    {L"SciSetViewEOL", SCI_SETVIEWEOL, SCI_SETVIEWEOL, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetViewEOL", SCI_GETVIEWEOL, SCI_GETVIEWEOL, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciViewEOL", SCI_SETVIEWEOL, SCI_GETVIEWEOL, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciGetLineEndTypesSupported", SCI_GETLINEENDTYPESSUPPORTED, SCI_GETLINEENDTYPESSUPPORTED, VT_INT, VT_NULL, VT_NULL},
    {L"SciSetLineEndTypesAllowed", SCI_SETLINEENDTYPESALLOWED, SCI_SETLINEENDTYPESALLOWED, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetLineEndTypesAllowed", SCI_GETLINEENDTYPESALLOWED, SCI_GETLINEENDTYPESALLOWED, VT_INT, VT_NULL, VT_NULL},
    {L"SciLineEndTypesAllowed", SCI_SETLINEENDTYPESALLOWED, SCI_GETLINEENDTYPESALLOWED, VT_INT, VT_INT, VT_NULL},
    {L"SciGetLineEndTypesActive", SCI_GETLINEENDTYPESACTIVE, SCI_GETLINEENDTYPESACTIVE, VT_INT, VT_NULL, VT_NULL},
    {L"SciGetEndStyled", SCI_GETENDSTYLED, SCI_GETENDSTYLED, VT_INT, VT_NULL, VT_NULL},
    {L"SciStartStyling", SCI_STARTSTYLING, SCI_STARTSTYLING, VT_NULL, VT_INT, VT_NULL},
    {L"SciSetStyling", SCI_SETSTYLING, SCI_SETSTYLING, VT_NULL, VT_INT, VT_INT},
    {L"SciSetStylingEx", SCI_SETSTYLINGEX, SCI_SETSTYLINGEX, VT_NULL, VT_INT, VT_BSTR},
    {L"SciSetIdleStyling", SCI_SETIDLESTYLING, SCI_SETIDLESTYLING, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetIdleStyling", SCI_GETIDLESTYLING, SCI_GETIDLESTYLING, VT_INT, VT_NULL, VT_NULL},
    {L"SciIdleStyling", SCI_SETIDLESTYLING, SCI_GETIDLESTYLING, VT_INT, VT_INT, VT_NULL},
    {L"SciSetLineState", SCI_SETLINESTATE, SCI_SETLINESTATE, VT_NULL, VT_INT, VT_INT},
    {L"SciGetLineState", SCI_GETLINESTATE, SCI_GETLINESTATE, VT_INT, VT_INT, VT_NULL},
    {L"SciGetMaxLineState", SCI_GETMAXLINESTATE, SCI_GETMAXLINESTATE, VT_INT, VT_NULL, VT_NULL},
    {L"SciMaxLineState", SCI_GETMAXLINESTATE, SCI_GETMAXLINESTATE, VT_INT, VT_NULL, VT_NULL},
    {L"SciStyleResetDefault", SCI_STYLERESETDEFAULT, SCI_STYLERESETDEFAULT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStyleClearAll", SCI_STYLECLEARALL, SCI_STYLECLEARALL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStyleSetFont", SCI_STYLESETFONT, SCI_STYLESETFONT, VT_NULL, VT_INT, VT_BSTR},
    {L"SciStyleGetFont", SCI_STYLEGETFONT, SCI_STYLEGETFONT, VT_BSTR, VT_INT, VT_NULL},
    {L"SciStyleSetSize", SCI_STYLESETSIZE, SCI_STYLESETSIZE, VT_NULL, VT_INT, VT_INT},
    {L"SciStyleGetSize", SCI_STYLEGETSIZE, SCI_STYLEGETSIZE, VT_INT, VT_INT, VT_NULL},
    {L"SciStyleSetSizeFractional", SCI_STYLESETSIZEFRACTIONAL, SCI_STYLESETSIZEFRACTIONAL, VT_NULL, VT_INT, VT_INT},
    {L"SciStyleGetSizeFractional", SCI_STYLEGETSIZEFRACTIONAL, SCI_STYLEGETSIZEFRACTIONAL, VT_INT, VT_INT, VT_NULL},
    {L"SciStyleSetWeight", SCI_STYLESETWEIGHT, SCI_STYLESETWEIGHT, VT_NULL, VT_INT, VT_INT},
    {L"SciStyleGetWeight", SCI_STYLEGETWEIGHT, SCI_STYLEGETWEIGHT, VT_INT, VT_INT, VT_NULL},
    {L"SciStyleSetBold", SCI_STYLESETBOLD, SCI_STYLESETBOLD, VT_NULL, VT_INT, VT_BOOL},
    {L"SciStyleGetBold", SCI_STYLEGETBOLD, SCI_STYLEGETBOLD, VT_BOOL, VT_INT, VT_NULL},
    {L"SciStyleSetItalic", SCI_STYLESETITALIC, SCI_STYLESETITALIC, VT_NULL, VT_INT, VT_BOOL},
    {L"SciStyleGetItalic", SCI_STYLEGETITALIC, SCI_STYLEGETITALIC, VT_BOOL, VT_INT, VT_NULL},
    {L"SciStyleSetUnderline", SCI_STYLESETUNDERLINE, SCI_STYLESETUNDERLINE, VT_NULL, VT_INT, VT_BOOL},
    {L"SciStyleGetUnderline", SCI_STYLEGETUNDERLINE, SCI_STYLEGETUNDERLINE, VT_BOOL, VT_INT, VT_NULL},
    {L"SciStyleSetFore", SCI_STYLESETFORE, SCI_STYLESETFORE, VT_NULL, VT_INT, VT_INT},
    {L"SciStyleGetFore", SCI_STYLEGETFORE, SCI_STYLEGETFORE, VT_INT, VT_INT, VT_NULL},
    {L"SciStyleSetBack", SCI_STYLESETBACK, SCI_STYLESETBACK, VT_NULL, VT_INT, VT_INT},
    {L"SciStyleGetBack", SCI_STYLEGETBACK, SCI_STYLEGETBACK, VT_INT, VT_INT, VT_NULL},
    {L"SciStyleSetEOLFilled", SCI_STYLESETEOLFILLED, SCI_STYLESETEOLFILLED, VT_NULL, VT_INT, VT_BOOL},
    {L"SciStyleGetEOLFilled", SCI_STYLEGETEOLFILLED, SCI_STYLEGETEOLFILLED, VT_BOOL, VT_INT, VT_NULL},
    {L"SciStyleSetCharacterSet", SCI_STYLESETCHARACTERSET, SCI_STYLESETCHARACTERSET, VT_NULL, VT_INT, VT_INT},
    {L"SciStyleGetCharacterSet", SCI_STYLEGETCHARACTERSET, SCI_STYLEGETCHARACTERSET, VT_INT, VT_INT, VT_NULL},
    {L"SciStyleSetCase", SCI_STYLESETCASE, SCI_STYLESETCASE, VT_NULL, VT_INT, VT_INT},
    {L"SciStyleGetCase", SCI_STYLEGETCASE, SCI_STYLEGETCASE, VT_INT, VT_INT, VT_NULL},
    {L"SciStyleSetVisible", SCI_STYLESETVISIBLE, SCI_STYLESETVISIBLE, VT_NULL, VT_INT, VT_BOOL},
    {L"SciStyleGetVisible", SCI_STYLEGETVISIBLE, SCI_STYLEGETVISIBLE, VT_BOOL, VT_INT, VT_NULL},
    {L"SciStyleSetChangeable", SCI_STYLESETCHANGEABLE, SCI_STYLESETCHANGEABLE, VT_NULL, VT_INT, VT_BOOL},
    {L"SciStyleGetChangeable", SCI_STYLEGETCHANGEABLE, SCI_STYLEGETCHANGEABLE, VT_BOOL, VT_INT, VT_NULL},
    {L"SciStyleSetHotSpot", SCI_STYLESETHOTSPOT, SCI_STYLESETHOTSPOT, VT_NULL, VT_INT, VT_BOOL},
    {L"SciStyleGetHotSpot", SCI_STYLEGETHOTSPOT, SCI_STYLEGETHOTSPOT, VT_BOOL, VT_INT, VT_NULL},
    {L"SciSetSelEOLFilled", SCI_SETSELEOLFILLED, SCI_SETSELEOLFILLED, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetSelEOLFilled", SCI_GETSELEOLFILLED, SCI_GETSELEOLFILLED, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSelEOLFilled", SCI_SETSELEOLFILLED, SCI_GETSELEOLFILLED, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetCaretLineBack", SCI_SETCARETLINEBACK, SCI_SETCARETLINEBACK, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCaretLineBack", SCI_GETCARETLINEBACK, SCI_GETCARETLINEBACK, VT_INT, VT_NULL, VT_NULL},
    {L"SciCaretLineBack", SCI_SETCARETLINEBACK, SCI_GETCARETLINEBACK, VT_INT, VT_INT, VT_NULL},
    {L"SciSetCaretLineBackAlpha", SCI_SETCARETLINEBACKALPHA, SCI_SETCARETLINEBACKALPHA, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCaretLineBackAlpha", SCI_GETCARETLINEBACKALPHA, SCI_GETCARETLINEBACKALPHA, VT_INT, VT_NULL, VT_NULL},
    {L"SciCaretLineBackAlpha", SCI_SETCARETLINEBACKALPHA, SCI_GETCARETLINEBACKALPHA, VT_INT, VT_INT, VT_NULL},
    {L"SciSetCaretLineFrame", SCI_SETCARETLINEFRAME, SCI_SETCARETLINEFRAME, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCaretLineFrame", SCI_GETCARETLINEFRAME, SCI_GETCARETLINEFRAME, VT_INT, VT_NULL, VT_NULL},
    {L"SciCaretLineFrame", SCI_SETCARETLINEFRAME, SCI_GETCARETLINEFRAME, VT_INT, VT_INT, VT_NULL},
    {L"SciSetCaretLineVisibleAlways", SCI_SETCARETLINEVISIBLEALWAYS, SCI_SETCARETLINEVISIBLEALWAYS, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetCaretLineVisibleAlways", SCI_GETCARETLINEVISIBLEALWAYS, SCI_GETCARETLINEVISIBLEALWAYS, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciCaretLineVisibleAlways", SCI_SETCARETLINEVISIBLEALWAYS, SCI_GETCARETLINEVISIBLEALWAYS, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetCaretPeriod", SCI_SETCARETPERIOD, SCI_SETCARETPERIOD, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCaretPeriod", SCI_GETCARETPERIOD, SCI_GETCARETPERIOD, VT_INT, VT_NULL, VT_NULL},
    {L"SciCaretPeriod", SCI_SETCARETPERIOD, SCI_GETCARETPERIOD, VT_INT, VT_INT, VT_NULL},
    {L"SciSetCaretStyle", SCI_SETCARETSTYLE, SCI_SETCARETSTYLE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCaretStyle", SCI_GETCARETSTYLE, SCI_GETCARETSTYLE, VT_INT, VT_NULL, VT_NULL},
    {L"SciCaretStyle", SCI_SETCARETSTYLE, SCI_GETCARETSTYLE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetCaretWidth", SCI_SETCARETWIDTH, SCI_SETCARETWIDTH, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCaretWidth", SCI_GETCARETWIDTH, SCI_GETCARETWIDTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciCaretWidth", SCI_SETCARETWIDTH, SCI_GETCARETWIDTH, VT_INT, VT_INT, VT_NULL},
    {L"SciSetSelectionLayer", SCI_SETSELECTIONLAYER, SCI_SETSELECTIONLAYER, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetSelectionLayer", SCI_GETSELECTIONLAYER, SCI_GETSELECTIONLAYER, VT_INT, VT_NULL, VT_NULL},
    {L"SciSetElementColour", SCI_SETELEMENTCOLOUR, SCI_SETELEMENTCOLOUR, VT_NULL, VT_INT, VT_INT},
    {L"SciGetElementColour", SCI_GETELEMENTCOLOUR, SCI_GETELEMENTCOLOUR, VT_INT, VT_INT, VT_NULL},
    {L"SciElementColour", SCI_SETELEMENTCOLOUR, SCI_GETELEMENTCOLOUR, VT_INT, VT_INT, VT_NULL},
    {L"SciResetElementColour", SCI_RESETELEMENTCOLOUR, SCI_RESETELEMENTCOLOUR, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetElementAllowTranslucent", SCI_GETELEMENTALLOWSTRANSLUCENT, SCI_GETELEMENTALLOWSTRANSLUCENT, VT_BOOL, VT_INT, VT_NULL},
    {L"SciGetElementBaseColour", SCI_GETELEMENTBASECOLOUR, SCI_GETELEMENTBASECOLOUR, VT_INT, VT_INT, VT_NULL},
    {L"SciSetHotSpotActiveUnderline", SCI_SETHOTSPOTACTIVEUNDERLINE, SCI_SETHOTSPOTACTIVEUNDERLINE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetHotSpotActiveUnderline", SCI_GETHOTSPOTACTIVEUNDERLINE, SCI_GETHOTSPOTACTIVEUNDERLINE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciHotSpotActiveUnderline", SCI_SETHOTSPOTACTIVEUNDERLINE, SCI_GETHOTSPOTACTIVEUNDERLINE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetHotSpotSingleLine", SCI_SETHOTSPOTSINGLELINE, SCI_SETHOTSPOTSINGLELINE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetHotSpotSingleLine", SCI_GETHOTSPOTSINGLELINE, SCI_GETHOTSPOTSINGLELINE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciHotSpotSingleLine", SCI_SETHOTSPOTSINGLELINE, SCI_GETHOTSPOTSINGLELINE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetCaretSticky", SCI_SETCARETSTICKY, SCI_SETCARETSTICKY, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCaretSticky", SCI_GETCARETSTICKY, SCI_GETCARETSTICKY, VT_INT, VT_NULL, VT_NULL},
    {L"SciCaretSticky", SCI_SETCARETSTICKY, SCI_GETCARETSTICKY, VT_INT, VT_INT, VT_NULL},
    {L"SciToggleCaretSticky", SCI_TOGGLECARETSTICKY, SCI_TOGGLECARETSTICKY, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSetMarginTypeN", SCI_SETMARGINTYPEN, SCI_SETMARGINTYPEN, VT_NULL, VT_INT, VT_INT},
    {L"SciGetMarginTypeN", SCI_GETMARGINTYPEN, SCI_GETMARGINTYPEN, VT_INT, VT_INT, VT_NULL},
    {L"SciSetMarginWidthN", SCI_SETMARGINWIDTHN, SCI_SETMARGINWIDTHN, VT_NULL, VT_INT, VT_INT},
    {L"SciGetMarginWidthN", SCI_GETMARGINWIDTHN, SCI_GETMARGINWIDTHN, VT_INT, VT_INT, VT_NULL},
    {L"SciSetMarginMaskN", SCI_SETMARGINMASKN, SCI_SETMARGINMASKN, VT_NULL, VT_INT, VT_INT},
    {L"SciGetMarginMaskN", SCI_GETMARGINMASKN, SCI_GETMARGINMASKN, VT_INT, VT_INT, VT_NULL},
    {L"SciSetMarginSensitiveN", SCI_SETMARGINSENSITIVEN, SCI_SETMARGINSENSITIVEN, VT_NULL, VT_INT, VT_BOOL},
    {L"SciGetMarginSensitiveN", SCI_GETMARGINSENSITIVEN, SCI_GETMARGINSENSITIVEN, VT_BOOL, VT_INT, VT_NULL},
    {L"SciSetMarginCursorN", SCI_SETMARGINCURSORN, SCI_SETMARGINCURSORN, VT_NULL, VT_INT, VT_INT},
    {L"SciGetMarginCursorN", SCI_GETMARGINCURSORN, SCI_GETMARGINCURSORN, VT_INT, VT_INT, VT_NULL},
    {L"SciSetFolderMarginColour", SCI_SETFOLDMARGINCOLOUR, SCI_SETFOLDMARGINCOLOUR, VT_NULL, VT_BOOL, VT_INT},
    {L"SciSetFolderMarginHiColour", SCI_SETFOLDMARGINHICOLOUR, SCI_SETFOLDMARGINHICOLOUR, VT_NULL, VT_BOOL, VT_INT},
    {L"SciMarginSetText", SCI_MARGINSETTEXT, SCI_MARGINSETTEXT, VT_NULL, VT_INT, VT_BSTR},
    {L"SciMarginGetText", SCI_MARGINGETTEXT, SCI_MARGINGETTEXT, VT_BSTR, VT_INT, VT_NULL},
    {L"SciMarginSetStyle", SCI_MARGINSETSTYLE, SCI_MARGINSETSTYLE, VT_NULL, VT_INT, VT_INT},
    {L"SciMarginGetStyle", SCI_MARGINGETSTYLE, SCI_MARGINGETSTYLE, VT_INT, VT_INT, VT_NULL},
    {L"SciMarginExtClearAll", SCI_MARGINTEXTCLEARALL, SCI_MARGINTEXTCLEARALL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciMarginSetStyleOffset", SCI_MARGINSETSTYLEOFFSET, SCI_MARGINSETSTYLEOFFSET, VT_NULL, VT_INT, VT_NULL},
    {L"SciMarginGetStyleOffset", SCI_MARGINGETSTYLEOFFSET, SCI_MARGINGETSTYLEOFFSET, VT_INT, VT_NULL, VT_NULL},
    {L"SciSetMarginOptions", SCI_SETMARGINOPTIONS, SCI_SETMARGINOPTIONS, VT_NULL, VT_INT, VT_NULL},
    {L"SciSetMarginOptions", SCI_GETMARGINOPTIONS, SCI_GETMARGINOPTIONS, VT_INT, VT_NULL, VT_NULL},
    {L"SciAnnotationSetText", SCI_ANNOTATIONSETTEXT, SCI_ANNOTATIONSETTEXT, VT_NULL, VT_INT, VT_BSTR},
    {L"SciAnnotationGetText", SCI_ANNOTATIONGETTEXT, SCI_ANNOTATIONGETTEXT, VT_BSTR, VT_INT, VT_NULL},
    {L"SciAnnotationSetStyle", SCI_ANNOTATIONSETSTYLE, SCI_ANNOTATIONSETSTYLE, VT_NULL, VT_INT, VT_INT},
    {L"SciAnnotationGetStyle", SCI_ANNOTATIONGETSTYLE, SCI_ANNOTATIONGETSTYLE, VT_INT, VT_INT, VT_NULL},
    {L"SciAnnotationGetLines", SCI_ANNOTATIONGETLINES, SCI_ANNOTATIONGETLINES, VT_NULL, VT_INT, VT_NULL},
    {L"SciAnnotationClearAll", SCI_ANNOTATIONCLEARALL, SCI_ANNOTATIONCLEARALL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciAnnotationSetVisible", SCI_ANNOTATIONSETVISIBLE, SCI_ANNOTATIONSETVISIBLE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciAnnotationGetVisible", SCI_ANNOTATIONGETVISIBLE, SCI_ANNOTATIONGETVISIBLE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAnnotationSetStyleOffset", SCI_ANNOTATIONSETSTYLEOFFSET, SCI_ANNOTATIONSETSTYLEOFFSET, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciAnnotationGetStyleOffset", SCI_ANNOTATIONGETSTYLEOFFSET, SCI_ANNOTATIONGETSTYLEOFFSET, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSetBufferedRedraw", SCI_SETBUFFEREDDRAW, SCI_SETBUFFEREDDRAW, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetBufferedRedraw", SCI_GETBUFFEREDDRAW, SCI_GETBUFFEREDDRAW, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciBufferedRedraw", SCI_SETBUFFEREDDRAW, SCI_GETBUFFEREDDRAW, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetPhaseDraw", SCI_SETPHASESDRAW, SCI_SETPHASESDRAW, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetPhaseDraw", SCI_GETPHASESDRAW, SCI_GETPHASESDRAW, VT_INT, VT_NULL, VT_NULL},
    {L"SciPhaseDraw", SCI_SETPHASESDRAW, SCI_GETPHASESDRAW, VT_INT, VT_INT, VT_NULL},
    {L"SciSetTechnology", SCI_SETTECHNOLOGY, SCI_SETTECHNOLOGY, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetTechnology", SCI_GETTECHNOLOGY, SCI_GETTECHNOLOGY, VT_INT, VT_NULL, VT_NULL},
    {L"SciTechnology", SCI_SETTECHNOLOGY, SCI_GETTECHNOLOGY, VT_INT, VT_INT, VT_NULL},
    {L"SciSetFontQuality", SCI_SETFONTQUALITY, SCI_SETFONTQUALITY, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetFontQuality", SCI_GETFONTQUALITY, SCI_GETFONTQUALITY, VT_INT, VT_NULL, VT_NULL},
    {L"SciFontQuality", SCI_SETFONTQUALITY, SCI_GETFONTQUALITY, VT_INT, VT_INT, VT_NULL},
    {L"SciSetCodePage", SCI_SETCODEPAGE, SCI_SETCODEPAGE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetCodePage", SCI_GETCODEPAGE, SCI_GETCODEPAGE, VT_INT, VT_NULL, VT_NULL},
    {L"SciCodePage", SCI_SETCODEPAGE, SCI_GETCODEPAGE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetWordChars", SCI_SETWORDCHARS, SCI_SETWORDCHARS, VT_NULL, VT_BSTR, VT_NULL},
    {L"SciGetWordChars", SCI_GETWORDCHARS, SCI_GETWORDCHARS, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciSetWhiteSpaceChars", SCI_SETWHITESPACECHARS, SCI_SETWHITESPACECHARS, VT_NULL, VT_BSTR, VT_NULL},
    {L"SciGetWhiteSpaceChars", SCI_GETWHITESPACECHARS, SCI_GETWHITESPACECHARS, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciSetPunctuationChars", SCI_SETPUNCTUATIONCHARS, SCI_SETPUNCTUATIONCHARS, VT_NULL, VT_BSTR, VT_NULL},
    {L"SciGetPunctuationChars", SCI_GETPUNCTUATIONCHARS, SCI_GETPUNCTUATIONCHARS, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciSetCharsDefault", SCI_SETCHARSDEFAULT, SCI_SETCHARSDEFAULT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciGrabFocus", SCI_GRABFOCUS, SCI_GRABFOCUS, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSetFocus", SCI_SETFOCUS, SCI_SETFOCUS, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetFocus", SCI_GETFOCUS, SCI_GETFOCUS, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciBraceHighlight", SCI_BRACEHIGHLIGHT, SCI_BRACEHIGHLIGHT, VT_NULL, VT_INT, VT_INT},
    {L"SciBraceBadlight", SCI_BRACEBADLIGHT, SCI_BRACEBADLIGHT, VT_NULL, VT_INT, VT_NULL},
    {L"SciBraceHighlightIndicator", SCI_BRACEHIGHLIGHTINDICATOR, SCI_BRACEHIGHLIGHTINDICATOR, VT_NULL, VT_BOOL, VT_INT},
    {L"SciBraceBadlightIndicator", SCI_BRACEBADLIGHTINDICATOR, SCI_BRACEBADLIGHTINDICATOR, VT_NULL, VT_BOOL, VT_INT},
    {L"SciBraceMatch", SCI_BRACEMATCH, SCI_BRACEMATCH, VT_NULL, VT_INT, VT_INT},
    {L"SciSetTabWidth", SCI_SETTABWIDTH, SCI_SETTABWIDTH, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetTabWidth", SCI_GETTABWIDTH, SCI_GETTABWIDTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciTabWidth", SCI_SETTABWIDTH, SCI_GETTABWIDTH, VT_INT, VT_INT, VT_NULL},
    {L"SciClearTabStops", SCI_CLEARTABSTOPS, SCI_CLEARTABSTOPS, VT_NULL, VT_INT, VT_NULL},
    {L"SciAddTabStop", SCI_ADDTABSTOP, SCI_ADDTABSTOP, VT_NULL, VT_INT, VT_INT},
    {L"SciGetNextTabStop", SCI_GETNEXTTABSTOP, SCI_GETNEXTTABSTOP, VT_NULL, VT_INT, VT_INT},
    {L"SciSetUseTabs", SCI_SETUSETABS, SCI_SETUSETABS, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetUseTabs", SCI_GETUSETABS, SCI_GETUSETABS, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciUseTabs", SCI_SETUSETABS, SCI_GETUSETABS, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetIndent", SCI_SETINDENT, SCI_SETINDENT, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetIndent", SCI_GETINDENT, SCI_GETINDENT, VT_INT, VT_NULL, VT_NULL},
    {L"SciIndent", SCI_SETINDENT, SCI_GETINDENT, VT_INT, VT_INT, VT_NULL},
    {L"SciSetBackspaceUnindents", SCI_SETBACKSPACEUNINDENTS, SCI_SETBACKSPACEUNINDENTS, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciGetBackspaceUnindents", SCI_GETBACKSPACEUNINDENTS, SCI_GETBACKSPACEUNINDENTS, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciBackspaceUnindents", SCI_SETBACKSPACEUNINDENTS, SCI_GETBACKSPACEUNINDENTS, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciSetLineIndentation", SCI_SETLINEINDENTATION, SCI_SETLINEINDENTATION, VT_NULL, VT_INT, VT_INT},
    {L"SciGetLineIndentation", SCI_GETLINEINDENTATION, SCI_GETLINEINDENTATION, VT_INT, VT_INT, VT_NULL},
    {L"SciGetLineIndentPosition", SCI_GETLINEINDENTPOSITION, SCI_GETLINEINDENTPOSITION, VT_INT, VT_INT, VT_NULL},
    {L"SciSetIndentationGuides", SCI_SETINDENTATIONGUIDES, SCI_SETINDENTATIONGUIDES, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetIndentationGuides", SCI_GETINDENTATIONGUIDES, SCI_GETINDENTATIONGUIDES, VT_INT, VT_NULL, VT_NULL},
    {L"SciIndentationGuides", SCI_SETINDENTATIONGUIDES, SCI_GETINDENTATIONGUIDES, VT_INT, VT_INT, VT_NULL},
    {L"SciSetHighlightGuide", SCI_SETHIGHLIGHTGUIDE, SCI_SETHIGHLIGHTGUIDE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetHighlightGuide", SCI_GETHIGHLIGHTGUIDE, SCI_GETHIGHLIGHTGUIDE, VT_INT, VT_NULL, VT_NULL},
    {L"SciHighlightGuide", SCI_SETHIGHLIGHTGUIDE, SCI_GETHIGHLIGHTGUIDE, VT_INT, VT_INT, VT_NULL},
    {L"SciMarkerDefine", SCI_MARKERDEFINE, SCI_MARKERDEFINE, VT_NULL, VT_INT, VT_INT},
    {L"SciRGBAImageSetWidth", SCI_RGBAIMAGESETWIDTH, SCI_RGBAIMAGESETWIDTH, VT_NULL, VT_INT, VT_NULL},
    {L"SciRGBAImageSetHeight", SCI_RGBAIMAGESETHEIGHT, SCI_RGBAIMAGESETHEIGHT, VT_NULL, VT_INT, VT_NULL},
    {L"SciRGBAImageSetScale", SCI_RGBAIMAGESETSCALE, SCI_RGBAIMAGESETSCALE, VT_NULL, VT_INT, VT_NULL},
    {L"SciMarkerSymbolDefined", SCI_MARKERSYMBOLDEFINED, SCI_MARKERSYMBOLDEFINED, VT_NULL, VT_INT, VT_NULL},
    {L"SciMarkerSetFore", SCI_MARKERSETFORE, SCI_MARKERSETFORE, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerSetBack", SCI_MARKERSETBACK, SCI_MARKERSETBACK, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerSetBackSelected", SCI_MARKERSETBACKSELECTED, SCI_MARKERSETBACKSELECTED, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerSetAlpha", SCI_MARKERSETALPHA, SCI_MARKERSETALPHA, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerEnableHighlight", SCI_MARKERENABLEHIGHLIGHT, SCI_MARKERENABLEHIGHLIGHT, VT_NULL, VT_INT, VT_NULL},
    {L"SciMarkerAdd", SCI_MARKERADD, SCI_MARKERADD, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerAddSet", SCI_MARKERADDSET, SCI_MARKERADDSET, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerDelete", SCI_MARKERDELETE, SCI_MARKERDELETE, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerDeleteAll", SCI_MARKERDELETEALL, SCI_MARKERDELETEALL, VT_NULL, VT_INT, VT_NULL},
    {L"SciMarkerGet", SCI_MARKERGET, SCI_MARKERGET, VT_NULL, VT_INT, VT_NULL},
    {L"SciMarkerNext", SCI_MARKERNEXT, SCI_MARKERNEXT, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerPrevious", SCI_MARKERPREVIOUS, SCI_MARKERPREVIOUS, VT_NULL, VT_INT, VT_INT},
    {L"SciMarkerLineFromHandle", SCI_MARKERLINEFROMHANDLE, SCI_MARKERLINEFROMHANDLE, VT_INT, VT_INT, VT_NULL},
    {L"SciMarkerDeleteHandle", SCI_MARKERDELETEHANDLE, SCI_MARKERDELETEHANDLE, VT_NULL, VT_INT, VT_NULL},
    {L"SciIndicSetStyle", SCI_INDICSETSTYLE, SCI_INDICSETSTYLE, VT_NULL, VT_INT, VT_INT},
    {L"SciIndicGetStyle", SCI_INDICGETSTYLE, SCI_INDICGETSTYLE, VT_INT, VT_INT, VT_NULL},
    {L"SciIndicSetFore", SCI_INDICSETFORE, SCI_INDICSETFORE, VT_NULL, VT_INT, VT_INT},
    {L"SciIndicGetFore", SCI_INDICGETFORE, SCI_INDICGETFORE, VT_INT, VT_INT, VT_NULL},
    {L"SciIndicSetAlpha", SCI_INDICSETALPHA, SCI_INDICSETALPHA, VT_NULL, VT_INT, VT_INT},
    {L"SciIndicGetAlpha", SCI_INDICGETALPHA, SCI_INDICGETALPHA, VT_INT, VT_INT, VT_NULL},
    {L"SciIndicSetOutlineAlpha", SCI_INDICSETOUTLINEALPHA, SCI_INDICSETOUTLINEALPHA, VT_NULL, VT_INT, VT_INT},
    {L"SciIndicGetOutlineAlpha", SCI_INDICGETOUTLINEALPHA, SCI_INDICGETOUTLINEALPHA, VT_INT, VT_INT, VT_NULL},
    {L"SciIndicSetUnder", SCI_INDICSETUNDER, SCI_INDICSETUNDER, VT_NULL, VT_INT, VT_BOOL},
    {L"SciIndicGetUnder", SCI_INDICGETUNDER, SCI_INDICGETUNDER, VT_BOOL, VT_INT, VT_NULL},
    {L"SciSetIndicatorCurrent", SCI_SETINDICATORCURRENT, SCI_SETINDICATORCURRENT, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetIndicatorCurrent", SCI_GETINDICATORCURRENT, SCI_GETINDICATORCURRENT, VT_INT, VT_NULL, VT_NULL},
    {L"SciIndicatorCurrent", SCI_SETINDICATORCURRENT, SCI_GETINDICATORCURRENT, VT_INT, VT_INT, VT_NULL},
    {L"SciSetIndicatorValue", SCI_SETINDICATORVALUE, SCI_SETINDICATORVALUE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetIndicatorValue", SCI_GETINDICATORVALUE, SCI_GETINDICATORVALUE, VT_INT, VT_NULL, VT_NULL},
    {L"SciIndicatorValue", SCI_SETINDICATORVALUE, SCI_GETINDICATORVALUE, VT_INT, VT_INT, VT_NULL},
    {L"SciIndicatorFillRange", SCI_INDICATORFILLRANGE, SCI_INDICATORFILLRANGE, VT_NULL, VT_INT, VT_INT},
    {L"SciIndicatorClearRange", SCI_INDICATORCLEARRANGE, SCI_INDICATORCLEARRANGE, VT_NULL, VT_INT, VT_INT},
    {L"SciIndicatorAllOnFor", SCI_INDICATORALLONFOR, SCI_INDICATORALLONFOR, VT_NULL, VT_INT, VT_NULL},
    {L"SciIndicatorValueAt", SCI_INDICATORVALUEAT, SCI_INDICATORVALUEAT, VT_INT, VT_INT, VT_INT},
    {L"SciIndicatorStart", SCI_INDICATORSTART, SCI_INDICATORSTART, VT_INT, VT_INT, VT_INT},
    {L"SciIndicatorEnd", SCI_INDICATOREND, SCI_INDICATOREND, VT_INT, VT_INT, VT_INT},
    {L"SciFindIndicatorShow", SCI_FINDINDICATORSHOW, SCI_FINDINDICATORSHOW, VT_INT, VT_INT, VT_INT},
    {L"SciFindIndicatorFlash", SCI_FINDINDICATORFLASH, SCI_FINDINDICATORFLASH, VT_INT, VT_INT, VT_INT},
    {L"SciFindIndicatorHide", SCI_FINDINDICATORHIDE, SCI_FINDINDICATORHIDE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciAutoCShow", SCI_AUTOCSHOW, SCI_AUTOCSHOW, VT_NULL, VT_INT, VT_BSTR},
    {L"SciAutoCCancel", SCI_AUTOCCANCEL, SCI_AUTOCCANCEL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciAutoCActive", SCI_AUTOCACTIVE, SCI_AUTOCACTIVE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAutoCPosStart", SCI_AUTOCPOSSTART, SCI_AUTOCPOSSTART, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCComplete", SCI_AUTOCCOMPLETE, SCI_AUTOCCOMPLETE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciAutoCStops", SCI_AUTOCSTOPS, SCI_AUTOCSTOPS, VT_NULL, VT_BSTR, VT_NULL},
    {L"SciAutoCSetSeparator", SCI_AUTOCSETSEPARATOR, SCI_AUTOCSETSEPARATOR, VT_NULL, VT_INT, VT_NULL},
    {L"SciAutoCGetSeparator", SCI_AUTOCGETSEPARATOR, SCI_AUTOCGETSEPARATOR, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCSeparator", SCI_AUTOCSETSEPARATOR, SCI_AUTOCGETSEPARATOR, VT_INT, VT_INT, VT_NULL},
    {L"SciAutoCSelect", SCI_AUTOCSELECT, SCI_AUTOCSELECT, VT_NULL, VT_BSTR, VT_NULL},
    {L"SciAutoCGetCurrent", SCI_AUTOCGETCURRENT, SCI_AUTOCGETCURRENT, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCGetCurrentText", SCI_AUTOCGETCURRENTTEXT, SCI_AUTOCGETCURRENTTEXT, VT_BSTR, VT_NULL, VT_NULL},
    {L"SciAutoCSetCancelAtStart", SCI_AUTOCSETCANCELATSTART, SCI_AUTOCSETCANCELATSTART, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciAutoCGetCancelAtStart", SCI_AUTOCGETCANCELATSTART, SCI_AUTOCGETCANCELATSTART, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAutoCCancelAtStart", SCI_AUTOCSETCANCELATSTART, SCI_AUTOCGETCANCELATSTART, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciAutoCSetFillups", SCI_AUTOCSETFILLUPS, SCI_AUTOCSETFILLUPS, VT_NULL, VT_BSTR, VT_NULL},
    {L"SciAutoCSetChooseSingle", SCI_AUTOCSETCHOOSESINGLE, SCI_AUTOCSETCHOOSESINGLE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciAutoCGetChooseSingle", SCI_AUTOCGETCHOOSESINGLE, SCI_AUTOCGETCHOOSESINGLE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAutoCChooseSingle", SCI_AUTOCSETCHOOSESINGLE, SCI_AUTOCGETCHOOSESINGLE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciAutoCSetIgnoreCase", SCI_AUTOCSETIGNORECASE, SCI_AUTOCSETIGNORECASE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciAutoCGetIgnoreCase", SCI_AUTOCGETIGNORECASE, SCI_AUTOCGETIGNORECASE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAutoCIgnoreCase", SCI_AUTOCSETIGNORECASE, SCI_AUTOCGETIGNORECASE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciAutoCSetCaseInsensitiveBehaviour", SCI_AUTOCSETCASEINSENSITIVEBEHAVIOUR, SCI_AUTOCSETCASEINSENSITIVEBEHAVIOUR, VT_NULL, VT_INT, VT_NULL},
    {L"SciAutoCGetCaseInsensitiveBehaviour", SCI_AUTOCGETCASEINSENSITIVEBEHAVIOUR, SCI_AUTOCGETCASEINSENSITIVEBEHAVIOUR, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCCaseInsensitiveBehaviour", SCI_AUTOCSETCASEINSENSITIVEBEHAVIOUR, SCI_AUTOCGETCASEINSENSITIVEBEHAVIOUR, VT_INT, VT_INT, VT_NULL},
    {L"SciAutoCSetOrder", SCI_AUTOCSETORDER, SCI_AUTOCSETORDER, VT_NULL, VT_INT, VT_NULL},
    {L"SciAutoCGetOrder", SCI_AUTOCGETORDER, SCI_AUTOCGETORDER, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCOrder", SCI_AUTOCSETORDER, SCI_AUTOCGETORDER, VT_INT, VT_INT, VT_NULL},
    {L"SciAutoCSetAutoHide", SCI_AUTOCSETAUTOHIDE, SCI_AUTOCSETAUTOHIDE, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciAutoCGetAutoHide", SCI_AUTOCGETAUTOHIDE, SCI_AUTOCGETAUTOHIDE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAutoCAutoHide", SCI_AUTOCSETAUTOHIDE, SCI_AUTOCGETAUTOHIDE, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciAutoCSetDropRestOfWord", SCI_AUTOCSETDROPRESTOFWORD, SCI_AUTOCSETDROPRESTOFWORD, VT_NULL, VT_BOOL, VT_NULL},
    {L"SciAutoCGetDropRestOfWord", SCI_AUTOCGETDROPRESTOFWORD, SCI_AUTOCGETDROPRESTOFWORD, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAutoCDropRestOfWord", SCI_AUTOCSETDROPRESTOFWORD, SCI_AUTOCGETDROPRESTOFWORD, VT_BOOL, VT_BOOL, VT_NULL},
    {L"SciAutoCSetTypeSeparator", SCI_AUTOCSETTYPESEPARATOR, SCI_AUTOCSETTYPESEPARATOR, VT_NULL, VT_INT, VT_NULL},
    {L"SciAutoCGetTypeSeparator", SCI_AUTOCGETTYPESEPARATOR, SCI_AUTOCGETTYPESEPARATOR, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCTypeSeparator", SCI_AUTOCSETTYPESEPARATOR, SCI_AUTOCGETTYPESEPARATOR, VT_INT, VT_INT, VT_NULL},
    {L"SciAutoCSetMaxHeight", SCI_AUTOCSETMAXHEIGHT, SCI_AUTOCSETMAXHEIGHT, VT_NULL, VT_INT, VT_NULL},
    {L"SciAutoCGetMaxHeight", SCI_AUTOCGETMAXHEIGHT, SCI_AUTOCGETMAXHEIGHT, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCMaxHeight", SCI_AUTOCSETMAXHEIGHT, SCI_AUTOCGETMAXHEIGHT, VT_INT, VT_INT, VT_NULL},
    {L"SciAutoCSetMaxWidth", SCI_AUTOCSETMAXWIDTH, SCI_AUTOCSETMAXWIDTH, VT_NULL, VT_INT, VT_NULL},
    {L"SciAutoCGetMaxWidth", SCI_AUTOCGETMAXWIDTH, SCI_AUTOCGETMAXWIDTH, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutoCMaxWidth", SCI_AUTOCSETMAXWIDTH, SCI_AUTOCGETMAXWIDTH, VT_INT, VT_INT, VT_NULL},
    {L"SciCallTipShow", SCI_CALLTIPSHOW, SCI_CALLTIPSHOW, VT_NULL, VT_INT, VT_BSTR},
    {L"SciCallTipCancel", SCI_CALLTIPCANCEL, SCI_CALLTIPCANCEL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCallTipActive", SCI_CALLTIPACTIVE, SCI_CALLTIPACTIVE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciCallTipPosStart", SCI_CALLTIPPOSSTART, SCI_CALLTIPPOSSTART, VT_INT, VT_NULL, VT_NULL},
    {L"SciCallTipSetPosStart", SCI_CALLTIPSETPOSSTART, SCI_CALLTIPSETPOSSTART, VT_NULL, VT_INT, VT_NULL},
    {L"SciCallTipSetHlt", SCI_CALLTIPSETHLT, SCI_CALLTIPSETHLT, VT_NULL, VT_INT, VT_INT},
    {L"SciCallTipSetBack", SCI_CALLTIPSETBACK, SCI_CALLTIPSETBACK, VT_NULL, VT_INT, VT_NULL},
    {L"SciCallTipSetFore", SCI_CALLTIPSETFORE, SCI_CALLTIPSETFORE, VT_NULL, VT_INT, VT_NULL},
    {L"SciCallTipSetForeHlt", SCI_CALLTIPSETFOREHLT, SCI_CALLTIPSETFOREHLT, VT_NULL, VT_INT, VT_NULL},
    {L"SciCallTipUseStyle", SCI_CALLTIPUSESTYLE, SCI_CALLTIPUSESTYLE, VT_NULL, VT_INT, VT_NULL},
    {L"SciCallTipSetPosition", SCI_CALLTIPSETPOSITION, SCI_CALLTIPSETPOSITION, VT_NULL, VT_INT, VT_NULL},
    {L"SciLineDown", SCI_LINEDOWN, SCI_LINEDOWN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineDownExtend", SCI_LINEDOWNEXTEND, SCI_LINEDOWNEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineDownRectExtend", SCI_LINEDOWNRECTEXTEND, SCI_LINEDOWNRECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineScrollDown", SCI_LINESCROLLDOWN, SCI_LINESCROLLDOWN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineUp", SCI_LINEUP, SCI_LINEUP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineUpExtend", SCI_LINEUPEXTEND, SCI_LINEUPEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineUpRectExtend", SCI_LINEUPRECTEXTEND, SCI_LINEUPRECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineScrollUp", SCI_LINESCROLLUP, SCI_LINESCROLLUP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciParaDown", SCI_PARADOWN, SCI_PARADOWN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciParaDownExtend", SCI_PARADOWNEXTEND, SCI_PARADOWNEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciParaUp", SCI_PARAUP, SCI_PARAUP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciParaUpExtend", SCI_PARAUPEXTEND, SCI_PARAUPEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCharLeft", SCI_CHARLEFT, SCI_CHARLEFT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCharLeftExtend", SCI_CHARLEFTEXTEND, SCI_CHARLEFTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCharLeftRectExtend", SCI_CHARLEFTRECTEXTEND, SCI_CHARLEFTRECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCharRight", SCI_CHARRIGHT, SCI_CHARRIGHT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCharRightExtend", SCI_CHARRIGHTEXTEND, SCI_CHARRIGHTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCharRightRectExtend", SCI_CHARRIGHTRECTEXTEND, SCI_CHARRIGHTRECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordLeft", SCI_WORDLEFT, SCI_WORDLEFT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordLeftExtend", SCI_WORDLEFTEXTEND, SCI_WORDLEFTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordRight", SCI_WORDRIGHT, SCI_WORDRIGHT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordRightExtend", SCI_WORDRIGHTEXTEND, SCI_WORDRIGHTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordLeftEnd", SCI_WORDLEFTEND, SCI_WORDLEFTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordLeftEndExtend", SCI_WORDLEFTENDEXTEND, SCI_WORDLEFTENDEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordRightEnd", SCI_WORDRIGHTEND, SCI_WORDRIGHTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordRightEndExtend", SCI_WORDRIGHTENDEXTEND, SCI_WORDRIGHTENDEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordPartLeft", SCI_WORDPARTLEFT, SCI_WORDPARTLEFT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordPartLeftExtend", SCI_WORDPARTLEFTEXTEND, SCI_WORDPARTLEFTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordPartRight", SCI_WORDPARTRIGHT, SCI_WORDPARTRIGHT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWordPartRightExtend", SCI_WORDPARTRIGHTEXTEND, SCI_WORDPARTRIGHTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciHome", SCI_HOME, SCI_HOME, VT_NULL, VT_NULL, VT_NULL},
    {L"SciHomeExtend", SCI_HOMEEXTEND, SCI_HOMEEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciHomeRectExtend", SCI_HOMERECTEXTEND, SCI_HOMERECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciHomeDisplay", SCI_HOMEDISPLAY, SCI_HOMEDISPLAY, VT_NULL, VT_NULL, VT_NULL},
    {L"SciHomeDisplayExtend", SCI_HOMEDISPLAYEXTEND, SCI_HOMEDISPLAYEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciHomeWrap", SCI_HOMEWRAP, SCI_HOMEWRAP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciHomeWrapExtend", SCI_HOMEWRAPEXTEND, SCI_HOMEWRAPEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVCHome", SCI_VCHOME, SCI_VCHOME, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVCHomeExtend", SCI_VCHOMEEXTEND, SCI_VCHOMEEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVCHomeRectExtend", SCI_VCHOMERECTEXTEND, SCI_VCHOMERECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVCHomeWrap", SCI_VCHOMEWRAP, SCI_VCHOMEWRAP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVCHomeWrapExtend", SCI_VCHOMEWRAPEXTEND, SCI_VCHOMEWRAPEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVCHomeDisplay", SCI_VCHOMEDISPLAY, SCI_VCHOMEDISPLAY, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVCHomeDisplayExtend", SCI_VCHOMEDISPLAYEXTEND, SCI_VCHOMEDISPLAYEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineEnd", SCI_LINEEND, SCI_LINEEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineEndExtended", SCI_LINEENDEXTEND, SCI_LINEENDEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineEndRectExtend", SCI_LINEENDRECTEXTEND, SCI_LINEENDRECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineEndDisplay", SCI_LINEENDDISPLAY, SCI_LINEENDDISPLAY, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineEndDisplayExtend", SCI_LINEENDDISPLAYEXTEND, SCI_LINEENDDISPLAYEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineEndWrap", SCI_LINEENDWRAP, SCI_LINEENDWRAP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineEndWrapExtend", SCI_LINEENDWRAPEXTEND, SCI_LINEENDWRAPEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDocumentStart", SCI_DOCUMENTSTART, SCI_DOCUMENTSTART, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDocumentStartExtend", SCI_DOCUMENTSTARTEXTEND, SCI_DOCUMENTSTARTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDocumentEnd", SCI_DOCUMENTEND, SCI_DOCUMENTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDocumentEndExtend", SCI_DOCUMENTENDEXTEND, SCI_DOCUMENTENDEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciPageUp", SCI_PAGEUP, SCI_PAGEUP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciPageUpExtend", SCI_PAGEUPEXTEND, SCI_PAGEUPEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciPageUpRectExtend", SCI_PAGEUPRECTEXTEND, SCI_PAGEUPRECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciPageDown", SCI_PAGEDOWN, SCI_PAGEDOWN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciPageDownExtend", SCI_PAGEDOWNEXTEND, SCI_PAGEDOWNEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciPageDownRectExtend", SCI_PAGEDOWNRECTEXTEND, SCI_PAGEDOWNRECTEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStutteredPageUp", SCI_STUTTEREDPAGEUP, SCI_STUTTEREDPAGEUP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStutteredPageUpExtend", SCI_STUTTEREDPAGEUPEXTEND, SCI_STUTTEREDPAGEUPEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStutteredPageDown", SCI_STUTTEREDPAGEDOWN, SCI_STUTTEREDPAGEDOWN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStutteredPageDownExtend", SCI_STUTTEREDPAGEDOWNEXTEND, SCI_STUTTEREDPAGEDOWNEXTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDeleteBack", SCI_DELETEBACK, SCI_DELETEBACK, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDeleteBackNotLine", SCI_DELETEBACKNOTLINE, SCI_DELETEBACKNOTLINE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDelWordLeft", SCI_DELWORDLEFT, SCI_DELWORDLEFT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDelWordRight", SCI_DELWORDRIGHT, SCI_DELWORDRIGHT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDelWordRightEnd", SCI_DELWORDRIGHTEND, SCI_DELWORDRIGHTEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDelLineLeft", SCI_DELLINELEFT, SCI_DELLINELEFT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciDelLineRight", SCI_DELLINERIGHT, SCI_DELLINERIGHT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineDelete", SCI_LINEDELETE, SCI_LINEDELETE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineCut", SCI_LINECUT, SCI_LINECUT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineCopy", SCI_LINECOPY, SCI_LINECOPY, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineTranspose", SCI_LINETRANSPOSE, SCI_LINETRANSPOSE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLineDuplicate", SCI_LINEDUPLICATE, SCI_LINEDUPLICATE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciLowerCase", SCI_LOWERCASE, SCI_LOWERCASE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciUpperCase", SCI_UPPERCASE, SCI_UPPERCASE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciCancel", SCI_CANCEL, SCI_CANCEL, VT_NULL, VT_NULL, VT_NULL},
    {L"SciEditToggleOverType", SCI_EDITTOGGLEOVERTYPE, SCI_EDITTOGGLEOVERTYPE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciNewLine", SCI_NEWLINE, SCI_NEWLINE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciFormFeed", SCI_FORMFEED, SCI_FORMFEED, VT_NULL, VT_NULL, VT_NULL},
    {L"SciTab", SCI_TAB, SCI_TAB, VT_NULL, VT_NULL, VT_NULL},
    {L"SciBackTab", SCI_BACKTAB, SCI_BACKTAB, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSelectionDuplicate", SCI_SELECTIONDUPLICATE, SCI_SELECTIONDUPLICATE, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVerticalCenreCaret", SCI_VERTICALCENTRECARET, SCI_VERTICALCENTRECARET, VT_NULL, VT_NULL, VT_NULL},
    {L"SciMoveSelectedLinesUp", SCI_MOVESELECTEDLINESUP, SCI_MOVESELECTEDLINESUP, VT_NULL, VT_NULL, VT_NULL},
    {L"SciMoveSelectedLinesDown", SCI_MOVESELECTEDLINESDOWN, SCI_MOVESELECTEDLINESDOWN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciScrollToStart", SCI_SCROLLTOSTART, SCI_SCROLLTOSTART, VT_NULL, VT_NULL, VT_NULL},
    {L"SciScrollToEnd", SCI_SCROLLTOEND, SCI_SCROLLTOEND, VT_NULL, VT_NULL, VT_NULL},
    {L"SciAssignCmdKey", SCI_ASSIGNCMDKEY, SCI_ASSIGNCMDKEY, VT_NULL, VT_INT, VT_INT},
    {L"SciClearCmdKey", SCI_CLEARCMDKEY, SCI_CLEARCMDKEY, VT_NULL, VT_INT, VT_NULL},
    {L"SciClearAllCmdKeys", SCI_CLEARALLCMDKEYS, SCI_CLEARALLCMDKEYS, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStartRecord", SCI_STARTRECORD, SCI_STARTRECORD, VT_NULL, VT_NULL, VT_NULL},
    {L"SciStopRecord", SCI_STOPRECORD, SCI_STOPRECORD, VT_NULL, VT_NULL, VT_NULL},
    {L"SciVisibleFromDocLine", SCI_VISIBLEFROMDOCLINE, SCI_VISIBLEFROMDOCLINE, VT_INT, VT_INT, VT_NULL},
    {L"SciDocLineFromVisible", SCI_DOCLINEFROMVISIBLE, SCI_DOCLINEFROMVISIBLE, VT_INT, VT_INT, VT_NULL},
    {L"SciShowLines", SCI_SHOWLINES, SCI_SHOWLINES, VT_NULL, VT_INT, VT_INT},
    {L"SciHideLines", SCI_HIDELINES, SCI_HIDELINES, VT_NULL, VT_INT, VT_INT},
    {L"SciGetLineVisible", SCI_GETLINEVISIBLE, SCI_GETLINEVISIBLE, VT_BOOL, VT_INT, VT_NULL},
    {L"SciGetAllLinesVisible", SCI_GETALLLINESVISIBLE, SCI_GETALLLINESVISIBLE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciAllLinesVisible", SCI_GETALLLINESVISIBLE, SCI_GETALLLINESVISIBLE, VT_BOOL, VT_NULL, VT_NULL},
    {L"SciSetFoldLevel", SCI_SETFOLDLEVEL, SCI_SETFOLDLEVEL, VT_NULL, VT_INT, VT_INT},
    {L"SciGetFoldLevel", SCI_GETFOLDLEVEL, SCI_GETFOLDLEVEL, VT_INT, VT_INT, VT_NULL},
    {L"SciSetFoldFlags", SCI_SETFOLDFLAGS, SCI_SETFOLDFLAGS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetLastChild", SCI_GETLASTCHILD, SCI_GETLASTCHILD, VT_INT, VT_INT, VT_INT},
    {L"SciGetFoldParent", SCI_GETFOLDPARENT, SCI_GETFOLDPARENT, VT_INT, VT_INT, VT_NULL},
    {L"SciToggleFold", SCI_TOGGLEFOLD, SCI_TOGGLEFOLD, VT_NULL, VT_INT, VT_NULL},
    {L"SciSetFoldExpanded", SCI_SETFOLDEXPANDED, SCI_SETFOLDEXPANDED, VT_NULL, VT_INT, VT_BOOL},
    {L"SciGetFoldExpanded", SCI_GETFOLDEXPANDED, SCI_GETFOLDEXPANDED, VT_BOOL, VT_INT, VT_NULL},
    {L"SciFoldLine", SCI_FOLDLINE, SCI_FOLDLINE, VT_NULL, VT_INT, VT_INT},
    {L"SciFoldChildren", SCI_FOLDCHILDREN, SCI_FOLDCHILDREN, VT_NULL, VT_INT, VT_INT},
    {L"SciFoldAll", SCI_FOLDALL, SCI_FOLDALL, VT_NULL, VT_INT, VT_NULL},
    {L"SciExpandChildren", SCI_EXPANDCHILDREN, SCI_EXPANDCHILDREN, VT_NULL, VT_INT, VT_INT},
    {L"SciSetAutomaticFold", SCI_SETAUTOMATICFOLD, SCI_SETAUTOMATICFOLD, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetAutomaticFold", SCI_GETAUTOMATICFOLD, SCI_GETAUTOMATICFOLD, VT_INT, VT_NULL, VT_NULL},
    {L"SciAutomaticFold", SCI_SETAUTOMATICFOLD, SCI_GETAUTOMATICFOLD, VT_INT, VT_INT, VT_NULL},
    {L"SciContractedFoldNext", SCI_CONTRACTEDFOLDNEXT, SCI_CONTRACTEDFOLDNEXT, VT_NULL, VT_INT, VT_NULL},
    {L"SciEnsureVisible", SCI_ENSUREVISIBLE, SCI_ENSUREVISIBLE, VT_NULL, VT_INT, VT_NULL},
    {L"SciSetWrapMode", SCI_SETWRAPMODE, SCI_SETWRAPMODE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetWrapMode", SCI_GETWRAPMODE, SCI_GETWRAPMODE, VT_INT, VT_NULL, VT_NULL},
    {L"SciWrapMode", SCI_SETWRAPMODE, SCI_GETWRAPMODE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetWrapVisualFlags", SCI_SETWRAPVISUALFLAGS, SCI_SETWRAPVISUALFLAGS, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetWrapVisualFlags", SCI_GETWRAPVISUALFLAGS, SCI_GETWRAPVISUALFLAGS, VT_INT, VT_NULL, VT_NULL},
    {L"SciWrapVisualFlags", SCI_SETWRAPVISUALFLAGS, SCI_GETWRAPVISUALFLAGS, VT_INT, VT_INT, VT_NULL},
    {L"SciSetWrapVisualFlagsLocation", SCI_SETWRAPVISUALFLAGSLOCATION, SCI_SETWRAPVISUALFLAGSLOCATION, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetWrapVisualFlagsLocation", SCI_GETWRAPVISUALFLAGSLOCATION, SCI_GETWRAPVISUALFLAGSLOCATION, VT_INT, VT_NULL, VT_NULL},
    {L"SciWrapVisualFlagsLocation", SCI_SETWRAPVISUALFLAGSLOCATION, SCI_GETWRAPVISUALFLAGSLOCATION, VT_INT, VT_INT, VT_NULL},
    {L"SciSetWrapIndentMode", SCI_SETWRAPINDENTMODE, SCI_SETWRAPINDENTMODE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetWrapIndentMode", SCI_GETWRAPINDENTMODE, SCI_GETWRAPINDENTMODE, VT_INT, VT_NULL, VT_NULL},
    {L"SciWrapIndentMode", SCI_SETWRAPINDENTMODE, SCI_GETWRAPINDENTMODE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetWrapStartIndent", SCI_SETWRAPSTARTINDENT, SCI_SETWRAPSTARTINDENT, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetWrapStartIndent", SCI_GETWRAPSTARTINDENT, SCI_GETWRAPSTARTINDENT, VT_INT, VT_NULL, VT_NULL},
    {L"SciWrapStartIndent", SCI_SETWRAPSTARTINDENT, SCI_GETWRAPSTARTINDENT, VT_INT, VT_INT, VT_NULL},
    {L"SciSetLayoutCache", SCI_SETLAYOUTCACHE, SCI_SETLAYOUTCACHE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetLayoutCache", SCI_GETLAYOUTCACHE, SCI_GETLAYOUTCACHE, VT_INT, VT_NULL, VT_NULL},
    {L"SciLayoutCache", SCI_SETLAYOUTCACHE, SCI_GETLAYOUTCACHE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetPositionCache", SCI_SETPOSITIONCACHE, SCI_SETPOSITIONCACHE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetPositionCache", SCI_GETPOSITIONCACHE, SCI_GETPOSITIONCACHE, VT_INT, VT_NULL, VT_NULL},
    {L"SciPositionCache", SCI_SETPOSITIONCACHE, SCI_GETPOSITIONCACHE, VT_INT, VT_INT, VT_NULL},
    {L"SciLinesSplit", SCI_LINESSPLIT, SCI_LINESSPLIT, VT_NULL, VT_INT, VT_NULL},
    {L"SciLinesJoin", SCI_LINESJOIN, SCI_LINESJOIN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciWrapCount", SCI_WRAPCOUNT, SCI_WRAPCOUNT, VT_NULL, VT_INT, VT_NULL},
    {L"SciZoomIn", SCI_ZOOMIN, SCI_ZOOMIN, VT_NULL, VT_NULL, VT_NULL},
    {L"SciZoomOut", SCI_ZOOMOUT, SCI_ZOOMOUT, VT_NULL, VT_NULL, VT_NULL},
    {L"SciSetZoom", SCI_SETZOOM, SCI_SETZOOM, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetZoom", SCI_GETZOOM, SCI_GETZOOM, VT_INT, VT_NULL, VT_NULL},
    {L"SciZoom", SCI_SETZOOM, SCI_GETZOOM, VT_INT, VT_INT, VT_NULL},
    {L"SciSetEdgeMode", SCI_SETEDGEMODE, SCI_SETEDGEMODE, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetEdgeMode", SCI_GETEDGEMODE, SCI_GETEDGEMODE, VT_INT, VT_NULL, VT_NULL},
    {L"SciEdgeMode", SCI_SETEDGEMODE, SCI_GETEDGEMODE, VT_INT, VT_INT, VT_NULL},
    {L"SciSetEdgeColumn", SCI_SETEDGECOLUMN, SCI_SETEDGECOLUMN, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetEdgeColumn", SCI_GETEDGECOLUMN, SCI_GETEDGECOLUMN, VT_INT, VT_NULL, VT_NULL},
    {L"SciEdgeColumn", SCI_SETEDGECOLUMN, SCI_GETEDGECOLUMN, VT_INT, VT_INT, VT_NULL},
    {L"SciSetEdgeColour", SCI_SETEDGECOLOUR, SCI_SETEDGECOLOUR, VT_NULL, VT_INT, VT_NULL},
    {L"SciGetEdgeColour", SCI_GETEDGECOLOUR, SCI_GETEDGECOLOUR, VT_INT, VT_NULL, VT_NULL},
    {L"SciEdgeColour", SCI_SETEDGECOLOUR, SCI_GETEDGECOLOUR, VT_INT, VT_INT, VT_NULL},
    {L"SciGetLexer", SCI_GETLEXER, SCI_GETLEXER, VT_INT, VT_NULL, VT_NULL},
    {L"SciColourise", SCI_COLOURISE, SCI_COLOURISE, VT_NULL, VT_INT, VT_INT},
    {L"SciChangeLexerState", SCI_CHANGELEXERSTATE, SCI_CHANGELEXERSTATE, VT_NULL, VT_INT, VT_INT},
    {L"SciSetKeyWords", SCI_SETKEYWORDS, SCI_SETKEYWORDS, VT_NULL, VT_INT, VT_BSTR},
};

BasicScriptObject::BasicScriptObject(void* obj, const std::wstring& path)
    : ICommand(obj)
    , m_refCount(1)
    , m_path(path)
{
}

BasicScriptObject::~BasicScriptObject()
{
}

HRESULT BasicScriptObject::QueryInterface(REFIID riid, void** object)
{
    if (riid == IID_IDispatch)
    {
        *object = static_cast<IDispatch*>(this);
    }
    else
    {
        *object = nullptr;
    }

    if (*object != nullptr)
    {
        AddRef();

        return S_OK;
    }

    return E_NOINTERFACE;
}

ULONG BasicScriptObject::AddRef()
{
    return ::InterlockedIncrement(&m_refCount);
}

ULONG BasicScriptObject::Release()
{
    ULONG oldCount = m_refCount;

    ULONG newCount = ::InterlockedDecrement(&m_refCount);
    if (0 == newCount)
    {
        delete this;
    }

    return oldCount;
}

HRESULT BasicScriptObject::GetTypeInfoCount(UINT* count)
{
    *count = 0;

    return S_OK;
}

HRESULT BasicScriptObject::GetTypeInfo(UINT, LCID, ITypeInfo** typeInfo)
{
    *typeInfo = nullptr;

    return S_OK;
}

// This is where we register procs (or vars)
HRESULT BasicScriptObject::GetIDsOfNames(REFIID /*riid*/,
                                         LPOLESTR* nameList,
                                         UINT      nameCount,
                                         LCID /*lcid*/,
                                         DISPID* idList)
{
    // TODO: find a better way to handle the commands than with this ugly
    // if-else-if monster
    for (UINT i = 0; i < nameCount; i++)
    {
        if (_wcsicmp(nameList[i], L"alert") == 0)
            idList[i] = 1;
        else if (_wcsicmp(nameList[i], L"debugprint") == 0)
            idList[i] = 2;
        else if (_wcsicmp(nameList[i], L"Version") == 0)
            idList[i] = 3;
        else if (_wcsicmp(nameList[i], L"VersionMajor") == 0)
            idList[i] = 4;
        else if (_wcsicmp(nameList[i], L"VersionMinor") == 0)
            idList[i] = 5;
        else if (_wcsicmp(nameList[i], L"VersionMicro") == 0)
            idList[i] = 6;
        else if (_wcsicmp(nameList[i], L"SetInsertionIndex") == 0)
            idList[i] = 100;
        else if (_wcsicmp(nameList[i], L"TabActivateAt") == 0)
            idList[i] = 101;
        else if (_wcsicmp(nameList[i], L"UpdateTab") == 0)
            idList[i] = 102;
        else if (_wcsicmp(nameList[i], L"GetDocIdOfCurrentTab") == 0)
            idList[i] = 103;
        else if (_wcsicmp(nameList[i], L"GetActiveTabIndex") == 0)
            idList[i] = 104;
        else if (_wcsicmp(nameList[i], L"GetTabCount") == 0)
            idList[i] = 105;
        else if (_wcsicmp(nameList[i], L"GetCurrentTitle") == 0)
            idList[i] = 106;
        else if (_wcsicmp(nameList[i], L"GetTitleForTabIndex") == 0)
            idList[i] = 107;
        else if (_wcsicmp(nameList[i], L"GetTitleForDocID") == 0)
            idList[i] = 108;
        else if (_wcsicmp(nameList[i], L"SetCurrentTitle") == 0)
            idList[i] = 109;
        else if (_wcsicmp(nameList[i], L"CloseTab") == 0)
            idList[i] = 110;
        else if (_wcsicmp(nameList[i], L"GetDocIDFromTabIndex") == 0)
            idList[i] = 111;
        else if (_wcsicmp(nameList[i], L"GetDocIDFromPath") == 0)
            idList[i] = 112;
        else if (_wcsicmp(nameList[i], L"GetTabIndexFromDocID") == 0)
            idList[i] = 113;
        else if (_wcsicmp(nameList[i], L"DocumentCount") == 0)
            idList[i] = 114;
        else if (_wcsicmp(nameList[i], L"HasActiveDocument") == 0)
            idList[i] = 115;
        else if (_wcsicmp(nameList[i], L"HasDocumentID") == 0)
            idList[i] = 116;
        else if (_wcsicmp(nameList[i], L"UpdateStatusBar") == 0)
            idList[i] = 117;
        else if (_wcsicmp(nameList[i], L"SetupLexerForLang") == 0)
            idList[i] = 118;
        else if (_wcsicmp(nameList[i], L"DocScrollClear") == 0)
            idList[i] = 119;
        else if (_wcsicmp(nameList[i], L"DocScrollAddLineColor") == 0)
            idList[i] = 120;
        else if (_wcsicmp(nameList[i], L"DocScrollUpdate") == 0)
            idList[i] = 121;
        else if (_wcsicmp(nameList[i], L"DocScrollRemoveLine") == 0)
            idList[i] = 122;
        else if (_wcsicmp(nameList[i], L"GotoLine") == 0)
            idList[i] = 123;
        else if (_wcsicmp(nameList[i], L"Center") == 0)
            idList[i] = 124;
        else if (_wcsicmp(nameList[i], L"GotoBrace") == 0)
            idList[i] = 125;
        else if (_wcsicmp(nameList[i], L"GetTimerID") == 0)
            idList[i] = 126;
        else if (_wcsicmp(nameList[i], L"SetTimer") == 0)
            idList[i] = 127;
        else if (_wcsicmp(nameList[i], L"OpenFile") == 0)
            idList[i] = 128;
        else if (_wcsicmp(nameList[i], L"ReloadTab") == 0)
            idList[i] = 129;
        else if (_wcsicmp(nameList[i], L"SaveCurrentTab") == 0)
            idList[i] = 130;
        else if (_wcsicmp(nameList[i], L"InvalidateState") == 0)
            idList[i] = 131;
        else if (_wcsicmp(nameList[i], L"SaveDoc") == 0)
            idList[i] = 132;
        else if (_wcsicmp(nameList[i], L"UpdateLineNumberWidth") == 0)
            idList[i] = 133;
        else if (_wcsicmp(nameList[i], L"OpenNewTab") == 0)
            idList[i] = 134;
        else if (_wcsicmp(nameList[i], L"GetCurrentLanguage") == 0)
            idList[i] = 135;
        else if (_wcsicmp(nameList[i], L"SetClipboardData") == 0)
            idList[i] = 136;
        else if (_wcsicmp(nameList[i], L"GetClipboardText") == 0)
            idList[i] = 137;
        else if (_wcsicmp(nameList[i], L"GetClipboardHtml") == 0)
            idList[i] = 138;
        else if (_wcsicmp(nameList[i], L"GetKeyState") == 0)
            idList[i] = 139;
        else if (_wcsicmp(nameList[i], L"AddDocAutoCompleteWords") == 0)
            idList[i] = 140;
        else if (_wcsicmp(nameList[i], L"AddLangAutoCompleteWords") == 0)
            idList[i] = 141;
        else if (_wcsicmp(nameList[i], L"PluginPath") == 0)
            idList[i] = 142;
        else if (_wcsicmp(nameList[i], L"ReadSetting") == 0)
            idList[i] = 143;
        else if (_wcsicmp(nameList[i], L"SaveSetting") == 0)
            idList[i] = 144;
        else if (_wcsicmp(nameList[i], L"InvalidateCommand") == 0)
            idList[i] = 145;
        else if (_wcsicmp(nameList[i], L"ExecuteCommand") == 0)
            idList[i] = 146;
        else if (_wcsicmp(nameList[i], L"GetPathForDocID") == 0)
            idList[i] = 147;
        else if (_wcsicmp(nameList[i], L"SciGetTextRange") == 0)
            idList[i] = 900;
        else if (_wcsicmp(nameList[i], L"SciGetCharAt") == 0)
            idList[i] = 901;
        else if (_wcsicmp(nameList[i], L"SciFindText") == 0)
            idList[i] = 902;
        else if (ScintillaCommandsDispId(nameList[i], idList[i]))
            return S_OK;
        else
        {
            return E_FAIL;
        }
    }

    return S_OK;
}

// And this is where they are called from script
HRESULT BasicScriptObject::Invoke(DISPID id,
                                  REFIID /*riid*/,
                                  LCID /*lcid*/,
                                  WORD        flags,
                                  DISPPARAMS* args,
                                  VARIANT*    ret,
                                  EXCEPINFO* /*excp*/,
                                  UINT* /*err*/)
{
    _variant_t dummyRet;
    if (ret)
        ret->vt = VT_EMPTY;
    else
        ret = &dummyRet;

    _variant_t p1;
    _variant_t p2;
    _variant_t p3;
    _variant_t p4;
    switch (id)
    {
        case 1: // alert
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            MessageBox(GetHwnd(), p1.bstrVal, L"Script Alert", MB_OK);
            break;
        case 2: // debugprint
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            CTraceToOutputDebugString::Instance()(L"BowPad : ");
            CTraceToOutputDebugString::Instance()(p1.bstrVal);
            CTraceToOutputDebugString::Instance()(L"\n");
            break;
        case 3: // Version
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            else
            {
                auto sVer    = std::to_string(BP_VERMAJOR) + "." + std::to_string(BP_VERMINOR) + "." + std::to_string(BP_VERMICRO);
                ret->vt      = VT_BSTR;
                ret->bstrVal = _bstr_t(sVer.c_str()).Detach();
            }
            break;
        case 4: // VersionMajor
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt     = VT_INT;
            ret->intVal = BP_VERMAJOR;
            break;
        case 5: // VersionMinor
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt     = VT_INT;
            ret->intVal = BP_VERMINOR;
            break;
        case 6: // VersionMicro
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt     = VT_INT;
            ret->intVal = BP_VERMICRO;
            break;
        case 100: // SetInsertionIndex
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            SetInsertionIndex(p1.intVal);
            break;
        case 101: // TabActivateAt
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            TabActivateAt(p1.intVal);
            break;
        case 102: // UpdateTab
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            UpdateTab(p1.intVal);
            break;
        case 103: // GetDocIdOfCurrentTab
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt     = VT_INT;
            ret->intVal = GetDocIdOfCurrentTab().GetValue();
            break;
        case 104: // GetActiveTabIndex
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt     = VT_INT;
            ret->intVal = GetActiveTabIndex();
            break;
        case 105: // GetTabCount
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt     = VT_INT;
            ret->intVal = GetTabCount();
            break;
        case 106: // GetCurrentTitle
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(GetCurrentTitle().c_str()).Detach();
            break;
        case 107: // GetTitleForTabIndex
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(GetTitleForTabIndex(p1.intVal).c_str()).Detach();
            break;
        case 108: // GetTitleForDocID
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(GetTitleForDocID(DocID(p1.intVal)).c_str()).Detach();
            break;
        case 109: // SetCurrentTitle
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            SetCurrentTitle(p1.bstrVal);
            break;
        case 110: // CloseTab
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BOOL)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BOOL;
            ret->boolVal = CloseTab(p1.intVal, !!p2.boolVal) ? VARIANT_TRUE : VARIANT_FALSE;
            break;
        case 111: // GetDocIDFromTabIndex
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt     = VT_INT;
            ret->intVal = GetDocIDFromTabIndex(p1.intVal).GetValue();
            break;
        case 112: // GetDocIDFromPath
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            ret->vt     = VT_INT;
            ret->intVal = GetDocIDFromPath(p1.bstrVal).GetValue();
            break;
        case 113: // GetTabIndexFromDocID
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt     = VT_INT;
            ret->intVal = GetTabIndexFromDocID(DocID(p1.intVal));
            break;
        case 114: // DocumentCount
            if (flags == DISPATCH_PROPERTYGET)
            {
                ret->lVal = GetDocumentCount();
                ret->vt   = VT_INT;
                return S_OK;
            }
            return DISP_E_TYPEMISMATCH;
        case 115: // HasActiveDocument
            if (flags == DISPATCH_PROPERTYGET)
            {
                ret->boolVal = HasActiveDocument() ? VARIANT_TRUE : VARIANT_FALSE;
                ret->vt      = VT_BOOL;
                return S_OK;
            }
            return DISP_E_TYPEMISMATCH;
        case 116: // HasDocumentID
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BOOL;
            ret->boolVal = HasDocumentID(DocID({p1.intVal})) ? VARIANT_TRUE : VARIANT_FALSE;
            break;
        case 117: // UpdateStatusBar
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BOOL)))
                return DISP_E_TYPEMISMATCH;
            UpdateStatusBar(!!p1.boolVal);
            break;
        case 118: // SetupLexerForLang
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            SetupLexerForLang(CUnicodeUtils::StdGetUTF8(p1.bstrVal));
            // also set the lang for the doc and update the status bar
            GetModActiveDocument().SetLanguage(CUnicodeUtils::StdGetUTF8(p1.bstrVal));
            UpdateStatusBar(true);
            break;
        case 119: // DocScrollClear
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            DocScrollClear(p1.intVal);
            break;
        case 120: // DocScrollAddLineColor
            if (args->cArgs != 3)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[2], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p3, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_UI4)))
                return DISP_E_TYPEMISMATCH;
            DocScrollAddLineColor(p1.intVal, p2.intVal, p3.ulVal);
            break;
        case 121: // DocScrollUpdate
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            DocScrollUpdate();
            break;
        case 122: // DocScrollRemoveLine
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            DocScrollRemoveLine(p1.intVal, p2.intVal);
            break;
        case 123: // GotoLine
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            GotoLine(p1.intVal);
            break;
        case 124: // Center
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            Center(p1.intVal, p2.intVal);
            break;
        case 125: // GotoBrace
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            GotoBrace();
            break;
        case 126: // GetTimerID
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt     = VT_INT;
            ret->intVal = GetTimerID();
            break;
        case 127: // SetTimer
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            SetTimer(GetHwnd(), p1.intVal, p2.intVal, nullptr);
            break;
        case 128: // OpenFile
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_UINT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt     = VT_INT;
            ret->intVal = OpenFile(p1.bstrVal, p2.uintVal);
            break;
        case 129: // ReloadTab
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BOOL;
            ret->boolVal = ReloadTab(p1.intVal, p2.intVal) ? VARIANT_TRUE : VARIANT_FALSE;
            break;
        case 130: // SaveCurrentTab
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BOOL)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BOOL;
            ret->boolVal = SaveCurrentTab(!!p1.boolVal) ? VARIANT_TRUE : VARIANT_FALSE;
            break;
        case 131: // InvalidateState
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            InvalidateUICommand(UI_INVALIDATIONS_PROPERTY, &UI_PKEY_BooleanValue);
            InvalidateUICommand(UI_INVALIDATIONS_PROPERTY, &UI_PKEY_Enabled);
            InvalidateUICommand(UI_INVALIDATIONS_PROPERTY, &UI_PKEY_ItemsSource);
            InvalidateUICommand(UI_INVALIDATIONS_STATE, nullptr);
            break;
        case 132: // SaveDoc
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_BOOL)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BOOL;
            ret->boolVal = SaveDoc(DocID({p1.intVal}), !!p2.boolVal) ? VARIANT_TRUE : VARIANT_FALSE;
            break;
        case 133: // UpdateLineNumberWidth
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            UpdateLineNumberWidth();
            break;
        case 134: // OpenNewTab
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            OpenNewTab();
            break;
        case 135: // GetCurrentLanguage
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(GetCurrentLanguage().c_str()).Detach();
            break;
        case 136: // SetClipboardData
        {
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BOOL;
            ret->boolVal = VARIANT_FALSE;

            CClipboardHelper clipboard;
            if (clipboard.Open(GetHwnd()))
            {
                EmptyClipboard();
                size_t sLen           = wcslen(p1.bstrVal);
                auto   hClipboardData = GlobalAlloc(GMEM_MOVEABLE, (sLen + 1) * sizeof(wchar_t));
                if (hClipboardData)
                {
                    wchar_t* pchData = static_cast<wchar_t*>(GlobalLock(hClipboardData));
                    if (pchData)
                    {
                        wcscpy_s(pchData, sLen + 1, p1.bstrVal);
                        GlobalUnlock(hClipboardData);
                        SetClipboardData(CF_UNICODETEXT, hClipboardData);
                    }
                }
                auto sHtmlFragment = CUnicodeUtils::StdGetUTF8(p2.bstrVal);
                if (!sHtmlFragment.empty())
                {
                    std::string header = "Version:0.9\r\nStartHTML:<<<<<<<1\r\nEndHTML:<<<<<<<2\r\nStartFragment:<<<<<<<3\r\nEndFragment:<<<<<<<4\r\nStartSelection:<<<<<<<3\r\nEndSelection:<<<<<<<3\r\n";
                    std::string pre    = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\r\n<HTML><HEAD></HEAD>\r\n<BODY>\r\n<!--StartFragment-->";
                    std::string post   = "<!--EndFragment--></BODY></HTML>";

                    std::string sHtml     = header;
                    int         startHtml = static_cast<int>(sHtml.length());
                    sHtml += pre;
                    int startFragment = static_cast<int>(sHtml.length());
                    sHtml += sHtmlFragment;
                    int endFragment = static_cast<int>(sHtml.length());
                    sHtml += post;
                    int endHtml = static_cast<int>(sHtml.length());

                    // replace back offsets
                    SearchReplace(sHtml, "<<<<<<<1", CStringUtils::Format("%08d", startHtml));
                    SearchReplace(sHtml, "<<<<<<<2", CStringUtils::Format("%08d", endHtml));
                    SearchReplace(sHtml, "<<<<<<<3", CStringUtils::Format("%08d", startFragment));
                    SearchReplace(sHtml, "<<<<<<<4", CStringUtils::Format("%08d", endFragment));

                    hClipboardData = GlobalAlloc(GMEM_MOVEABLE, (sHtml.size() + 1) * sizeof(char));
                    if (hClipboardData)
                    {
                        char* pchData = static_cast<char*>(GlobalLock(hClipboardData));
                        if (pchData)
                        {
                            strcpy_s(pchData, sHtml.size() + 1, sHtml.c_str());
                            GlobalUnlock(hClipboardData);
                            SetClipboardData(CF_HTML, hClipboardData);
                        }
                    }
                }
            }
        }
        break;
        case 137: // GetClipboardText
        {
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt = VT_BSTR;
            CClipboardHelper clipboard;
            if (clipboard.Open(GetHwnd()))
            {
                HANDLE hData = GetClipboardData(CF_UNICODETEXT);
                if (hData)
                {
                    LPCWSTR lptstr = static_cast<LPCWSTR>(GlobalLock(hData));
                    OnOutOfScope(
                        GlobalUnlock(hData););
                    if (lptstr != nullptr)
                    {
                        ret->vt      = VT_BSTR;
                        ret->bstrVal = _bstr_t(lptstr).Detach();
                        break;
                    }
                }
            }
            ret->bstrVal = _bstr_t(L"").Detach();
        }
        break;
        case 138: // GetClipboardHtml
        {
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt = VT_BSTR;
            CClipboardHelper clipboard;
            if (clipboard.Open(GetHwnd()))
            {
                HANDLE hData = GetClipboardData(CF_HTML);
                if (hData)
                {
                    LPCSTR lptstr = static_cast<LPCSTR>(GlobalLock(hData));
                    OnOutOfScope(
                        GlobalUnlock(hData););
                    if (lptstr != nullptr)
                    {
                        ret->vt      = VT_BSTR;
                        ret->bstrVal = _bstr_t(CUnicodeUtils::StdGetUnicode(lptstr).c_str()).Detach();
                        break;
                    }
                }
            }
            ret->bstrVal = _bstr_t(L"").Detach();
        }
        break;
        case 139: // GetKeyState
        {
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BOOL;
            ret->boolVal = (GetKeyState(p1.intVal) & 0x8000) != 0 ? VARIANT_TRUE : VARIANT_FALSE;
        }
        break;
        case 140: // AddDocAutoCompleteWords
        {
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_UINT)))
                return DISP_E_TYPEMISMATCH;
            std::vector<std::wstring>               vec;
            std::map<std::string, AutoCompleteType> words;
            stringtok(vec, p2.bstrVal, true, L" ", false);
            for (const auto& word : vec)
                words[CUnicodeUtils::StdGetUTF8(word)] = AutoCompleteType::Code;
            AddAutoCompleteWords(DocID(p1.intVal), std::move(words));
        }
        break;
        case 141: // AddLangAutoCompleteWords
        {
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            std::vector<std::wstring>               vec;
            std::map<std::string, AutoCompleteType> words;
            stringtok(vec, p2.bstrVal, true, L" ", false);
            for (const auto& word : vec)
                words[CUnicodeUtils::StdGetUTF8(word)] = AutoCompleteType::Code;
            AddAutoCompleteWords(CUnicodeUtils::StdGetUTF8(p1.bstrVal), std::move(words));
        }
        break;
        case 142: // PluginPath
        {
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(m_path.c_str()).Detach();
        }
        break;
        case 143: // ReadSetting
        {
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            auto val     = CIniSettings::Instance().GetString(CPathUtils::GetFileName(m_path).c_str(), p1.bstrVal, L"");
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(val).Detach();
        }
        break;
        case 144: // SaveSetting
        {
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            CIniSettings::Instance().SetString(CPathUtils::GetFileName(m_path).c_str(), p1.bstrVal, p2.bstrVal);
        }
        break;
        case 145: // InvalidateCommand
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            InvalidateUICommand(p1.intVal, UI_INVALIDATIONS_PROPERTY, &UI_PKEY_BooleanValue);
            InvalidateUICommand(p1.intVal, UI_INVALIDATIONS_PROPERTY, &UI_PKEY_Enabled);
            InvalidateUICommand(p1.intVal, UI_INVALIDATIONS_PROPERTY, &UI_PKEY_ItemsSource);
            InvalidateUICommand(p1.intVal, UI_INVALIDATIONS_STATE, nullptr);
            break;
        case 146: // ExecuteCommand
        {
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ICommand* pCmd = CCommandHandler::Instance().GetCommand(p1.intVal);
            if (pCmd)
                pCmd->Execute();
        }
        break;
        case 147: // GetPathForDocID
        {
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(GetDocumentFromID(DocID(p1.intVal)).m_path.c_str()).Detach();
        }
        break;
        case 900: // SciGetTextRange
            if (args->cArgs != 2)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(CUnicodeUtils::StdGetUnicode(GetTextRange(p1.intVal, p2.intVal)).c_str()).Detach();
            break;
        case 901: // SciGetCharAt
        {
            if (args->cArgs != 1)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            char cbuf[3] = {0};
            cbuf[0]      = static_cast<char>(Scintilla().CharAt(p1.intVal));
            ret->vt      = VT_BSTR;
            ret->bstrVal = _bstr_t(CUnicodeUtils::StdGetUnicode(cbuf).c_str()).Detach();
        }
        break;
        case 902: // SciFindText
        {
            if (args->cArgs != 4)
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[3], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p2, &args->rgvarg[2], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p3, &args->rgvarg[1], VARIANT_ALPHABOOL, VT_INT)))
                return DISP_E_TYPEMISMATCH;
            if (FAILED(VariantChangeType(&p4, &args->rgvarg[0], VARIANT_ALPHABOOL, VT_BSTR)))
                return DISP_E_TYPEMISMATCH;
            Sci_TextToFind ttf = {0};
            ttf.chrg.cpMin     = p2.intVal;
            ttf.chrg.cpMax     = p3.intVal;
            std::string sText  = CUnicodeUtils::StdGetUTF8(p4.bstrVal);
            ttf.lpstrText      = sText.c_str();
            auto sret          = Scintilla().FindText(static_cast<Scintilla::FindOption>(p1.intVal), &ttf);

            SAFEARRAYBOUND sabounds{};
            sabounds.lLbound   = 0;
            sabounds.cElements = 2;
            SAFEARRAY* psArray = SafeArrayCreate(VT_VARIANT, 1, &sabounds);

            if (psArray != nullptr)
            {
                VARIANT* pInteger = nullptr;
                SafeArrayAccessData(psArray, reinterpret_cast<void**>(&pInteger));
                pInteger[0].intVal = sret >= 0 ? ttf.chrgText.cpMin : -1;
                pInteger[0].vt     = VT_INT;
                pInteger[1].intVal = sret >= 0 ? ttf.chrgText.cpMax : -1;
                pInteger[1].vt     = VT_INT;
                SafeArrayUnaccessData(psArray);

                ret->vt     = VT_ARRAY | VT_VARIANT;
                ret->parray = psArray;
            }
        }
        break;
        default:
            return ScintillaCommandInvoke(id, flags, args, ret);
    }

    return S_OK;
}

bool BasicScriptObject::ScintillaCommandsDispId(wchar_t* name, DISPID& id)
{
    // start with a disp id of 1000 for the Scintilla commands
    int index = 1000;
    for (const auto& cmd : g_scintillaCmd)
    {
        if (_wcsicmp(name, cmd.functionName) == 0)
        {
            id = index;
            return true;
        }
        ++index;
    }
    return false;
}

HRESULT BasicScriptObject::ScintillaCommandInvoke(DISPID id, WORD flags, DISPPARAMS* args, VARIANT* ret) const
{
    size_t vectIndex = id - 1000LL;
    if (vectIndex < std::size(g_scintillaCmd))
    {
        _variant_t p1;
        _variant_t p2;

        const auto& cmd = g_scintillaCmd[vectIndex];
        // cmd(p1, p2);
        if ((cmd.p2 != VT_NULL) || (cmd.retVal == VT_BSTR))
        {
            if ((args->cArgs != 2) && (cmd.retVal != VT_BSTR))
                return DISP_E_BADPARAMCOUNT;
            if (cmd.p2 != VT_NULL)
            {
                if (FAILED(VariantChangeType(&p1, &args->rgvarg[1], VARIANT_ALPHABOOL, cmd.p1)))
                    return DISP_E_TYPEMISMATCH;
                if (FAILED(VariantChangeType(&p2, &args->rgvarg[0], VARIANT_ALPHABOOL, cmd.p2)))
                    return DISP_E_TYPEMISMATCH;
            }
            else
            {
                if (cmd.p1 == VT_NULL)
                {
                    p1.vt     = VT_INT;
                    p1.intVal = 0;
                }
                else if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, cmd.p1)))
                    return DISP_E_TYPEMISMATCH;
            }
            if (cmd.p2 == VT_BSTR)
            {
                ret->vt     = VT_INT;
                ret->intVal = static_cast<int>(Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd), p1.intVal, reinterpret_cast<sptr_t>(CUnicodeUtils::StdGetUTF8(p2.bstrVal).c_str())));
                return VariantChangeType(ret, ret, VARIANT_ALPHABOOL, cmd.retVal);
            }
            else if ((cmd.p2 == VT_NULL) && (cmd.retVal == VT_BSTR))
            {
                // return value is a string
                auto len = Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd), p1.intVal);
                auto buf = std::make_unique<char[]>(len + 1);
                Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd), cmd.p1 == VT_NULL ? len : p1.intVal, reinterpret_cast<sptr_t>(buf.get()));
                buf[len]     = 0;
                ret->vt      = VT_BSTR;
                ret->bstrVal = _bstr_t(CUnicodeUtils::StdGetUnicode(buf.get()).c_str()).Detach();
                return S_OK;
            }
            else
            {
                ret->vt     = VT_INT;
                ret->intVal = static_cast<int>(Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd), p1.intVal, p2.intVal));
                return VariantChangeType(ret, ret, VARIANT_ALPHABOOL, cmd.retVal);
            }
        }
        // cmd(p1); or as a set property: cmd = p1;
        else if ((cmd.p1 != VT_NULL) && (flags != DISPATCH_PROPERTYGET))
        {
            if ((args->cArgs != 1))
                return DISP_E_BADPARAMCOUNT;
            if (FAILED(VariantChangeType(&p1, &args->rgvarg[0], VARIANT_ALPHABOOL, cmd.p1)))
                return DISP_E_TYPEMISMATCH;
            if (cmd.p1 == VT_BSTR)
            {
                // if the one argument is a string, pass it as the second param to Scintilla().Call
                ret->vt     = VT_INT;
                ret->intVal = static_cast<int>(Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd), 0, reinterpret_cast<sptr_t>(CUnicodeUtils::StdGetUTF8(p1.bstrVal).c_str())));
                return VariantChangeType(ret, ret, VARIANT_ALPHABOOL, cmd.retVal);
            }
            else
            {
                ret->vt     = VT_INT;
                ret->intVal = static_cast<int>(Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd), p1.intVal));
                return VariantChangeType(ret, ret, VARIANT_ALPHABOOL, cmd.retVal);
            }
        }
        else
        {
            // no parameters, simple function call or fetching a property
            if (args->cArgs != 0)
                return DISP_E_BADPARAMCOUNT;
            if (cmd.retVal == VT_BSTR)
            {
                // return value is a string
                auto len = Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd));
                auto buf = std::make_unique<char[]>(len + 1);
                Scintilla().Call(static_cast<Scintilla::Message>(cmd.cmd), len, reinterpret_cast<sptr_t>(buf.get()));
                buf[len]     = 0;
                ret->vt      = VT_BSTR;
                ret->bstrVal = _bstr_t(CUnicodeUtils::StdGetUnicode(buf.get()).c_str()).Detach();
                return S_OK;
            }
            ret->vt     = VT_INT;
            ret->intVal = static_cast<int>(Scintilla().Call(flags == DISPATCH_PROPERTYGET ? static_cast<Scintilla::Message>(cmd.cmdGet) : static_cast<Scintilla::Message>(cmd.cmd)));
            return VariantChangeType(ret, ret, VARIANT_ALPHABOOL, cmd.retVal);
        }
    }
    return DISP_E_MEMBERNOTFOUND;
}
