/*

MIT License

Copyright (c) 2017 Sean Ross-Ross

See License in the root of this repo.

*/

// This file was automatically generated by lister-gen

package v1alpha1

import (
	v1alpha1 "github.com/srossross/k8s-test-controller/pkg/apis/tester/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TestTemplateLister helps list TestTemplates.
type TestTemplateLister interface {
	// List lists all TestTemplates in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.TestTemplate, err error)
	// TestTemplates returns an object that can list and get TestTemplates.
	TestTemplates(namespace string) TestTemplateNamespaceLister
	TestTemplateListerExpansion
}

// testTemplateLister implements the TestTemplateLister interface.
type testTemplateLister struct {
	indexer cache.Indexer
}

// NewTestTemplateLister returns a new TestTemplateLister.
func NewTestTemplateLister(indexer cache.Indexer) TestTemplateLister {
	return &testTemplateLister{indexer: indexer}
}

// List lists all TestTemplates in the indexer.
func (s *testTemplateLister) List(selector labels.Selector) (ret []*v1alpha1.TestTemplate, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.TestTemplate))
	})
	return ret, err
}

// TestTemplates returns an object that can list and get TestTemplates.
func (s *testTemplateLister) TestTemplates(namespace string) TestTemplateNamespaceLister {
	return testTemplateNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TestTemplateNamespaceLister helps list and get TestTemplates.
type TestTemplateNamespaceLister interface {
	// List lists all TestTemplates in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.TestTemplate, err error)
	// Get retrieves the TestTemplate from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.TestTemplate, error)
	TestTemplateNamespaceListerExpansion
}

// testTemplateNamespaceLister implements the TestTemplateNamespaceLister
// interface.
type testTemplateNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all TestTemplates in the indexer for a given namespace.
func (s testTemplateNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.TestTemplate, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.TestTemplate))
	})
	return ret, err
}

// Get retrieves the TestTemplate from the indexer for a given namespace and name.
func (s testTemplateNamespaceLister) Get(name string) (*v1alpha1.TestTemplate, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("testtemplate"), name)
	}
	return obj.(*v1alpha1.TestTemplate), nil
}
