/*

MIT License

Copyright (c) 2017 Sean Ross-Ross

See License in the root of this repo.

*/

// This file was automatically generated by informer-gen

package externalversions

import (
	"fmt"
	v1alpha1 "github.com/srossross/k8s-test-controller/pkg/apis/tester/v1alpha1"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=Srossross, Version=V1alpha1
	case v1alpha1.SchemeGroupVersion.WithResource("testruns"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Srossross().V1alpha1().TestRuns().Informer()}, nil
	case v1alpha1.SchemeGroupVersion.WithResource("testtemplates"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Srossross().V1alpha1().TestTemplates().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
