---
title: Community Experts Program
status: new
---

# Calling for Community Experts

Interested in joining the Material for MkDocs team as a Community Expert?
We're on the lookout for individuals who are passionate about supporting our
awesome community. In return for your valuable contributions, time, and
insights, __you'll gain free access to the Insiders edition__.

## Why we need you

As our project and community continue to grow, so do the questions and needs of
our users on our discussion board. Our discussion board is a vital part of our
project, serving as a hub for our community to connect and a valuable knowledge
base to complement our documentation.

We're eager to keeping it well-maintained, organized, easy to search and address
all queries which is why we need extra hands to keep up with the demand.

That's why we're building a team of Community Experts!

## Your role

As a Community Expert, your role primarily involves active participation on
our [discussion board], where we'd expect you to be:

- Answering discussions to help users with their questions
- Providing guidance regarding implementations
- Sharing insights into customizations and workarounds
- Optimizing searchability by adjusting discussion titles with relevant keywords

## Your benefits

Here is a list of the benefits we offer to our Community Experts:

-   __Free access to Material for MkDocs Insiders__ – Exclusive Access to all of
    our Material for MkDocs Insiders features for _non-commercial use_.[^1]

-   __Close communication with the team__ – Stay connected with us through various
    channels, including calls and internal project management tools.

-   __GitHub profile boost__ – Enhance your GitHub profile's visibility and
    credibility as your activity increases, earning you valuable badges that can
    enhance your credibility.

  [^1]:
    Access to Insiders is granted to your primary account, i.e., the account
    with which you're contributing to the project. It cannot be transferred to
    another account. Additionally, it cannot be used for commercial purposes.

## Your knowledge & skills

To be a successful Community Expert, your skills should include the following:

-   __Material and MkDocs allrounder__ – You have an understanding of Material
    for MkDocs and the MkDocs ecosystem, including many of its extensions and
    plugins.

-   __Great communicator__ – You enjoy helping others in a productive,
    constructive and friendly manner and use inclusive and welcoming language.

-   __Independent worker__ – You are self-motivated, stay up-to-date with
    project developments, regularly check the discussion board, and respond to
    notifications in reasonable time.

  [discussion board]: https://github.com/squidfunk/mkdocs-material/discussions
  [documentation]: https://squidfunk.github.io/mkdocs-material/
  [contribution guides]: ../contributing/index.md

## Your time commitment

We don't require a fixed number of hours each week; instead, we ask for a
minimum of __five answered discussions per month[^2]__, which amounts to
slightly more than one per week. Your active interaction within the community is
highly valued.

To do this effectively, it's best to regularly check the discussion board to see
where you can offer help. The time you invest may vary depending on the
complexity of the topics and questions.

Upon joining, you'll receive access to the Insiders' edition for as long as you
continue to assist us. Access will be renewed every three months, allowing you
the flexibility to continue your contributions or take a break as needed.

  [^2]:
    An answered discussion is a collaborative interaction where knowledge and
    expertise are shared, resulting in resolutions or clarifications that benefit
    the user and our entire community. In essence, it embodies the spirit of
    cooperation and support within our community, highlighting the power of
    collective wisdom and the willingness to assist and uplift one another.

## Ready to get started?

Since we have a limited number of seats for these roles[^3], we would like to
get to know you before you become one of our Community Experts. Here's how to
get started:

  [^3]:
    Please note that we're currently limiting the number of seats on the
    Community Experts program to three. We will update this page when we'll
    expand the team, which is when we'll be accepting new applications.

### Step 1: Get in touch

Send us an email introducing yourself, sharing a bit about your background, and
include a link to your GitHub profile. Additionally, provide links to three
previous discussions you've answered on the discussion board, where you've
assisted another community member.

Please use the following email template to reach out to us at
community@squidfunk.com:

```
Subject: Community Expert

Intro: Tell us a bit about yourself.
  - Name:
  - Background:
  - Profession:
  - GitHub profile:

Answered discussions
  - Link 1:
  - Link 2:
  - Link 3:
```

### Step 2: Evaluation

After receiving and reviewing your application, we will get in touch with you
to discuss everything you need to know to get started. If you get selected, we
will set you up as a collaborator and provide you immediate access to the
Insiders edition for three months.

### Step 3: Dive in

Let's get started! You can actively begin participating in five discussions per
month. We trust you to take the lead, and we won't do strict monitoring. Simply
ensure that you are consistently listed on the _Most Helpful_ list, located on
the discussion board's left side, under the categories.
---

__Ready to join us?__

Sounds good? Let's give it a try!
