const path = require('path')
const exclusionList = require('metro-config/src/defaults/exclusionList')
const defaults = require('metro-config/src/defaults/defaults')
const escape = require('escape-string-regexp')
const pak = require('../package.json')

const root = path.resolve(__dirname, '..')

const modules = Object.keys({
  ...pak.peerDependencies
})

module.exports = {
  projectRoot: __dirname,
  watchFolders: [root],

  // We need to make sure that only one version is loaded for peerDependencies
  // So we blocklist them at the root, and alias them to the versions in example's node_modules
  resolver: {
    assetExts: defaults.assetExts.concat(['sjson', 'tflite', 'txt']),
    blockList: exclusionList(
      modules.map(
        (m) =>
          new RegExp(`^${escape(path.join(root, 'node_modules', m))}\\/.*$`)
      )
    ),

    extraNodeModules: modules.reduce((acc, name) => {
      acc[name] = path.join(__dirname, 'node_modules', name)
      return acc
    }, {})
  },

  transformer: {
    getTransformOptions: async () => ({
      transform: {
        experimentalImportSupport: false,
        inlineRequires: true
      }
    })
  }
}
