import type { Meta, StoryObj } from '@storybook/react'

import { AUTH_STATUS_FIXTURE_AUTHED, CLIENT_CAPABILITIES_FIXTURE } from '@sourcegraph/cody-shared'
import { App } from './App'
import { VSCodeWebview } from './storybook/VSCodeStoryDecorator'
import { View } from './tabs'
import type { VSCodeWrapper } from './utils/VSCodeApi'

const meta: Meta<typeof App> = {
    title: 'cody/App',
    component: App,
    decorators: [story => <div style={{ height: '80vh' }}> {story()} </div>, VSCodeWebview],
}

export default meta

export const Simple: StoryObj<typeof meta> = {
    render: () => <App vscodeAPI={dummyVSCodeAPI} />,
}

const dummyVSCodeAPI: VSCodeWrapper = {
    onMessage: cb => {
        // Send initial message so that the component is fully rendered.
        cb({
            type: 'config',
            config: {
                serverEndpoint: 'https://example.com',
                uiKindIsWeb: false,
                experimentalNoodle: false,
                smartApply: false,
                hasEditCapability: false,
            },
            clientCapabilities: CLIENT_CAPABILITIES_FIXTURE,
            authStatus: {
                ...AUTH_STATUS_FIXTURE_AUTHED,
                displayName: 'Tim Lucas',
                avatarURL: 'https://avatars.githubusercontent.com/u/153?v=4',
                authenticated: true,
                hasVerifiedEmail: true,
                requiresVerifiedEmail: false,
                endpoint: 'https://example.com',
            },
            userProductSubscription: null,
            configFeatures: { attribution: true, chat: true, serverSentModels: true },
            workspaceFolderUris: [],
            isDotComUser: true,
        })
        if (firstTime) {
            cb({ type: 'view', view: View.Chat })
            firstTime = false
        }
        return () => {}
    },
    postMessage: () => {},
    getState: () => ({}),
    setState: () => {},
}

let firstTime = true
