# Keyboard Shortcuts

Cody offers an extensive set of default key bindings (keyboard shortcuts) to make it easy for you to perform various actions using the keyboard. You can easily update these bindings in the `Keyboard Shortcuts editor`, which you can access by clicking on the **Keyboard Shortcuts** icon in the Cody sidebar under `**SETTINGS AND SUPPORT**`.

This feature can be particularly useful if the default key bindings conflict with your current or preferred key bindings.

## Keyboard Shortcuts Editor

The Keyboard Shortcuts editor allows you to easily update the key bindings for any of the Cody commands. To open the `Keyboard Shortcuts Editor`:
1. Open the Cody sidebar and expand the `**SETTINGS AND SUPPORT**` section.
2. Click on the `**Keyboard Shortcuts**` icon.

## Custom Commands

![editor](images/keyboard_editor.png)

You have the option to assign key bindings (keyboard shortcuts) to individual custom commands:
1. In the Cody sidebar under `**SETTINGS AND SUPPORT**`, click on the `**Keyboard Shortcuts**` icon to open the Keyboard Shortcuts editor.
2. Search for `cody.command.custom.{CUSTOM_COMMAND_NAME}`. 
3. Replace `{CUSTOM_COMMAND_NAME}` with the name or key of your custom command, for example, `cody.command.custom.commit`.
4. Click on the `+` icon next to the command to assign a custom keybinding for your custom command.

For more information on keyboard settings in VS Code, please refer to the official documentation on [Key Bindings for Visual Studio Code](https://code.visualstudio.com/docs/getstarted/keybindings#_keyboard-shortcuts-editor).

