/// <reference types="@types/bun" />
import { beforeEach, describe, expect, it } from 'bun:test'
import { type Noxide, load } from '..'

describe('noxide config', () => {
    let nox: Noxide
    beforeEach(() => {
        nox = load()!
    })

    it('can load ca certs', async () => {
        const certs = nox.config.caCerts()
        expect(certs).not.toBeEmpty()
    })

    it('can combine bundled certs', async () => {
        const certs = nox.config
            .caCerts([...examplePems, badPem])
            .map(c => c.replaceAll('\n', '').trim())
        expect(certs).not.toContain(badPem.replaceAll('\n', '').trim())
        expect(certs).toContain(examplePems[0].replaceAll('\n', '').trim())
        expect(certs).toContain(examplePems[1].replaceAll('\n', '').trim())
    })

    it('can load system proxy', async () => {})
})

const examplePems = [
    `
-----BEGIN CERTIFICATE-----
MIICMzCCAZygAwIBAgIJALiPnVsvq8dsMA0GCSqGSIb3DQEBBQUAMFMxCzAJBgNV
BAYTAlVTMQwwCgYDVQQIEwNmb28xDDAKBgNVBAcTA2ZvbzEMMAoGA1UEChMDZm9v
MQwwCgYDVQQLEwNmb28xDDAKBgNVBAMTA2ZvbzAeFw0xMzAzMTkxNTQwMTlaFw0x
ODAzMTgxNTQwMTlaMFMxCzAJBgNVBAYTAlVTMQwwCgYDVQQIEwNmb28xDDAKBgNV
BAcTA2ZvbzEMMAoGA1UEChMDZm9vMQwwCgYDVQQLEwNmb28xDDAKBgNVBAMTA2Zv
bzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAzdGfxi9CNbMf1UUcvDQh7MYB
OveIHyc0E0KIbhjK5FkCBU4CiZrbfHagaW7ZEcN0tt3EvpbOMxxc/ZQU2WN/s/wP
xph0pSfsfFsTKM4RhTWD2v4fgk+xZiKd1p0+L4hTtpwnEw0uXRVd0ki6muwV5y/P
+5FHUeldq+pgTcgzuK8CAwEAAaMPMA0wCwYDVR0PBAQDAgLkMA0GCSqGSIb3DQEB
BQUAA4GBAJiDAAtY0mQQeuxWdzLRzXmjvdSuL9GoyT3BF/jSnpxz5/58dba8pWen
v3pj4P3w5DoOso0rzkZy2jEsEitlVM2mLSbQpMM+MUVQCQoiG6W9xuCFuxSrwPIS
pAqEAuV4DNoxQKKWmhVv+J0ptMWD25Pnpxeq5sXzghfJnslJlQND
-----END CERTIFICATE-----
`.trim(),
    `-----BEGIN CERTIFICATE-----
MIIDDTCCAfWgAwIBAgIUY7AyEt6vyLf/eTZ8jaCMYr1nkRAwDQYJKoZIhvcNAQEL
BQAwNjESMBAGA1UEAwwJU2ltcGxlIENBMRMwEQYDVQQKDApTaW1wbGUgT3JnMQsw
CQYDVQQGEwJVUzAeFw0yNDExMTExMDUzMzhaFw0zNDExMDkxMDUzMzhaMDYxEjAQ
BgNVBAMMCVNpbXBsZSBDQTETMBEGA1UECgwKU2ltcGxlIE9yZzELMAkGA1UEBhMC
VVMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDQ6m2a042Xb55gfagv
9PmypKgbvIAonaPAu4wkspk4rdPMRmDfE1UqyhUJm4lnXpjm+BBJubESXNGl7ODA
FXWiv1gH6XVRPUUgIJlPdVKyKinJv55SW5XEI2ruFsgOQTVEXsuVhb7cj7MJI41v
F5hDzjMoTdkk+mDCnxOrTvb5Bf1od6FeKNO5UUxnkj8IyIzgqZI0Prah7xtc9ezs
sCX7CGvIj++0eUx88+X/5MW7pZ24nsb2J7+SaKidhbADITAm73oy4NAP81/HdaRa
E+a3s8aRXgPJjsGYhKKRxszAsma+dC/dIRCSnZp0GTMo3SUmgmlUdgHTgHguUp7i
vMXFAgMBAAGjEzARMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEB
AFfm397jOFVgXL2fqS7PoDKVSq2QceWXy+w+ifhjD2UE93ebgoOZrRZ/kIJXaiTO
0lLYgZsuigVTsq30cXGm2rgSgmNuD2F/W2sd8lkpNS1BKxwrGzP4jnrZatntCcMs
xuDT7zFhXNpUeqPGBWq2JDYKSGJXbKjpoD8ZywYwiouiRgATagxYhCfwRqPs3e4m
bpIUGI0ZmZ/LyMMGrcIOYGh/yN/snSAlnIyfRbDOp0nGcT/2jGAS4EEkkfEqIIvO
Zib7q0oT9J9oJYuwC6kPPS/s9zVR1Sb9xRNO+ZpDaWsPEJ20Hz+XcHbz6vV78uhL
MHu3SiEnB0vRc/L3O1ShiKo=
-----END CERTIFICATE-----`.trim(),
]

const badPem = `
-----BEGIN RSA PRIVATE KEY-----
MIICWgIBAAKBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
-----END RSA PRIVATE KEY-----
`
