/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.util;

import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public class Configuration {
    public static final String DIAGNOSTIC_KIND_PROCESSOR_OPTION = "diagnosticKind";
    public static final String VERBOSE_PROCESSOR_OPTION = "verbose";
    public static final String METHOD_CONSTRAINTS_SUPPORTED_PROCESSOR_OPTION = "methodConstraintsSupported";
    public static final Diagnostic.Kind DEFAULT_DIAGNOSTIC_KIND = Diagnostic.Kind.ERROR;
    private final Diagnostic.Kind diagnosticKind;
    private final boolean verbose;
    private final boolean methodConstraintsSupported;

    public Configuration(Map<String, String> options, Messager messager) {
        this.diagnosticKind = this.getDiagnosticKindOption(options, messager);
        this.verbose = this.getVerboseOption(options, messager);
        this.methodConstraintsSupported = this.getMethodConstraintsSupportedOption(options);
    }

    public Diagnostic.Kind getDiagnosticKind() {
        return this.diagnosticKind;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean methodConstraintsSupported() {
        return this.methodConstraintsSupported;
    }

    private Diagnostic.Kind getDiagnosticKindOption(Map<String, String> options, Messager messager) {
        String diagnosticKindFromOptions = options.get(DIAGNOSTIC_KIND_PROCESSOR_OPTION);
        if (diagnosticKindFromOptions != null) {
            try {
                return Diagnostic.Kind.valueOf(diagnosticKindFromOptions);
            }
            catch (IllegalArgumentException e) {
                messager.printMessage(Diagnostic.Kind.WARNING, String.format(Locale.ROOT, "The given value %1$s is no valid diagnostic kind. %2$s will be used.", new Object[]{diagnosticKindFromOptions, DEFAULT_DIAGNOSTIC_KIND}));
            }
        }
        return DEFAULT_DIAGNOSTIC_KIND;
    }

    private boolean getVerboseOption(Map<String, String> options, Messager messager) {
        boolean theValue = Boolean.parseBoolean(options.get(VERBOSE_PROCESSOR_OPTION));
        if (theValue) {
            messager.printMessage(Diagnostic.Kind.NOTE, String.format(Locale.ROOT, "Verbose reporting is activated. Some processing information will be displayed using diagnostic kind %1$s.", new Object[]{Diagnostic.Kind.NOTE}));
        }
        return theValue;
    }

    private boolean getMethodConstraintsSupportedOption(Map<String, String> options) {
        String methodConstraintsSupported = options.get(METHOD_CONSTRAINTS_SUPPORTED_PROCESSOR_OPTION);
        if (methodConstraintsSupported == null) {
            return true;
        }
        return Boolean.parseBoolean(methodConstraintsSupported);
    }
}

