/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationParametersSizeLengthCheck
extends AnnotationParametersAbstractCheck {
    public AnnotationParametersSizeLengthCheck(AnnotationApiHelper annotationApiHelper) {
        super(annotationApiHelper, "javax.validation.constraints.Size", "org.hibernate.validator.constraints.Length");
    }

    @Override
    protected Set<ConstraintCheckIssue> doCheck(Element element, AnnotationMirror annotation) {
        Integer min = this.annotationApiHelper.getAnnotationValue(annotation, "min") != null ? (Integer)this.annotationApiHelper.getAnnotationValue(annotation, "min").getValue() : 0;
        Integer max = this.annotationApiHelper.getAnnotationValue(annotation, "max") != null ? (Integer)this.annotationApiHelper.getAnnotationValue(annotation, "max").getValue() : Integer.MAX_VALUE;
        if (min < 0 || max < 0 || min > max) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "INVALID_SIZE_LENGTH_ANNOTATION_PARAMETERS", new Object[0]));
        }
        return Collections.emptySet();
    }
}

