/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.hibernate.validator.ap.internal.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class StaticCheck
extends AbstractConstraintCheck {
    @Override
    public Set<ConstraintCheckIssue> checkField(VariableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, "STATIC_FIELDS_MAY_NOT_BE_ANNOTATED");
    }

    @Override
    public Set<ConstraintCheckIssue> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, "STATIC_METHODS_MAY_NOT_BE_ANNOTATED");
    }

    private Set<ConstraintCheckIssue> checkInternal(Element element, AnnotationMirror annotation, String messageKey) {
        if (this.isStaticElement(element)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, messageKey, new Object[0]));
        }
        return Collections.emptySet();
    }

    private boolean isStaticElement(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }
}

